/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.util;

import ai.djl.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NeuronUtils {
    private static final Logger logger = LoggerFactory.getLogger(NeuronUtils.class);

    private NeuronUtils() {
    }

    public static boolean hasNeuron() {
        return NeuronUtils.getNeuronCores() > 0;
    }

    public static int getNeuronCores() {
        List<String> nd = NeuronUtils.getNeuronDevices("/dev/");
        if (nd.isEmpty()) {
            return 0;
        }
        int cores = NeuronUtils.getNeuronCoresForDevice(nd.get(0));
        return nd.size() * cores;
    }

    public static List<String> getNeuronDevices(String location) {
        List<String> list;
        block9: {
            Path path = Paths.get(location, new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                return Collections.emptyList();
            }
            Stream<Path> dev = Files.list(path);
            try {
                list = dev.filter(p -> NeuronUtils.matches(p, "neuron")).map(p -> "/sys/devices/virtual/neuron_device/" + p.toFile().getName()).collect(Collectors.toList());
                if (dev == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (dev != null) {
                        try {
                            dev.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    logger.warn("Failed to list neuron cores", (Throwable)e);
                    return Collections.emptyList();
                }
            }
            dev.close();
        }
        return list;
    }

    public static int getNeuronCoresForDevice(String location) {
        int n;
        block19: {
            Path path = Paths.get(location, new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                return 0;
            }
            Path file = path.resolve("core_count");
            if (Files.exists(file, new LinkOption[0]) && Files.isReadable(file)) {
                int n2;
                block18: {
                    InputStream is = Files.newInputStream(file, new OpenOption[0]);
                    try {
                        n2 = Integer.parseInt(Utils.toString(is));
                        if (is == null) break block18;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            throw new AssertionError("Failed to read core_count file", e);
                        }
                    }
                    is.close();
                }
                return n2;
            }
            int count = 0;
            Stream<Path> dev = Files.list(path);
            try {
                n = Math.toIntExact(dev.filter(p -> NeuronUtils.matches(p, "neuron_core")).count());
                if (dev == null) break block19;
            }
            catch (Throwable throwable) {
                try {
                    if (dev != null) {
                        try {
                            dev.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    logger.warn("Failed to list neuron cores", (Throwable)e);
                    return count;
                }
            }
            dev.close();
        }
        return n;
    }

    private static boolean matches(Path p, String pattern) {
        return p.toFile().getName().startsWith(pattern);
    }
}

