/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.regression.evaluation;

import java.util.List;
import java.util.function.ToDoubleBiFunction;
import org.tribuo.ImmutableOutputInfo;
import org.tribuo.Model;
import org.tribuo.Prediction;
import org.tribuo.evaluation.metrics.EvaluationMetric;
import org.tribuo.evaluation.metrics.MetricContext;
import org.tribuo.evaluation.metrics.MetricTarget;
import org.tribuo.regression.Regressor;
import org.tribuo.regression.evaluation.RegressionSufficientStatistics;

public class RegressionMetric
implements EvaluationMetric<Regressor, Context> {
    private final MetricTarget<Regressor> tgt;
    private final String name;
    private final ToDoubleBiFunction<MetricTarget<Regressor>, Context> impl;
    private final boolean useExampleWeights;

    public RegressionMetric(MetricTarget<Regressor> tgt, String name, ToDoubleBiFunction<MetricTarget<Regressor>, Context> impl) {
        this(tgt, name, impl, false);
    }

    public RegressionMetric(MetricTarget<Regressor> tgt, String name, ToDoubleBiFunction<MetricTarget<Regressor>, Context> impl, boolean useExampleWeights) {
        this.tgt = tgt;
        this.name = name;
        this.impl = impl;
        this.useExampleWeights = useExampleWeights;
    }

    public double compute(Context context) {
        return this.impl.applyAsDouble(this.tgt, context);
    }

    public MetricTarget<Regressor> getTarget() {
        return this.tgt;
    }

    public String getName() {
        return this.name;
    }

    public Context createContext(Model<Regressor> model, List<Prediction<Regressor>> predictions) {
        return new Context(model, predictions, this.useExampleWeights);
    }

    static class Context
    extends MetricContext<Regressor> {
        private final RegressionSufficientStatistics memo;

        Context(Model<Regressor> model, List<Prediction<Regressor>> predictions, boolean useExampleWeights) {
            super(model, predictions);
            this.memo = new RegressionSufficientStatistics((ImmutableOutputInfo<Regressor>)model.getOutputIDInfo(), predictions, useExampleWeights);
        }

        RegressionSufficientStatistics getMemo() {
            return this.memo;
        }
    }
}

