/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.profile.logic;

import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;

public class EntityRegexPredicate
implements Predicate<EntityDescriptor> {
    @Nonnull
    private final Pattern pattern;

    public EntityRegexPredicate(@Nonnull @ParameterName(name="exp") Pattern exp) {
        this.pattern = Constraint.isNotNull(exp, "Pattern cannot be null");
    }

    @Override
    public boolean test(@Nullable EntityDescriptor input) {
        if (input == null || input.getEntityID() == null) {
            return false;
        }
        return this.pattern.matcher(input.getEntityID()).matches();
    }
}

