/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cli;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Locale;
import java.util.TreeSet;
import net.sourceforge.plantuml.cli.CliFlag;

public class HelpGroup
implements Iterable<CliFlag> {
    private static final Comparator<CliFlag> COMPARATOR = new Comparator<CliFlag>(){

        private String clean(String s) {
            String onlyLetters = s.replaceAll("\\W", "").toLowerCase(Locale.US);
            if (s.trim().startsWith("--")) {
                return onlyLetters.charAt(0) + onlyLetters;
            }
            return onlyLetters;
        }

        @Override
        public int compare(CliFlag flag1, CliFlag flag2) {
            String usage1 = this.clean(flag1.getUsage());
            String usage2 = this.clean(flag2.getUsage());
            return usage1.compareTo(usage2);
        }
    };
    private final String title;
    private final Collection<CliFlag> flags = new TreeSet<CliFlag>(COMPARATOR);

    public HelpGroup(String title) {
        this.title = title;
    }

    public void append(CliFlag flag2) {
        this.flags.add(flag2);
    }

    public String getTitle() {
        return this.title;
    }

    @Override
    public Iterator<CliFlag> iterator() {
        return this.flags.iterator();
    }
}

