/*
 * Decompiled with CFR 0.152.
 */
package io.github.z4kn4fein.semver.constraints;

import io.github.z4kn4fein.semver.Version;
import io.github.z4kn4fein.semver.VersionExtensionsKt;
import io.github.z4kn4fein.semver.constraints.Condition;
import io.github.z4kn4fein.semver.constraints.ConstraintFormatException;
import io.github.z4kn4fein.semver.constraints.Op;
import io.github.z4kn4fein.semver.constraints.Range;
import io.github.z4kn4fein.semver.constraints.VersionComparator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0080\b\u0018\u0000 +2\u00020\u0001:\u0001+B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\bJ\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u001e\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u001f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010 \u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010!\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003JC\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010#\u001a\u00020\f2\b\u0010$\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010%\u001a\u00020\u0012H\u00d6\u0001J\u0010\u0010&\u001a\u00020'2\b\b\u0002\u0010(\u001a\u00020)J\b\u0010*\u001a\u00020\u0003H\u0016R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\rR\u0011\u0010\u000e\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u000f\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0010\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\nR\u0011\u0010\u0016\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0014R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\nR\u0011\u0010\u0019\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0014R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\nR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\n\u00a8\u0006,"}, d2={"Lio/github/z4kn4fein/semver/constraints/VersionDescriptor;", "", "majorString", "", "minorString", "patchString", "preRelease", "buildMetadata", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getBuildMetadata", "()Ljava/lang/String;", "isMajorWildcard", "", "()Z", "isMinorWildcard", "isPatchWildcard", "isWildcard", "major", "", "getMajor", "()I", "getMajorString", "minor", "getMinor", "getMinorString", "patch", "getPatch", "getPatchString", "getPreRelease", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "toComparator", "Lio/github/z4kn4fein/semver/constraints/VersionComparator;", "operator", "Lio/github/z4kn4fein/semver/constraints/Op;", "toString", "Companion", "semver"})
@SourceDebugExtension(value={"SMAP\nVersionDescriptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VersionDescriptor.kt\nio/github/z4kn4fein/semver/constraints/VersionDescriptor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,77:1\n1#2:78\n*E\n"})
public final class VersionDescriptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String majorString;
    @Nullable
    private final String minorString;
    @Nullable
    private final String patchString;
    @Nullable
    private final String preRelease;
    @Nullable
    private final String buildMetadata;
    private final boolean isMajorWildcard;
    private final boolean isMinorWildcard;
    private final boolean isPatchWildcard;
    private final boolean isWildcard;
    @NotNull
    private static final String[] wildcards;

    public VersionDescriptor(@NotNull String majorString, @Nullable String minorString, @Nullable String patchString, @Nullable String preRelease, @Nullable String buildMetadata) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        String it;
        VersionDescriptor versionDescriptor;
        Intrinsics.checkNotNullParameter((Object)majorString, (String)"majorString");
        this.majorString = majorString;
        this.minorString = minorString;
        this.patchString = patchString;
        this.preRelease = preRelease;
        this.buildMetadata = buildMetadata;
        this.isMajorWildcard = ArraysKt.contains((Object[])wildcards, (Object)this.majorString);
        VersionDescriptor versionDescriptor2 = this;
        String string = this.minorString;
        if (string != null) {
            String string2 = string;
            versionDescriptor = versionDescriptor2;
            boolean bl4 = false;
            bl3 = ArraysKt.contains((Object[])wildcards, (Object)it);
            versionDescriptor2 = versionDescriptor;
            bl2 = bl3;
        } else {
            bl2 = true;
        }
        versionDescriptor2.isMinorWildcard = bl2;
        VersionDescriptor versionDescriptor3 = this;
        String string3 = this.patchString;
        if (string3 != null) {
            it = string3;
            versionDescriptor = versionDescriptor3;
            boolean bl5 = false;
            bl3 = ArraysKt.contains((Object[])wildcards, (Object)it);
            versionDescriptor3 = versionDescriptor;
            bl = bl3;
        } else {
            bl = true;
        }
        versionDescriptor3.isPatchWildcard = bl;
        this.isWildcard = this.isMajorWildcard || this.isMinorWildcard || this.isPatchWildcard;
    }

    public /* synthetic */ VersionDescriptor(String string, String string2, String string3, String string4, String string5, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            string4 = null;
        }
        if ((n & 0x10) != 0) {
            string5 = null;
        }
        this(string, string2, string3, string4, string5);
    }

    @NotNull
    public final String getMajorString() {
        return this.majorString;
    }

    @Nullable
    public final String getMinorString() {
        return this.minorString;
    }

    @Nullable
    public final String getPatchString() {
        return this.patchString;
    }

    @Nullable
    public final String getPreRelease() {
        return this.preRelease;
    }

    @Nullable
    public final String getBuildMetadata() {
        return this.buildMetadata;
    }

    @NotNull
    public String toString() {
        String string;
        StringBuilder stringBuilder;
        block15: {
            block14: {
                String string2;
                StringBuilder stringBuilder2;
                StringBuilder stringBuilder3;
                String it;
                block13: {
                    block12: {
                        String string3;
                        StringBuilder stringBuilder4;
                        block11: {
                            block10: {
                                String string4;
                                StringBuilder stringBuilder5;
                                block9: {
                                    block8: {
                                        stringBuilder5 = new StringBuilder().append(this.majorString);
                                        string4 = this.minorString;
                                        if (string4 == null) break block8;
                                        it = string4;
                                        stringBuilder3 = stringBuilder5;
                                        boolean bl = false;
                                        String string5 = '.' + this.minorString;
                                        stringBuilder5 = stringBuilder3;
                                        string4 = string5;
                                        if (string5 != null) break block9;
                                    }
                                    string4 = "";
                                }
                                stringBuilder4 = stringBuilder5.append(string4);
                                string3 = this.patchString;
                                if (string3 == null) break block10;
                                it = string3;
                                stringBuilder3 = stringBuilder4;
                                boolean bl = false;
                                String string6 = '.' + this.patchString;
                                stringBuilder4 = stringBuilder3;
                                string3 = string6;
                                if (string6 != null) break block11;
                            }
                            string3 = "";
                        }
                        stringBuilder2 = stringBuilder4.append(string3);
                        string2 = this.preRelease;
                        if (string2 == null) break block12;
                        it = string2;
                        stringBuilder3 = stringBuilder2;
                        boolean bl = false;
                        String string7 = '-' + this.preRelease;
                        stringBuilder2 = stringBuilder3;
                        string2 = string7;
                        if (string7 != null) break block13;
                    }
                    string2 = "";
                }
                stringBuilder = stringBuilder2.append(string2);
                string = this.buildMetadata;
                if (string == null) break block14;
                it = string;
                stringBuilder3 = stringBuilder;
                boolean bl = false;
                String string8 = '+' + this.buildMetadata;
                stringBuilder = stringBuilder3;
                string = string8;
                if (string8 != null) break block15;
            }
            string = "";
        }
        return stringBuilder.append(string).toString();
    }

    public final boolean isMajorWildcard() {
        return this.isMajorWildcard;
    }

    public final boolean isMinorWildcard() {
        return this.isMinorWildcard;
    }

    public final boolean isPatchWildcard() {
        return this.isPatchWildcard;
    }

    public final boolean isWildcard() {
        return this.isWildcard;
    }

    public final int getMajor() {
        Integer n = StringsKt.toIntOrNull((String)this.majorString);
        if (n == null) {
            throw new ConstraintFormatException("Invalid MAJOR number in: " + this);
        }
        return n;
    }

    public final int getMinor() {
        Object object = this.minorString;
        if (object == null || (object = StringsKt.toIntOrNull((String)object)) == null) {
            throw new ConstraintFormatException("Invalid MINOR number in: " + this);
        }
        return (Integer)object;
    }

    public final int getPatch() {
        Object object = this.patchString;
        if (object == null || (object = StringsKt.toIntOrNull((String)object)) == null) {
            throw new ConstraintFormatException("Invalid PATCH number in: " + this);
        }
        return (Integer)object;
    }

    @NotNull
    public final VersionComparator toComparator(@NotNull Op operator) {
        VersionComparator versionComparator;
        Intrinsics.checkNotNullParameter((Object)((Object)operator), (String)"operator");
        if (this.isMajorWildcard) {
            switch (WhenMappings.$EnumSwitchMapping$0[operator.ordinal()]) {
                case 1: 
                case 2: 
                case 3: {
                    versionComparator = new Condition(Op.LESS_THAN, Version.copy$default(Version.Companion.getMin(), 0, 0, 0, "", null, 23, null));
                    break;
                }
                default: {
                    versionComparator = VersionComparator.Companion.getGreaterThanMin();
                    break;
                }
            }
        } else if (this.isMinorWildcard) {
            Version version = new Version(this.getMajor(), 0, 0, this.preRelease, this.buildMetadata, 6, null);
            versionComparator = new Range(new Condition(Op.GREATER_THAN_OR_EQUAL, version), new Condition(Op.LESS_THAN, VersionExtensionsKt.nextMajor(version, "")), operator);
        } else if (this.isPatchWildcard) {
            Version version = new Version(this.getMajor(), this.getMinor(), 0, this.preRelease, this.buildMetadata, 4, null);
            versionComparator = new Range(new Condition(Op.GREATER_THAN_OR_EQUAL, version), new Condition(Op.LESS_THAN, VersionExtensionsKt.nextMinor(version, "")), operator);
        } else {
            versionComparator = new Condition(operator, new Version(this.getMajor(), this.getMinor(), this.getPatch(), this.preRelease, this.buildMetadata));
        }
        return versionComparator;
    }

    public static /* synthetic */ VersionComparator toComparator$default(VersionDescriptor versionDescriptor, Op op, int n, Object object) {
        if ((n & 1) != 0) {
            op = Op.EQUAL;
        }
        return versionDescriptor.toComparator(op);
    }

    @NotNull
    public final String component1() {
        return this.majorString;
    }

    @Nullable
    public final String component2() {
        return this.minorString;
    }

    @Nullable
    public final String component3() {
        return this.patchString;
    }

    @Nullable
    public final String component4() {
        return this.preRelease;
    }

    @Nullable
    public final String component5() {
        return this.buildMetadata;
    }

    @NotNull
    public final VersionDescriptor copy(@NotNull String majorString, @Nullable String minorString, @Nullable String patchString, @Nullable String preRelease, @Nullable String buildMetadata) {
        Intrinsics.checkNotNullParameter((Object)majorString, (String)"majorString");
        return new VersionDescriptor(majorString, minorString, patchString, preRelease, buildMetadata);
    }

    public static /* synthetic */ VersionDescriptor copy$default(VersionDescriptor versionDescriptor, String string, String string2, String string3, String string4, String string5, int n, Object object) {
        if ((n & 1) != 0) {
            string = versionDescriptor.majorString;
        }
        if ((n & 2) != 0) {
            string2 = versionDescriptor.minorString;
        }
        if ((n & 4) != 0) {
            string3 = versionDescriptor.patchString;
        }
        if ((n & 8) != 0) {
            string4 = versionDescriptor.preRelease;
        }
        if ((n & 0x10) != 0) {
            string5 = versionDescriptor.buildMetadata;
        }
        return versionDescriptor.copy(string, string2, string3, string4, string5);
    }

    public int hashCode() {
        int result = this.majorString.hashCode();
        result = result * 31 + (this.minorString == null ? 0 : this.minorString.hashCode());
        result = result * 31 + (this.patchString == null ? 0 : this.patchString.hashCode());
        result = result * 31 + (this.preRelease == null ? 0 : this.preRelease.hashCode());
        result = result * 31 + (this.buildMetadata == null ? 0 : this.buildMetadata.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof VersionDescriptor)) {
            return false;
        }
        VersionDescriptor versionDescriptor = (VersionDescriptor)other;
        if (!Intrinsics.areEqual((Object)this.majorString, (Object)versionDescriptor.majorString)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.minorString, (Object)versionDescriptor.minorString)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.patchString, (Object)versionDescriptor.patchString)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.preRelease, (Object)versionDescriptor.preRelease)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.buildMetadata, (Object)versionDescriptor.buildMetadata);
    }

    static {
        String[] stringArray = new String[]{"*", "x", "X"};
        wildcards = stringArray;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lio/github/z4kn4fein/semver/constraints/VersionDescriptor$Companion;", "", "()V", "wildcards", "", "", "[Ljava/lang/String;", "semver"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Op.values().length];
            try {
                nArray[Op.GREATER_THAN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Op.LESS_THAN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Op.NOT_EQUAL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

