/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.pyproject.model.internal;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectAware;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectId;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectListener;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectReloadContext;
import com.intellij.openapi.project.Project;
import com.intellij.python.pyproject.model.internal.PlatformToolsKt;
import java.nio.file.Path;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/python/pyproject/model/internal/PyExternalSystemProjectAware;", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectAware;", "projectId", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectId;", "settingsFiles", "", "", "project", "Lcom/intellij/openapi/project/Project;", "projectModelRoot", "Ljava/nio/file/Path;", "<init>", "(Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectId;Ljava/util/Set;Lcom/intellij/openapi/project/Project;Ljava/nio/file/Path;)V", "getProjectId", "()Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectId;", "getSettingsFiles", "()Ljava/util/Set;", "subscribe", "", "listener", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectListener;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "reloadProject", "context", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectReloadContext;", "intellij.python.pyproject"})
public final class PyExternalSystemProjectAware
implements ExternalSystemProjectAware {
    @NotNull
    private final ExternalSystemProjectId projectId;
    @NotNull
    private final Set<String> settingsFiles;
    @NotNull
    private final Project project;
    @NotNull
    private final Path projectModelRoot;

    public PyExternalSystemProjectAware(@NotNull ExternalSystemProjectId projectId, @NotNull Set<String> settingsFiles, @NotNull Project project, @NotNull Path projectModelRoot2) {
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        Intrinsics.checkNotNullParameter(settingsFiles, (String)"settingsFiles");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)projectModelRoot2, (String)"projectModelRoot");
        this.projectId = projectId;
        this.settingsFiles = settingsFiles;
        this.project = project;
        this.projectModelRoot = projectModelRoot2;
    }

    @NotNull
    public ExternalSystemProjectId getProjectId() {
        return this.projectId;
    }

    @NotNull
    public Set<String> getSettingsFiles() {
        return this.settingsFiles;
    }

    public void subscribe(@NotNull ExternalSystemProjectListener listener, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.project.getMessageBus().connect(parentDisposable).subscribe(PlatformToolsKt.getPROJECT_AWARE_TOPIC(), (Object)listener);
    }

    public void reloadProject(@NotNull ExternalSystemProjectReloadContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PlatformToolsKt.linkProjectWithProgressInBackground(this.project, this.projectModelRoot);
    }
}

