/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.CsvFormatter;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.extractors.ExtractionConfig;
import com.intellij.database.extractors.GridExtractorsUtilCore;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.extractors.ObjectFormatterMode;
import com.intellij.database.extractors.TranspositionAwareExtractor;
import com.intellij.database.util.Out;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FormatBasedExtractor
extends TranspositionAwareExtractor {
    private static final Pattern FILE_EXTENSION_PATTERN = Pattern.compile("[A-Z]{2,}");
    private final CsvFormat myFormat;

    public FormatBasedExtractor(@NotNull CsvFormat format, @NotNull ObjectFormatter formatter) {
        if (format == null) {
            FormatBasedExtractor.$$$reportNull$$$0(0);
        }
        if (formatter == null) {
            FormatBasedExtractor.$$$reportNull$$$0(1);
        }
        super(formatter);
        this.myFormat = format;
    }

    @Override
    @NotNull
    public String getFileExtension() {
        String ext = FormatBasedExtractor.getFileExtension(this.myFormat);
        String string = ext != null ? ext : super.getFileExtension();
        if (string == null) {
            FormatBasedExtractor.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public boolean supportsText() {
        return true;
    }

    @Nullable
    public static String getFileExtension(@NotNull CsvFormat format) {
        Matcher m;
        if (format == null) {
            FormatBasedExtractor.$$$reportNull$$$0(3);
        }
        String ext = (m = FILE_EXTENSION_PATTERN.matcher(format.name)).find() ? m.group() : null;
        return StringUtil.isNotEmpty((String)ext) ? StringUtil.toLowerCase((String)ext) : null;
    }

    @NotNull
    private static CsvFormat adjust(@NotNull CsvFormat format, @Nullable Boolean addColumnHeader, @Nullable Boolean addRowHeader) {
        if (format == null) {
            FormatBasedExtractor.$$$reportNull$$$0(4);
        }
        if (format.headerRecord == null && Boolean.TRUE.equals(addColumnHeader)) {
            format = new CsvFormat(format.name, format.dataRecord, format.dataRecord, format.rowNumbers);
        } else if (format.headerRecord != null && Boolean.FALSE.equals(addColumnHeader)) {
            format = new CsvFormat(format.name, format.dataRecord, null, format.rowNumbers);
        }
        if (addRowHeader != null && format.rowNumbers != addRowHeader) {
            format = new CsvFormat(format.name, format.dataRecord, format.headerRecord, addRowHeader.booleanValue());
        }
        CsvFormat csvFormat = format;
        if (csvFormat == null) {
            FormatBasedExtractor.$$$reportNull$$$0(5);
        }
        return csvFormat;
    }

    @Override
    public TranspositionAwareExtractor.TranspositionAwareExtraction startExtraction(final @NotNull Out out, @NotNull List<? extends GridColumn> allColumns, @NotNull String query, @NotNull ExtractionConfig config, int ... selectedColumns) {
        if (out == null) {
            FormatBasedExtractor.$$$reportNull$$$0(6);
        }
        if (allColumns == null) {
            FormatBasedExtractor.$$$reportNull$$$0(7);
        }
        if (query == null) {
            FormatBasedExtractor.$$$reportNull$$$0(8);
        }
        if (config == null) {
            FormatBasedExtractor.$$$reportNull$$$0(9);
        }
        final CsvFormat format = FormatBasedExtractor.adjust(this.myFormat, config.getAddColumnHeader(), config.getAddRowHeader());
        return new TranspositionAwareExtractor.TranspositionAwareExtraction(out, config, allColumns, query, selectedColumns, this){
            private final CsvFormatter myFormatter;
            {
                super(out3, config, allColumns, query, selectedColumnIndices, extractor);
                this.myFormatter = new CsvFormatter(format);
            }

            @Override
            protected void doAppendData(List<? extends GridRow> rows) {
                ArrayList columns = new ArrayList();
                Int2ObjectMap columnsMap = GridExtractorsUtilCore.getColumnNumsToColumnsMapping(this.myAllColumns);
                for (int selectedColumn : GridExtractorsUtilCore.getNonEmptySelection(this.myAllColumns, this.mySelectedColumnIndices)) {
                    ContainerUtil.addIfNotNull(columns, (Object)((GridColumn)columnsMap.get(selectedColumn)));
                }
                Object object = rows.iterator();
                while (object.hasNext()) {
                    GridRow row = (GridRow)object.next();
                    List values = ContainerUtil.map(columns, column -> FormatBasedExtractor.this.getValueAsString(row, (GridColumn)column, ObjectFormatterMode.DEFAULT));
                    if (this.myFormatter.requiresRowNumbers()) {
                        values = ContainerUtil.prepend((List)values, (Object[])new Object[]{this.getRowNumber(row)});
                    }
                    out.appendText(this.myFormatter.formatRecord(values));
                    out.appendText(this.myFormatter.recordSeparator());
                }
            }

            @Override
            protected void doAppendHeader(boolean appendNewLine) {
                if (format.headerRecord == null) {
                    return;
                }
                ArrayList<String> columnNames = new ArrayList<String>();
                if (this.myFormatter.requiresRowNumbers()) {
                    columnNames.add(this.getRowNumbersColumn().getName());
                }
                Int2ObjectMap columnsMap = GridExtractorsUtilCore.getColumnNumsToColumnsMapping(this.myAllColumns);
                for (int selectedColumn : GridExtractorsUtilCore.getNonEmptySelection(this.myAllColumns, this.mySelectedColumnIndices)) {
                    GridColumn column = (GridColumn)columnsMap.get(selectedColumn);
                    if (column == null) continue;
                    columnNames.add(column.getName());
                }
                out.appendText(this.myFormatter.formatHeader(columnNames));
                out.appendText(this.myFormatter.recordSeparator());
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatter";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/extractors/FormatBasedExtractor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allColumns";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/extractors/FormatBasedExtractor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileExtension";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "adjust";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFileExtension";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "adjust";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "startExtraction";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5 -> new IllegalStateException(string);
        };
    }
}

