"""A list of Impala keywords.

https://impala.apache.org/docs/build/html/topics/impala_reserved_words.html

Impala docs recommend respecting Hive keywords, so both lists include Hive's as well.
"""

RESERVED_KEYWORDS = [
    "ADD",
    "AGGREGATE",
    "ALL",
    "ALLOCATE",
    "ALTER",
    "ANALYTIC",
    "AND",
    "ANTI",
    "ANY",
    "API_VERSION",
    "ARE",
    "ARRAY",
    "ARRAY_AGG",
    "ARRAY_MAX_CARDINALITY",
    "AS",
    "ASC",
    "ASENSITIVE",
    "ASYMMETRIC",
    "AT",
    "ATOMIC",
    "AUTHORIZATION",
    "AVRO",
    "BEGIN_FRAME",
    "BEGIN_PARTITION",
    "BETWEEN",
    "BIGINT",
    "BINARY",
    "BLOB",
    "BLOCK_SIZE",
    "BOOLEAN",
    "BOTH",
    "BUCKETS",
    "BY",
    "CACHED",
    "CALLED",
    "CARDINALITY",
    "CASCADE",
    "CASCADED",
    "CASE",
    "CAST",
    "CHANGE",
    "CHAR",
    "CHARACTER",
    "CLASS",
    "CLOB",
    "CLOSE_FN",
    "COLLATE",
    "COLLECT",
    "COLUMN",
    "COLUMNS",
    "COMMENT",
    "COMMIT",
    "COMPRESSION",
    "COMPUTE",
    "CONDITION",
    "CONNECT",
    "CONSTRAINT",
    "CONTAINS",
    "CONVERT",
    "COPY",
    "CORR",
    "CORRESPONDING",
    "COVAR_POP",
    "COVAR_SAMP",
    "CREATE",
    "CROSS",
    "CUBE",
    "CURRENT",
    "CURRENT_DATE",
    "CURRENT_DEFAULT_TRANSFORM_GROUP",
    "CURRENT_PATH",
    "CURRENT_ROLE",
    "CURRENT_ROW",
    "CURRENT_SCHEMA",
    "CURRENT_TIME",
    "CURRENT_TRANSFORM_GROUP_FOR_TYPE",
    "CURSOR",
    "CYCLE",
    "DATA",
    "DATABASE",
    "DATABASES",
    "DATE",
    "DATETIME",
    "DEALLOCATE",
    "DEC",
    "DECFLOAT",
    "DECIMAL",
    "DECLARE",
    "DEFAULT",
    "DEFINE",
    "DELETE",
    "DELIMITED",
    "DEREF",
    "DESC",
    "DESCRIBE",
    "DETERMINISTIC",
    "DISABLE",
    "DISCONNECT",
    "DISTINCT",
    "DIV",
    "DOUBLE",
    "DROP",
    "DYNAMIC",
    "EACH",
    "ELEMENT",
    "ELSE",
    "EMPTY",
    "ENABLE",
    "ENCODING",
    "END",
    "END-EXEC",
    "END_FRAME",
    "END_PARTITION",
    "EQUALS",
    "ESCAPE",
    "ESCAPED",
    "EVERY",
    "EXCEPT",
    "EXEC",
    "EXECUTE",
    "EXISTS",
    "EXPLAIN",
    "EXTENDED",
    "EXTERNAL",
    "FALSE",
    "FETCH",
    "FIELDS",
    "FILEFORMAT",
    "FILES",
    "FILTER",
    "FINALIZE_FN",
    "FIRST",
    "FLOAT",
    "FOLLOWING",
    "FOR",
    "FOREIGN",
    "FORMAT",
    "FORMATTED",
    "FRAME_ROW",
    "FREE",
    "FROM",
    "FULL",
    "FUNCTION",
    "FUNCTIONS",
    "FUSION",
    "GET",
    "GLOBAL",
    "GRANT",
    "GROUP",
    "GROUPING",
    "GROUPS",
    "HASH",
    "HAVING",
    "HOLD",
    "HUDIPARQUET",
    "ICEBERG",
    "IF",
    "IGNORE",
    "ILIKE",
    "IN",
    "INCREMENTAL",
    "INDICATOR",
    "INIT_FN",
    "INITIAL",
    "INNER",
    "INOUT",
    "INPATH",
    "INSENSITIVE",
    "INSERT",
    "INT",
    "INTEGER",
    "INTERMEDIATE",
    "INTERSECT",
    "INTERSECTION",
    "INTERVAL",
    "INTO",
    "INVALIDATE",
    "IREGEXP",
    "IS",
    "JOIN",
    "JSONFILE",
    "JSON_ARRAY",
    "JSON_ARRAYAGG",
    "JSON_EXISTS",
    "JSON_OBJECT",
    "JSON_OBJECTAGG",
    "JSON_QUERY",
    "JSON_TABLE",
    "JSON_TABLE_PRIMITIVE",
    "JSON_VALUE",
    "KUDU",
    "LARGE",
    "LAST",
    "LATERAL",
    "LEADING",
    "LEFT",
    "LEXICAL",
    "LIKE",
    "LIKE_REGEX",
    "LIMIT",
    "LINES",
    "LISTAGG",
    "LOAD",
    "LOCAL",
    "LOCALTIMESTAMP",
    "LOCATION",
    "LOG10",
    "MAP",
    "MANAGEDLOCATION",
    "MATCH",
    "MATCH_NUMBER",
    "MATCH_RECOGNIZE",
    "MATCHES",
    "MERGE",
    "MERGE_FN",
    "METADATA",
    "METHOD",
    "MINUS",
    "MODIFIES",
    "MULTISET",
    "NATIONAL",
    "NATURAL",
    "NCHAR",
    "NCLOB",
    "NO",
    "NON",
    "NONE",
    "NORELY",
    "NORMALIZE",
    "NOT",
    "NOVALIDATE",
    "NTH_VALUE",
    "NULL",
    "NULLS",
    "NUMERIC",
    "OCCURRENCES_REGEX",
    "OCTET_LENGTH",
    "OF",
    "OFFSET",
    "OMIT",
    "ON",
    "ONE",
    "ONLY",
    "OPTIMIZE",
    "OR",
    "ORC",
    "ORDER",
    "OUT",
    "OUTER",
    "OVER",
    "OVERLAPS",
    "OVERLAY",
    "OVERWRITE",
    "PARQUET",
    "PARQUETFILE",
    "PARTITION",
    "PARTITIONED",
    "PARTITIONS",
    "PATTERN",
    "PER",
    "PERCENT",
    "PERCENTILE_CONT",
    "PERCENTILE_DISC",
    "PORTION",
    "POSITION",
    "POSITION_REGEX",
    "PRECEDES",
    "PRECEDING",
    "PREPARE",
    "PREPARE_FN",
    "PRIMARY",
    "PROCEDURE",
    "PRODUCED",
    "PTF",
    "PURGE",
    "RANGE",
    "RCFILE",
    "READS",
    "REAL",
    "RECOVER",
    "RECURSIVE",
    "REF",
    "REFERENCES",
    "REFERENCING",
    "REFRESH",
    "REGEXP",
    "REGR_AVGX",
    "REGR_AVGY",
    "REGR_COUNT",
    "REGR_INTERCEPT",
    "REGR_R2",
    "REGR_SLOPE",
    "REGR_SXX",
    "REGR_SXY",
    "REGR_SYY",
    "RELEASE",
    "RELY",
    "RENAME",
    "REPEATABLE",
    "REPLACE",
    "REPLICATION",
    "RESTRICT",
    "RETURNS",
    "REVOKE",
    "RIGHT",
    "RLIKE",
    "ROLE",
    "ROLES",
    "ROLLBACK",
    "ROLLUP",
    "ROW",
    "ROWS",
    "RUNNING",
    "RWSTORAGE",
    "SAVEPOINT",
    "SCHEMA",
    "SCHEMAS",
    "SCOPE",
    "SCROLL",
    "SEARCH",
    "SEEK",
    "SELECT",
    "SELECTIVITY",
    "SEMI",
    "SENSITIVE",
    "SEQUENCEFILE",
    "SERDEPROPERTIES",
    "SERIALIZE_FN",
    "SET",
    "SETS",
    "SHOW",
    "SIMILAR",
    "SKIP",
    "SMALLINT",
    "SOME",
    "SORT",
    "SPEC",
    "SPECIFIC",
    "SPECIFICTYPE",
    "SQLEXCEPTION",
    "SQLSTATE",
    "SQLWARNING",
    "STATIC",
    "STATS",
    "STORAGEHANDLER_URI",
    "STORED",
    "STRAIGHT_JOIN",
    "STRING",
    "STRUCT",
    "SUBMULTISET",
    "SUBSET",
    "SUBSTRING_REGEX",
    "SUCCEEDS",
    "SYMBOL",
    "SYMMETRIC",
    "SYSTEM_TIME",
    "SYSTEM_USER",
    "SYSTEM_VERSION",
    "TABLE",
    "TABLES",
    "TABLESAMPLE",
    "TBLPROPERTIES",
    "TERMINATED",
    "TEXTFILE",
    "THEN",
    "TIMESTAMP",
    "TIMEZONE_HOUR",
    "TIMEZONE_MINUTE",
    "TINYINT",
    "TO",
    "TRAILING",
    "TRANSLATE_REGEX",
    "TRANSLATION",
    "TREAT",
    "TRIGGER",
    "TRIM_ARRAY",
    "TRUE",
    "TRUNCATE",
    "UESCAPE",
    "UNBOUNDED",
    "UNCACHED",
    "UNION",
    "UNIQUE",
    "UNKNOWN",
    "UNNEST",
    "UNSET",
    "UPDATE",
    "UPDATE_FN",
    "UPSERT",
    "USE",
    "USER_DEFINED_FN",
    "USING",
    "VALIDATE",
    "VALUE_OF",
    "VALUES",
    "VARBINARY",
    "VARCHAR",
    "VARYING",
    "VERSIONING",
    "VIEW",
    "WHEN",
    "WHENEVER",
    "WHERE",
    "WIDTH_BUCKET",
    "WINDOW",
    "WITH",
    "WITHIN",
    "WITHOUT",
    "ZORDER",
    "CONF",
    "CURRENT_TIMESTAMP",
    "EXCHANGE",
    "IMPORT",
    "LESS",
    "MACRO",
    "MORE",
    "PARTIALSCAN",
    "PRESERVE",
    "REDUCE",
    "TRANSFORM",
    "UNIQUEJOIN",
    "USER",
    "UTC_TMESTAMP",
    "START",
    "CACHE",
    "DAYOFWEEK",
    "EXTRACT",
    "FLOOR",
    "PRECISION",
    "VIEWS",
    "TIME",
    "SYNC",
]

UNRESERVED_KEYWORDS = [
    # Impala-specific
    "SHUFFLE",
    "NOSHUFFLE",
    # Hive unreserved keywords
    "ADMIN",
    "AFTER",
    "ANALYZE",
    "ARCHIVE",
    "BEFORE",
    "BERNOULLI",
    "BUCKET",
    "CLUSTER",
    "CLUSTERED",
    "CLUSTERSTATUS",
    "COLLECTION",
    "COMPACT",
    "COMPACTIONS",
    "CONCATENATE",
    "CONTINUE",
    "DAY",
    "DBPROPERTIES",
    "DEFERRED",
    "DEFINED",
    "DEPENDENCY",
    "DIRECTORIES",
    "DIRECTORY",
    "DISTRIBUTE",
    "ELEM_TYPE",
    "EXCLUSIVE",
    "EXPORT",
    "FILE",
    "HOLD_DDLTIME",
    "HOUR",
    "IDXPROPERTIES",
    "INDEX",
    "INDEXES",
    "INPUTDRIVER",
    "INPUTFORMAT",
    "ITEMS",
    "JAR",
    "KEYS",
    "KEY_TYPE",
    "LOCK",
    "LOCKS",
    "LOGICAL",
    "LONG",
    "MAPJOIN",
    "MATERIALIZED",
    "MINUTE",
    "MONTH",
    "MSCK",
    "NOSCAN",
    "NO_DROP",
    "OFFLINE",
    "OPTION",
    "OUTPUTDRIVER",
    "OUTPUTFORMAT",
    "OWNER",
    "PLUS",
    "PRETTY",
    "PRINCIPALS",
    "PROTECTION",
    "READ",
    "READONLY",
    "REBUILD",
    "RECORDREADER",
    "RECORDWRITER",
    "RELOAD",
    "REPAIR",
    "REWRITE",
    "SECOND",
    "SERDE",
    "SERVER",
    "SHARED",
    "SHOW_DATABASE",
    "SKEWED",
    "SORTED",
    "SSL",
    "STATISTICS",
    "STREAMTABLE",
    "SYSTEM",
    "TEMPORARY",
    "TOUCH",
    "TRANSACTIONS",
    "UNARCHIVE",
    "UNDO",
    "UNIONTYPE",
    "UNLOCK",
    "UNSIGNED",
    "URI",
    "UTC",
    "UTCTIMESTAMP",
    "VALUE_TYPE",
    "WHILE",
    "YEAR",
    "AUTOCOMMIT",
    "ISOLATION",
    "LEVEL",
    "SNAPSHOT",
    "TRANSACTION",
    "WORK",
    "WRITE",
    "ABORT",
    "KEY",
    "DETAIL",
    "DOW",
    "EXPRESSION",
    "OPERATOR",
    "QUARTER",
    "SUMMARY",
    "VECTORIZATION",
    "WEEK",
    "YEARS",
    "MONTHS",
    "WEEKS",
    "DAYS",
    "HOURS",
    "MINUTES",
    "SECONDS",
    "TIMESTAMPTZ",
    "ZONE",
]
