/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.authlib.minecraft.client;

import com.mojang.authlib.exceptions.MinecraftClientException;
import com.mojang.authlib.exceptions.MinecraftClientHttpException;
import com.mojang.authlib.minecraft.client.ObjectMapper;
import com.mojang.authlib.yggdrasil.response.ErrorResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinecraftClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(MinecraftClient.class);
    public static final int CONNECT_TIMEOUT_MS = 5000;
    public static final int READ_TIMEOUT_MS = 5000;
    @Nullable
    private final String accessToken;
    private final Proxy proxy;
    private final ObjectMapper objectMapper = ObjectMapper.create();

    public MinecraftClient(@Nullable String accessToken, Proxy proxy) {
        this.accessToken = accessToken;
        this.proxy = (Proxy)Validate.notNull((Object)proxy);
    }

    public static MinecraftClient unauthenticated(Proxy proxy) {
        return new MinecraftClient(null, proxy);
    }

    @Nullable
    public <T> T get(URL url, Class<T> responseClass) {
        Validate.notNull((Object)url);
        Validate.notNull(responseClass);
        HttpURLConnection connection = this.createUrlConnection(url);
        if (this.accessToken != null) {
            connection.setRequestProperty("Authorization", "Bearer " + this.accessToken);
        }
        return this.readInputStream(url, responseClass, connection);
    }

    @Nullable
    public <T> T post(URL url, Class<T> responseClass) {
        Validate.notNull((Object)url);
        Validate.notNull(responseClass);
        HttpURLConnection connection = this.postInternal(url, new byte[0]);
        return this.readInputStream(url, responseClass, connection);
    }

    @Nullable
    public <T> T post(URL url, Object body, Class<T> responseClass) {
        Validate.notNull((Object)url);
        Validate.notNull((Object)body);
        Validate.notNull(responseClass);
        String bodyAsJson = this.objectMapper.writeValueAsString(body);
        byte[] postAsBytes = bodyAsJson.getBytes(StandardCharsets.UTF_8);
        HttpURLConnection connection = this.postInternal(url, postAsBytes);
        return this.readInputStream(url, responseClass, connection);
    }

    @Nullable
    private <T> T readInputStream(URL url, Class<T> clazz, HttpURLConnection connection) {
        int status;
        InputStream inputStream;
        block8: {
            String result;
            block9: {
                inputStream = null;
                status = connection.getResponseCode();
                if (status >= 400) break block8;
                inputStream = connection.getInputStream();
                result = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                if (!result.isEmpty()) break block9;
                T t = null;
                IOUtils.closeQuietly((InputStream)inputStream);
                return t;
            }
            T t = this.objectMapper.readValue(result, clazz);
            IOUtils.closeQuietly((InputStream)inputStream);
            return t;
        }
        try {
            try {
                String contentType = connection.getContentType();
                inputStream = connection.getErrorStream();
                if (inputStream != null) {
                    String result = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                    if (contentType != null && contentType.startsWith("text/html")) {
                        LOGGER.error("Got an error with a html body connecting to {}: {}", (Object)url.toString(), (Object)result);
                        throw new MinecraftClientHttpException(status);
                    }
                    ErrorResponse errorResponse = this.objectMapper.readValue(result, ErrorResponse.class);
                    throw new MinecraftClientHttpException(status, errorResponse);
                }
                throw new MinecraftClientHttpException(status);
            }
            catch (IOException e) {
                throw new MinecraftClientException(MinecraftClientException.ErrorType.SERVICE_UNAVAILABLE, "Failed to read from " + String.valueOf(url) + " due to " + e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(inputStream);
            throw throwable;
        }
    }

    private HttpURLConnection postInternal(URL url, byte[] postAsBytes) {
        HttpURLConnection connection = this.createUrlConnection(url);
        OutputStream outputStream = null;
        try {
            connection.setRequestProperty("Content-Type", "application/json; charset=utf-8");
            connection.setRequestProperty("Content-Length", "" + postAsBytes.length);
            if (this.accessToken != null) {
                connection.setRequestProperty("Authorization", "Bearer " + this.accessToken);
            }
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            outputStream = connection.getOutputStream();
            IOUtils.write((byte[])postAsBytes, (OutputStream)outputStream);
        }
        catch (IOException io) {
            try {
                throw new MinecraftClientException(MinecraftClientException.ErrorType.SERVICE_UNAVAILABLE, "Failed to POST " + String.valueOf(url), io);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)outputStream);
        return connection;
    }

    private HttpURLConnection createUrlConnection(URL url) {
        try {
            LOGGER.debug("Connecting to {}", (Object)url);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection(this.proxy);
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            connection.setUseCaches(false);
            return connection;
        }
        catch (IOException io) {
            throw new MinecraftClientException(MinecraftClientException.ErrorType.SERVICE_UNAVAILABLE, "Failed connecting to " + String.valueOf(url), io);
        }
    }
}

