/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.securemodules;

import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.net.spi.URLStreamHandlerProvider;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;

public class LayerAwareURLStreamHandlerFactory
implements URLStreamHandlerFactory {
    protected Map<String, Optional<URLStreamHandler>> handlers;
    private List<URLStreamHandlerProvider> services;

    protected void findProviders(ModuleLayer layer) {
        if (layer == null) {
            this.handlers = null;
            this.services = null;
        } else {
            this.handlers = new HashMap<String, Optional<URLStreamHandler>>();
            this.services = ServiceLoader.load(layer, URLStreamHandlerProvider.class).stream().map(ServiceLoader.Provider::get).toList();
        }
    }

    @Override
    public URLStreamHandler createURLStreamHandler(String protocol) {
        if (this.handlers == null) {
            return null;
        }
        Optional<URLStreamHandler> cached = this.handlers.get(protocol);
        if (cached != null) {
            return cached.orElse(null);
        }
        for (URLStreamHandlerProvider service : this.services) {
            URLStreamHandler handler = service.createURLStreamHandler(protocol);
            if (handler == null) continue;
            this.handlers.put(protocol, Optional.of(handler));
            return handler;
        }
        this.handlers.put(protocol, Optional.empty());
        return null;
    }
}

