/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.entity.living;

import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.bus.CancellableEventBus;
import net.minecraftforge.eventbus.api.event.MutableEvent;
import net.minecraftforge.eventbus.api.event.characteristic.Cancellable;

public final class ShieldBlockEvent
extends MutableEvent
implements Cancellable,
LivingEvent {
    public static final CancellableEventBus<ShieldBlockEvent> BUS = CancellableEventBus.create(ShieldBlockEvent.class);
    private final LivingEntity blocker;
    private final DamageSource source;
    private final float originalBlocked;
    private float dmgBlocked;
    private boolean shieldTakesDamage = true;
    private final ItemStack blockedWith;

    public ShieldBlockEvent(LivingEntity blocker, DamageSource source, float blocked, ItemStack blockedWith) {
        this.blocker = blocker;
        this.source = source;
        this.originalBlocked = blocked;
        this.dmgBlocked = blocked;
        this.blockedWith = blockedWith;
    }

    @Override
    public LivingEntity getEntity() {
        return this.blocker;
    }

    public DamageSource getDamageSource() {
        return this.source;
    }

    public float getOriginalBlockedDamage() {
        return this.originalBlocked;
    }

    public float getBlockedDamage() {
        return this.dmgBlocked;
    }

    public boolean shieldTakesDamage() {
        return this.shieldTakesDamage;
    }

    public void setBlockedDamage(float blocked) {
        this.dmgBlocked = Mth.clamp((float)blocked, (float)0.0f, (float)this.originalBlocked);
    }

    public void setShieldTakesDamage(boolean damage) {
        this.shieldTakesDamage = damage;
    }

    public ItemStack getBlockedWith() {
        return this.blockedWith;
    }
}

