// Code generated by smithy-go-codegen DO NOT EDIT.

package databasemigrationservice

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/databasemigrationservice/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Modifies the specified migration project using the provided parameters.
//
// The migration project must be closed before you can modify it.
func (c *Client) ModifyMigrationProject(ctx context.Context, params *ModifyMigrationProjectInput, optFns ...func(*Options)) (*ModifyMigrationProjectOutput, error) {
	if params == nil {
		params = &ModifyMigrationProjectInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ModifyMigrationProject", params, optFns, c.addOperationModifyMigrationProjectMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ModifyMigrationProjectOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ModifyMigrationProjectInput struct {

	// The identifier of the migration project. Identifiers must begin with a letter
	// and must contain only ASCII letters, digits, and hyphens. They can't end with a
	// hyphen, or contain two consecutive hyphens.
	//
	// This member is required.
	MigrationProjectIdentifier *string

	// A user-friendly description of the migration project.
	Description *string

	// The name or Amazon Resource Name (ARN) for the instance profile.
	InstanceProfileIdentifier *string

	// A user-friendly name for the migration project.
	MigrationProjectName *string

	// The schema conversion application attributes, including the Amazon S3 bucket
	// name and Amazon S3 role ARN.
	SchemaConversionApplicationAttributes *types.SCApplicationAttributes

	// Information about the source data provider, including the name, ARN, and Amazon
	// Web Services Secrets Manager parameters.
	SourceDataProviderDescriptors []types.DataProviderDescriptorDefinition

	// Information about the target data provider, including the name, ARN, and Amazon
	// Web Services Secrets Manager parameters.
	TargetDataProviderDescriptors []types.DataProviderDescriptorDefinition

	// The settings in JSON format for migration rules. Migration rules make it
	// possible for you to change the object names according to the rules that you
	// specify. For example, you can change an object name to lowercase or uppercase,
	// add or remove a prefix or suffix, or rename objects.
	TransformationRules *string

	noSmithyDocumentSerde
}

type ModifyMigrationProjectOutput struct {

	// The migration project that was modified.
	MigrationProject *types.MigrationProject

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationModifyMigrationProjectMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpModifyMigrationProject{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpModifyMigrationProject{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ModifyMigrationProject"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpModifyMigrationProjectValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opModifyMigrationProject(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opModifyMigrationProject(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ModifyMigrationProject",
	}
}
