/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.colibri2;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.xmpp.extensions.AbstractPacketExtension;
import org.jitsi.xmpp.extensions.colibri2.Colibri2Endpoint;
import org.jitsi.xmpp.extensions.colibri2.Colibri2Error;
import org.jitsi.xmpp.util.ErrorUtilKt;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.StanzaError;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0016\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u000e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u0016\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0004\u001a\u0018\u0010\t\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\b\u0010\n\u001a\u0004\u0018\u00010\u0004\u00a8\u0006\u000b"}, d2={"createConferenceAlreadyExistsError", "Lorg/jivesoftware/smack/packet/IQ;", "iq", "conferenceId", "", "createConferenceNotFoundError", "createGracefulShutdownErrorResponse", "createEndpointNotFoundError", "endpointId", "createFeatureNotImplementedError", "message", "jitsi-videobridge"})
public final class Colibri2UtilKt {
    @NotNull
    public static final IQ createConferenceAlreadyExistsError(@NotNull IQ iq, @NotNull String conferenceId) {
        Intrinsics.checkNotNullParameter((Object)iq, (String)"iq");
        Intrinsics.checkNotNullParameter((Object)conferenceId, (String)"conferenceId");
        return ErrorUtilKt.createError((IQ)iq, (StanzaError.Condition)StanzaError.Condition.conflict, (String)("Conference already exists for ID: " + conferenceId), (ExtensionElement)((ExtensionElement)new Colibri2Error(Colibri2Error.Reason.CONFERENCE_ALREADY_EXISTS)));
    }

    @NotNull
    public static final IQ createConferenceNotFoundError(@NotNull IQ iq, @NotNull String conferenceId) {
        Intrinsics.checkNotNullParameter((Object)iq, (String)"iq");
        Intrinsics.checkNotNullParameter((Object)conferenceId, (String)"conferenceId");
        return ErrorUtilKt.createError((IQ)iq, (StanzaError.Condition)StanzaError.Condition.item_not_found, (String)("Conference not found for ID: " + conferenceId), (ExtensionElement)((ExtensionElement)new Colibri2Error(Colibri2Error.Reason.CONFERENCE_NOT_FOUND)));
    }

    @NotNull
    public static final IQ createGracefulShutdownErrorResponse(@NotNull IQ iq) {
        Intrinsics.checkNotNullParameter((Object)iq, (String)"iq");
        return ErrorUtilKt.createError((IQ)iq, (StanzaError.Condition)StanzaError.Condition.service_unavailable, (String)"In graceful shutdown", (ExtensionElement)((ExtensionElement)new Colibri2Error(Colibri2Error.Reason.GRACEFUL_SHUTDOWN)));
    }

    @NotNull
    public static final IQ createEndpointNotFoundError(@NotNull IQ iq, @NotNull String endpointId) {
        Intrinsics.checkNotNullParameter((Object)iq, (String)"iq");
        Intrinsics.checkNotNullParameter((Object)endpointId, (String)"endpointId");
        Object[] objectArray = new AbstractPacketExtension[]{new Colibri2Error(Colibri2Error.Reason.UNKNOWN_ENDPOINT), Colibri2Endpoint.getBuilder().setId(endpointId).build()};
        return ErrorUtilKt.createError((IQ)iq, (StanzaError.Condition)StanzaError.Condition.item_not_found, (String)("Endpoint not found for ID: " + endpointId), (List)CollectionsKt.listOf((Object[])objectArray));
    }

    @NotNull
    public static final IQ createFeatureNotImplementedError(@NotNull IQ iq, @Nullable String message) {
        Intrinsics.checkNotNullParameter((Object)iq, (String)"iq");
        String string = message;
        if (string == null) {
            string = "";
        }
        return ErrorUtilKt.createError((IQ)iq, (StanzaError.Condition)StanzaError.Condition.feature_not_implemented, (String)string, (ExtensionElement)((ExtensionElement)new Colibri2Error(Colibri2Error.Reason.FEATURE_NOT_IMPLEMENTED)));
    }
}

