/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.export;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.mediajson.TranscriptionResultEvent;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.format.OpusPayloadType;
import org.jitsi.nlj.rtp.AudioRtpPacket;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.videobridge.PotentialPacketHandler;
import org.jitsi.videobridge.colibri2.FeatureNotImplementedException;
import org.jitsi.videobridge.export.Exporter;
import org.jitsi.videobridge.util.ByteBufferPool;
import org.jitsi.xmpp.extensions.colibri2.Connect;
import org.json.simple.JSONObject;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0014\u0010\u0015\u001a\u00020\u00072\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017J\b\u0010\u0019\u001a\u00020\u000eH\u0002J\u0010\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0006\u0010\u001e\u001a\u00020\u0007J\u000e\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u0018J\u0006\u0010!\u001a\u00020\"R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jitsi/videobridge/export/ExporterWrapper;", "Lorg/jitsi/videobridge/PotentialPacketHandler;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "handleTranscriptionResult", "Lkotlin/Function1;", "Lorg/jitsi/mediajson/TranscriptionResultEvent;", "", "<init>", "(Lorg/jitsi/utils/logging2/Logger;Lkotlin/jvm/functions/Function1;)V", "logger", "getLogger", "()Lorg/jitsi/utils/logging2/Logger;", "started", "", "getStarted", "()Z", "setStarted", "(Z)V", "exporter", "Lorg/jitsi/videobridge/export/Exporter;", "setConnects", "connects", "", "Lorg/jitsi/xmpp/extensions/colibri2/Connect;", "isConnected", "wants", "packet", "Lorg/jitsi/nlj/PacketInfo;", "send", "stop", "start", "connect", "debugState", "Lorg/json/simple/JSONObject;", "jitsi-videobridge"})
@SourceDebugExtension(value={"SMAP\nExporterWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExporterWrapper.kt\norg/jitsi/videobridge/export/ExporterWrapper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,102:1\n1193#2,2:103\n1267#2,4:105\n*S KotlinDebug\n*F\n+ 1 ExporterWrapper.kt\norg/jitsi/videobridge/export/ExporterWrapper\n*L\n86#1:103,2\n86#1:105,4\n*E\n"})
public final class ExporterWrapper
implements PotentialPacketHandler {
    @NotNull
    private final Function1<TranscriptionResultEvent, Unit> handleTranscriptionResult;
    @NotNull
    private final Logger logger;
    private boolean started;
    @Nullable
    private Exporter exporter;

    public ExporterWrapper(@NotNull Logger parentLogger, @NotNull Function1<? super TranscriptionResultEvent, Unit> handleTranscriptionResult) {
        Intrinsics.checkNotNullParameter((Object)parentLogger, (String)"parentLogger");
        Intrinsics.checkNotNullParameter(handleTranscriptionResult, (String)"handleTranscriptionResult");
        this.handleTranscriptionResult = handleTranscriptionResult;
        this.logger = LoggerExtensionsKt.createChildLogger$default((Object)this, (Logger)parentLogger, null, (int)2, null);
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    public final boolean getStarted() {
        return this.started;
    }

    public final void setStarted(boolean bl) {
        this.started = bl;
    }

    public final void setConnects(@NotNull List<Connect> connects) {
        Intrinsics.checkNotNullParameter(connects, (String)"connects");
        if (this.started && !((Collection)connects).isEmpty()) {
            throw new FeatureNotImplementedException("Changing connects once enabled.");
        }
        if (connects.isEmpty()) {
            this.stop();
        } else {
            if (connects.size() > 1) {
                throw new FeatureNotImplementedException("Multiple connects");
            }
            if (connects.get(0).getVideo()) {
                throw new FeatureNotImplementedException("Video");
            }
            this.start(connects.get(0));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isConnected() {
        if (!this.started) return false;
        Exporter exporter = this.exporter;
        if (exporter == null) return false;
        if (!exporter.isConnected()) return false;
        return true;
    }

    @Override
    public boolean wants(@NotNull PacketInfo packet) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        if (!this.isConnected() || !(packet.getPacket() instanceof AudioRtpPacket)) {
            return false;
        }
        if (!(packet.getPayloadType() instanceof OpusPayloadType)) {
            this.logger.warn((Object)("Ignore audio with unsupported payload type: " + packet.getPayloadType()));
            return false;
        }
        return true;
    }

    @Override
    public void send(@NotNull PacketInfo packet) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Exporter exporter = this.exporter;
        if (exporter != null) {
            exporter.send(packet);
        } else {
            ExporterWrapper $this$send_u24lambda_u240 = this;
            boolean bl = false;
            ByteBufferPool.returnBuffer(packet.getPacket().buffer);
        }
    }

    public final void stop() {
        if (this.started) {
            this.logger.info((Object)"Stopping.");
        }
        this.started = false;
        Exporter exporter = this.exporter;
        if (exporter != null) {
            exporter.stop();
        }
        this.exporter = null;
    }

    /*
     * WARNING - void declaration
     */
    public final void start(@NotNull Connect connect) {
        void $this$start_u24lambda_u241;
        Exporter exporter;
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)connect, (String)"connect");
        if (connect.getVideo()) {
            throw new FeatureNotImplementedException("Video");
        }
        if (connect.getProtocol() != Connect.Protocols.MEDIAJSON) {
            throw new FeatureNotImplementedException("Protocol " + connect.getProtocol());
        }
        this.logger.info((Object)("Starting with url=" + connect.getUrl()));
        if (this.exporter != null) {
            this.logger.warn((Object)"Exporter already exists, stopping previous one.");
            this.stop();
        }
        Iterable $this$associate$iv = connect.getHttpHeaders();
        boolean $i$f$associate22 = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            Connect.HttpHeader header = (Connect.HttpHeader)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)header.getName(), (Object)header.getValue());
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map httpHeaders = destination$iv$iv;
        Exporter $i$f$associate22 = exporter = new Exporter(connect.getUrl(), httpHeaders, this.logger, this.handleTranscriptionResult);
        ExporterWrapper exporterWrapper = this;
        boolean bl = false;
        $this$start_u24lambda_u241.start();
        exporterWrapper.exporter = exporter;
        this.started = true;
    }

    @NotNull
    public final JSONObject debugState() {
        JSONObject jSONObject;
        block0: {
            JSONObject $this$debugState_u24lambda_u240 = jSONObject = new JSONObject();
            boolean bl = false;
            $this$debugState_u24lambda_u240.put((Object)"started", (Object)this.started);
            Exporter exporter = this.exporter;
            if (exporter == null) break block0;
            Exporter it = exporter;
            boolean bl2 = false;
            $this$debugState_u24lambda_u240.put((Object)"exporter", (Object)it.debugState());
        }
        return jSONObject;
    }
}

