/*
    BLUES - BD-Java emulation server

    Copyright (C) 2007-2025 GuinpinSoft inc <blues@makemkv.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/
package blues;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.security.SecureRandom;
import java.util.HashMap;

public class Jail {
    private static ClassMap map;
    private static String cookie;

    static {
        cookie = "f" + Long.toHexString(new SecureRandom().nextLong()) + "zzzzzzzzzzzzzzz";
        cookie = cookie.substring(0, 16);
    }

    public static ClassMap map() {
        return map;
    }

    public static String cookie() {
        return cookie;
    }

    public static void setMap(byte[] mapData) {
        map = new ClassMap(0);
        InputStream bs = new ByteArrayInputStream(mapData);
        try {
            map.readExternal(new ObjectInputStream(bs));
            bs.close();
        } catch (Exception e) {
            map = null;
        }
    }

    private static boolean isVisiblePackage(String name) {
        if (name == null)
            return false;
        if (name.startsWith("sun.reflect."))
            return true;
        return false;
    }

    public static boolean IsVisibleMember(ClassInfo classInfo, String name) {
        ClassMap map = map();
        ClassInfo info = classInfo;
        while (info != null) {
            int flags = info.find(name);
            if (flags != 0) {
                return true;
            }
            info = map.getSuper(info);
        }
        return false;
    }

    private static boolean isArrayClass(String name) {
        if (name == null)
            return false;

        if (name.length() >= 1) {
            if (name.charAt(0) == '[') {
                return true;
            }
        }
        return false;
    }

    private static int arrayClassIndex(String name) {
        if (isArrayClass(name)) {
            int n = 1;
            while ((n < name.length()) && (name.charAt(n) == '[')) {
                n++;
            }
            if (((n + 2) < name.length()) && (name.charAt(n) == 'L') && (name.charAt(name.length() - 1) == ';')) {
                return n + 1;
            }
        }

        return -1;
    }

    public static String classNameAddJail(String name) {
        if (name == null)
            return null;

        String jname;

        int na = arrayClassIndex(name);
        if (na > 0) {
            jname = name.substring(0, na) + classNameAddJail0(name.substring(na, name.length() - 1)) + ";";
        } else {
            if (isArrayClass(name)) {
                jname = name;
            } else {
                jname = classNameAddJail0(name);
            }
        }

        Log.log(Log.LOG_JAIL, "c->j ", name, " -> ", jname);
        return jname;
    }

    private static String classNameAddJail0(String name) {

        ClassInfo info = map.findEntry(name);

        if (info != null) {
            return name;
        } else {
            if (isVisiblePackage(name)) {
                return name;
            }
        }
        return "jail." + name;
    }

    public static String classNameRemoveJail(String name) {
        if (name == null)
            return null;

        String nname;

        int na = arrayClassIndex(name);
        if (na > 0) {
            nname = name.substring(0, na) + classNameRemoveJail0(name.substring(na, name.length() - 1)) + ";";
        } else {
            if (isArrayClass(name)) {
                nname = name;
            } else {
                nname = classNameRemoveJail0(name);
            }
        }

        Log.log(Log.LOG_JAIL, "c<-j ", nname, " <- ", name);
        return nname;
    }

    private static String classNameRemoveJail0(String name) {

        String nname = name;
        if (name.startsWith("jail.")) {
            nname = name.substring(5);
        }
        return nname;
    }

    public static boolean classNameIsJail(String name) {
        if (name==null) return false;
        if (name.startsWith("jail.")) return true;
        return false;
    }

    public static String packageNameAddJail(String name) {
        if (name == null)
            return null;
        String jname;
        if (name.length() == 0) {
            jname = "jail";
        } else {
            jname = "jail." + name;
        }
        Log.log(Log.LOG_JAIL, "p->j ", name, " -> ", jname);
        return jname;
    }

    public static String packageNameRemoveJail(String name) {
        if (name == null)
            return null;
        String nname;
        if (name.equals("jail")) {
            nname = null;
        } else {
            nname = name;
            if (name.startsWith("jail.")) {
                nname = name.substring(5);
            }
        }
        Log.log(Log.LOG_JAIL, "p<-j ", nname, " <- ", name);
        return nname;
    }

    public static String rJ(String name) {
        return classNameRemoveJail(name);
    }

}
