/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileHelper;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaTrailer;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.filenaming.MovieTrailerNaming;
import org.tinymediamanager.core.tasks.TrailerDownloadTask;
import org.tinymediamanager.core.tasks.YtDownloadTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.scraper.entities.MediaCertification;
import org.tinymediamanager.scraper.imdb.ImdbMovieTrailerProvider;

public class MovieHelpers {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieHelpers.class);

    private MovieHelpers() {
    }

    public static MediaCertification parseCertificationStringForMovieSetupCountry(String name) {
        MediaCertification cert = MediaCertification.UNKNOWN;
        if ((name = name.strip()).contains("/")) {
            String[] cs;
            String[] countries;
            for (String c : countries = name.split("/")) {
                if ((c = c.strip()).contains(":")) {
                    cs = c.split(":");
                    cert = MediaCertification.getCertification(MovieModuleManager.getInstance().getSettings().getCertificationCountry(), cs[1]);
                    if (cert == MediaCertification.UNKNOWN) continue;
                    return cert;
                }
                cert = MediaCertification.getCertification(MovieModuleManager.getInstance().getSettings().getCertificationCountry(), c);
                if (cert == MediaCertification.UNKNOWN) continue;
                return cert;
            }
            for (String c : countries) {
                if (!((c = c.strip()).contains(":") ? (cert = MediaCertification.findCertification((cs = c.split(":"))[1])) != MediaCertification.UNKNOWN : (cert = MediaCertification.findCertification(c)) != MediaCertification.UNKNOWN)) continue;
                return cert;
            }
        } else if (name.contains(":")) {
            String[] cs = name.split(":");
            cert = MediaCertification.getCertification(MovieModuleManager.getInstance().getSettings().getCertificationCountry(), cs[1].strip());
        } else {
            cert = MediaCertification.getCertification(MovieModuleManager.getInstance().getSettings().getCertificationCountry(), name.strip());
        }
        if (cert == MediaCertification.UNKNOWN) {
            cert = MediaCertification.findCertification(name);
        }
        return cert;
    }

    public static void downloadTrailer(final Movie movie, MediaTrailer trailer) {
        if (StringUtils.isBlank((CharSequence)trailer.getUrl()) || !trailer.getUrl().startsWith("http")) {
            if (StringUtils.isBlank((CharSequence)trailer.getId())) {
                LOGGER.debug("Could not download trailer: no url/id {}", (Object)trailer);
                return;
            }
            String id = trailer.getId();
            if (!id.matches("vi\\d+")) {
                LOGGER.debug("Could not download trailer: id not known {}", (Object)trailer);
                return;
            }
            ImdbMovieTrailerProvider tp = new ImdbMovieTrailerProvider();
            String url = tp.getUrlForId(trailer);
            if (url.isEmpty()) {
                LOGGER.debug("Could not download trailer: could not construct url from id {}", (Object)trailer);
                return;
            }
            trailer.setUrl(url);
        }
        List<Object> trailernames = new ArrayList<MovieTrailerNaming>();
        if (movie.isMultiMovieDir()) {
            trailernames.add(MovieTrailerNaming.FILENAME_TRAILER);
        } else {
            trailernames = MovieModuleManager.getInstance().getSettings().getTrailerFilenames();
        }
        final String filename = !trailernames.isEmpty() ? movie.getTrailerFilename((MovieTrailerNaming)trailernames.get(0)) : movie.getTrailerFilename(MovieTrailerNaming.FILENAME_TRAILER);
        final Path outputFolder = movie.isDisc() && MovieModuleManager.getInstance().getSettings().isTrailerDiscFolderInside() ? (MediaFileHelper.isDiscFolder(movie.getMainFile().getFilename()) ? movie.getMainFile().getFileAsPath() : movie.getPathNIO()) : movie.getPathNIO();
        try {
            Matcher matcher = Utils.YOUTUBE_PATTERN.matcher(trailer.getUrl());
            if (matcher.matches()) {
                YtDownloadTask task = new YtDownloadTask(trailer, MovieModuleManager.getInstance().getSettings().getTrailerQuality(), MovieModuleManager.getInstance().getSettings().isUseYtDlp()){

                    @Override
                    protected Path getDestinationWoExtension() {
                        return outputFolder.resolve(filename);
                    }

                    @Override
                    protected MediaEntity getMediaEntityToAdd() {
                        return movie;
                    }
                };
                TmmTaskManager.getInstance().addDownloadTask(task);
            } else {
                TrailerDownloadTask task = new TrailerDownloadTask(trailer){

                    @Override
                    protected Path getDestinationWoExtension() {
                        return outputFolder.resolve(filename);
                    }

                    @Override
                    protected MediaEntity getMediaEntityToAdd() {
                        return movie;
                    }
                };
                TmmTaskManager.getInstance().addDownloadTask(task);
            }
        }
        catch (Exception e) {
            LOGGER.error("Could not start trailer download - '{}'", (Object)e.getMessage());
            MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, (Object)movie, "message.scrape.trailerfailed", new String[]{":", e.getLocalizedMessage()}));
        }
    }
}

