/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.animeofflinedb;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.io.File;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.scraper.animeofflinedb.AnimeOfflineDbJsonEntity;
import org.tinymediamanager.scraper.http.OnDiskCachedUrl;
import org.tinymediamanager.scraper.http.Url;

public class AnimeOfflineDb {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnimeOfflineDb.class);
    private static final String JSON_FILE = "anime-offline-database.jsonl";
    private static AnimeOfflineDb instance;
    private List<String> ids = new ArrayList<String>();

    private AnimeOfflineDb() {
    }

    public static synchronized AnimeOfflineDb getInstance() {
        if (instance == null) {
            instance = new AnimeOfflineDb();
            instance.initDataset();
        }
        return instance;
    }

    private void initDataset() {
        block8: {
            Path databaseFile = Path.of(Globals.CACHE_FOLDER, JSON_FILE);
            long cut = LocalDateTime.now().minusMonths(1L).toEpochSecond(ZoneOffset.UTC);
            try {
                if (!Files.exists(databaseFile, new LinkOption[0]) || Files.getLastModifiedTime(databaseFile, new LinkOption[0]).to(TimeUnit.SECONDS) < cut) {
                    Url u;
                    LOGGER.debug("Preparing AnimeOfflineDB dataset...");
                    String tagName = "";
                    try {
                        u = new OnDiskCachedUrl("https://api.github.com/repos/manami-project/anime-offline-database/releases/latest", 14, TimeUnit.DAYS);
                        ObjectMapper mapper = new ObjectMapper();
                        JsonNode node = mapper.readTree(u.getInputStream());
                        tagName = node.get("tag_name").asText();
                    }
                    catch (Exception e) {
                        LOGGER.debug("Getting tag failed; fallback to known tag - {}", (Object)e.getMessage());
                        tagName = "2025-32";
                    }
                    u = new Url("https://github.com/manami-project/anime-offline-database/releases/download/" + tagName + "/anime-offline-database.jsonl");
                    boolean ok = u.download(databaseFile);
                    if (ok) {
                        this.loadJsonL(JSON_FILE);
                    } else if (Files.exists(databaseFile, new LinkOption[0])) {
                        LOGGER.debug("download failed - using old copy");
                        this.loadJsonL(JSON_FILE);
                    }
                    break block8;
                }
                LOGGER.debug("Dataset young enough, no need to download...");
                this.loadJsonL(JSON_FILE);
            }
            catch (Exception e) {
                LOGGER.debug("Error initializing dataset: {} - {}", (Object)databaseFile, (Object)e.getMessage());
                Utils.deleteFileSafely(databaseFile);
            }
        }
    }

    private void loadJsonL(String file) throws Exception {
        LOGGER.debug("Loading from file...");
        JsonMapper mapper = new JsonMapper();
        try (MappingIterator it = mapper.readerFor(AnimeOfflineDbJsonEntity.class).readValues(new File(Globals.CACHE_FOLDER, file));){
            while (it.hasNextValue()) {
                AnimeOfflineDbJsonEntity entity = (AnimeOfflineDbJsonEntity)it.nextValue();
                if (entity.title == null || entity.title.isEmpty()) continue;
                this.ids.add(this.parseIds(entity));
            }
        }
        LOGGER.debug("Loaded {} entries from file: {}", (Object)this.ids.size(), (Object)file);
    }

    private String parseIds(AnimeOfflineDbJsonEntity anime) {
        ArrayList<CallSite> ids = new ArrayList<CallSite>();
        for (String id : anime.sources) {
            URI u = URI.create(id);
            String h = u.getHost();
            h = h.substring(0, h.lastIndexOf(46));
            h = h.replaceAll("[^a-zA-Z0-9]", "");
            h = h.strip();
            try {
                int num = Integer.parseInt(id.substring(id.lastIndexOf(47) + 1));
                ids.add((CallSite)((Object)(h + ":" + num)));
            }
            catch (Exception e) {
                String num = "";
                if (h.contains("animeplanet")) {
                    num = id.substring(id.lastIndexOf(47) + 1);
                }
                if (h.contains("notify")) {
                    num = id.substring(id.lastIndexOf(47) + 1);
                }
                if (h.contains("animenewsnetwork")) {
                    num = id.substring(id.lastIndexOf(61) + 1);
                }
                ids.add((CallSite)((Object)(h + ":" + num)));
            }
        }
        return String.join((CharSequence)"|", ids) + "|";
    }

    public Map<String, Object> getIdsFor(String id, String value) {
        Map<String, Object> ret = Collections.emptyMap();
        Optional<String> result = this.ids.stream().filter(s -> s.contains(id + ":" + value + "|")).findFirst();
        if (result.isPresent()) {
            ret = this.stringToMap(result.get());
        }
        return ret;
    }

    private Map<String, Object> stringToMap(String str) {
        String[] pairs;
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String pair : pairs = str.split("\\|")) {
            String[] keyValue = pair.split(":");
            if (keyValue.length != 2) continue;
            try {
                int num = Integer.parseInt(keyValue[1]);
                map.put(keyValue[0], num);
            }
            catch (Exception e) {
                map.put(keyValue[0], keyValue[1]);
            }
        }
        return map;
    }
}

