/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.thirdparty.upnp;

import java.io.File;
import java.util.ArrayList;
import org.jupnp.binding.annotations.AnnotationLocalServiceBinder;
import org.jupnp.model.DefaultServiceManager;
import org.jupnp.model.ServiceManager;
import org.jupnp.model.ValidationException;
import org.jupnp.model.meta.DeviceDetails;
import org.jupnp.model.meta.DeviceIdentity;
import org.jupnp.model.meta.Icon;
import org.jupnp.model.meta.LocalDevice;
import org.jupnp.model.meta.LocalService;
import org.jupnp.model.profile.DeviceDetailsProvider;
import org.jupnp.model.profile.RemoteClientInfo;
import org.jupnp.model.types.DeviceType;
import org.jupnp.model.types.UDADeviceType;
import org.jupnp.support.connectionmanager.ConnectionManagerService;
import org.jupnp.support.xmicrosoft.AbstractMediaReceiverRegistrarService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.thirdparty.upnp.ContentDirectoryService;
import org.tinymediamanager.thirdparty.upnp.MSMediaReceiverRegistrarService;
import org.tinymediamanager.thirdparty.upnp.MimeTypes;
import org.tinymediamanager.thirdparty.upnp.TmmConnectionManagerService;
import org.tinymediamanager.thirdparty.upnp.TmmDeviceDetails;

public class TmmLocalDevice
extends LocalDevice {
    private static final Logger LOGGER = LoggerFactory.getLogger(TmmLocalDevice.class);
    private final DeviceDetailsProvider deviceDetailsProvider = new TmmDeviceDetails();
    private final ContentDirectoryService contentDirectoryService = this.getServiceImplementation(ContentDirectoryService.class);
    private final TmmConnectionManagerService connectionManagerService = this.getServiceImplementation(TmmConnectionManagerService.class);
    private final AbstractMediaReceiverRegistrarService mediaReceiverRegistrarService = this.getServiceImplementation(AbstractMediaReceiverRegistrarService.class);

    public TmmLocalDevice() throws ValidationException {
        super(new DeviceIdentity(TmmDeviceDetails.IDENTITY.getUdn()), (DeviceType)new UDADeviceType("MediaServer", 1), TmmDeviceDetails.DEVICE_DETAILS, TmmLocalDevice.createDeviceIcons(), TmmLocalDevice.createMediaServerServices(), null);
    }

    public DeviceDetails getDetails(RemoteClientInfo info) {
        if (this.deviceDetailsProvider != null) {
            return this.deviceDetailsProvider.provide(info);
        }
        return super.getDetails(info);
    }

    public ContentDirectoryService getContentDirectoryService() {
        return this.contentDirectoryService;
    }

    public ConnectionManagerService getConnectionManagerService() {
        return this.connectionManagerService;
    }

    public AbstractMediaReceiverRegistrarService getMediaReceiverRegistrarService() {
        return this.mediaReceiverRegistrarService;
    }

    private <T> T getServiceImplementation(Class<T> baseClass) {
        for (LocalService service : this.getServices()) {
            if (service == null || !service.getManager().getImplementation().getClass().equals(baseClass)) continue;
            return (T)service.getManager().getImplementation();
        }
        return null;
    }

    public static TmmLocalDevice createMediaServerDevice() {
        try {
            LOGGER.info("UPnP: Hello, I'm {}", (Object)TmmDeviceDetails.IDENTITY);
            return new TmmLocalDevice();
        }
        catch (ValidationException e) {
            LOGGER.debug("Error in upnp local device creation: {}", (Object)e.toString());
            return null;
        }
    }

    private static Icon[] createDeviceIcons() {
        ArrayList<Icon> icons = new ArrayList<Icon>();
        try {
            icons.add(new Icon(MimeTypes.getMimeTypeAsString("png"), 128, 128, 24, new File("tmm.png")));
        }
        catch (Exception e) {
            try {
                icons.add(new Icon(MimeTypes.getMimeTypeAsString("png"), 128, 128, 24, new File("AppBundler/tmm.png")));
            }
            catch (Exception e2) {
                LOGGER.debug("Did not find device icon");
            }
        }
        try {
            icons.add(new Icon(MimeTypes.getMimeTypeAsString("ico"), 128, 128, 24, new File("tmm.ico")));
        }
        catch (Exception e) {
            try {
                icons.add(new Icon(MimeTypes.getMimeTypeAsString("ico"), 128, 128, 24, new File("AppBundler/tmm.ico")));
            }
            catch (Exception e2) {
                LOGGER.debug("Did not find device icon2");
            }
        }
        return (Icon[])icons.toArray(Icon[]::new);
    }

    private static LocalService<?>[] createMediaServerServices() {
        ArrayList services = new ArrayList();
        services.add(TmmLocalDevice.createContentDirectoryService());
        services.add(TmmLocalDevice.createServerConnectionManagerService());
        services.add(TmmLocalDevice.createMediaReceiverRegistrarService());
        return (LocalService[])services.toArray(LocalService[]::new);
    }

    private static LocalService<?> createContentDirectoryService() {
        LocalService contentDirectoryService = new AnnotationLocalServiceBinder().read(ContentDirectoryService.class);
        contentDirectoryService.setManager((ServiceManager)new DefaultServiceManager(contentDirectoryService, null){

            protected void lock() {
            }

            protected void unlock() {
            }

            protected ContentDirectoryService createServiceInstance() throws Exception {
                return new ContentDirectoryService();
            }
        });
        return contentDirectoryService;
    }

    private static LocalService<?> createServerConnectionManagerService() {
        LocalService connectionManagerService = new AnnotationLocalServiceBinder().read(TmmConnectionManagerService.class);
        connectionManagerService.setManager((ServiceManager)new DefaultServiceManager(connectionManagerService, TmmConnectionManagerService.class){

            protected int getLockTimeoutMillis() {
                return 1000;
            }

            protected TmmConnectionManagerService createServiceInstance() throws Exception {
                return new TmmConnectionManagerService();
            }
        });
        return connectionManagerService;
    }

    private static LocalService<?> createMediaReceiverRegistrarService() {
        LocalService mediaReceiverRegistrarService = new AnnotationLocalServiceBinder().read(MSMediaReceiverRegistrarService.class);
        mediaReceiverRegistrarService.setManager((ServiceManager)new DefaultServiceManager(mediaReceiverRegistrarService, null){

            protected int getLockTimeoutMillis() {
                return 1000;
            }

            protected MSMediaReceiverRegistrarService createServiceInstance() throws Exception {
                return new MSMediaReceiverRegistrarService();
            }
        });
        return mediaReceiverRegistrarService;
    }
}

