/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.panels;

import java.awt.Component;
import java.awt.LayoutManager;
import java.beans.PropertyChangeListener;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.ui.ColumnLayout;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.WrapLayout;
import org.tinymediamanager.ui.components.NoBorderScrollPane;
import org.tinymediamanager.ui.components.button.UpnpPlayButton;
import org.tinymediamanager.ui.components.label.LinkLabel;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.components.panel.IdLinkPanel;
import org.tinymediamanager.ui.components.textfield.LinkTextArea;
import org.tinymediamanager.ui.components.textfield.ReadOnlyTextPane;
import org.tinymediamanager.ui.components.textfield.ReadOnlyTextPaneHTML;
import org.tinymediamanager.ui.movies.MovieSelectionModel;
import org.tinymediamanager.ui.panels.InformationPanel;
import org.tinymediamanager.ui.panels.MediaInformationLogosPanel;
import org.tinymediamanager.ui.panels.RatingPanel;

public class MovieInformationPanel
extends InformationPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieInformationPanel.class);
    private static final String LAYOUT_ARTWORK_VISIBLE = "[n:100lp:20%, grow][300lp:300lp,grow 350]";
    private static final String LAYOUT_ARTWORK_HIDDEN = "[][300lp:300lp,grow 350]";
    private final MovieSelectionModel selectionModel;
    private RatingPanel ratingPanel;
    private JLabel lblMovieName;
    private JLabel lblTagline;
    private JLabel lblYear;
    private LinkLabel lblImdbid;
    private JLabel lblRunningTime;
    private LinkLabel lblTmdbid;
    private JTextPane taGenres;
    private JTextPane taPlot;
    private JLabel lblCertification;
    private JPanel panelOtherIds;
    private MediaInformationLogosPanel panelLogos;
    private JLabel lblOriginalTitle;
    private JButton btnPlay;
    private JScrollPane scrollPane;
    private JTextPane taProduction;
    private JTextPane taTags;
    private JLabel lblEdition;
    private LinkTextArea lblMoviePath;
    private JLabel lblMovieSet;
    private JLabel lblSpokenLanguages;
    private JLabel lblCountry;
    private JLabel lblReleaseDate;
    private JTextPane taNote;
    private JLabel lblCertificationLogo;
    private JLabel lblShowlink;
    private JLabel lblDirector;

    public MovieInformationPanel(MovieSelectionModel movieSelectionModel) {
        this.selectionModel = movieSelectionModel;
        this.initComponents();
        this.lblTmdbid.addActionListener(arg0 -> {
            String url = "https://www.themoviedb.org/movie/" + this.lblTmdbid.getText();
            try {
                TmmUIHelper.browseUrl(url);
            }
            catch (Exception e) {
                LOGGER.error("Could not open '{}' in browser - '{}'", (Object)url, (Object)e.getMessage());
                MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, (Object)url, "message.erroropenurl", new String[]{":", e.getLocalizedMessage()}));
            }
        });
        this.lblImdbid.addActionListener(arg0 -> {
            String url = "https://www.imdb.com/title/" + this.lblImdbid.getText();
            try {
                TmmUIHelper.browseUrl(url);
            }
            catch (Exception e) {
                LOGGER.error("Could not open '{}' in browser - '{}'", (Object)url, (Object)e.getMessage());
                MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, (Object)url, "message.erroropenurl", new String[]{":", e.getLocalizedMessage()}));
            }
        });
        this.lblMoviePath.addActionListener(arg0 -> {
            if (StringUtils.isNotEmpty((CharSequence)this.lblMoviePath.getLink())) {
                Path path = Paths.get(this.lblMoviePath.getLink(), new String[0]);
                TmmUIHelper.openFolder(path);
            }
        });
        PropertyChangeListener propertyChangeListener = propertyChangeEvent -> {
            String property = propertyChangeEvent.getPropertyName();
            Object source = propertyChangeEvent.getSource();
            if (source.getClass() != MovieSelectionModel.class) {
                return;
            }
            MovieSelectionModel selectionModel = (MovieSelectionModel)source;
            Movie movie = selectionModel.getSelectedMovie();
            if ("selectedMovie".equals(property)) {
                this.changeMovie(movie);
            }
        };
        movieSelectionModel.addPropertyChangeListener(propertyChangeListener);
    }

    private void changeMovie(Movie movie) {
        this.lblMovieName.setText(movie.getTitle());
        this.lblMovieName.setIcon(movie.isLocked() ? IconManager.LOCK_BLUE : null);
        this.lblOriginalTitle.setText(movie.getOriginalTitle());
        this.lblYear.setText(this.getIntegerAsStringWoZero(movie.getYear()));
        this.lblReleaseDate.setText(movie.getReleaseDateAsString());
        this.lblCertification.setText(movie.getCertification().getLocalizedName());
        this.lblRunningTime.setText(this.convertRuntime(movie.getRuntime()));
        this.taGenres.setText(movie.getGenresAsString());
        this.lblDirector.setText(movie.getDirectorsAsString());
        this.taProduction.setText(movie.getProductionCompany());
        this.lblCountry.setText(movie.getCountry());
        this.lblSpokenLanguages.setText(movie.getLocalizedSpokenLanguages());
        this.lblCertificationLogo.setIcon(this.getCertificationIcon(movie.getCertification()));
        this.lblImdbid.setText(movie.getImdbId());
        this.lblTmdbid.setText(this.getIntegerAsStringWoZero(movie.getTmdbId()));
        this.panelOtherIds.removeAll();
        for (String key : movie.getIds().keySet()) {
            if ("imdb".equals(key) || "tmdb".equals(key)) continue;
            this.panelOtherIds.add(new IdLinkPanel(key, movie));
        }
        this.panelOtherIds.invalidate();
        this.panelOtherIds.repaint();
        this.lblTagline.setText(movie.getTagline());
        this.taPlot.setText(movie.getPlot());
        this.lblMovieSet.setText(movie.getMovieSetTitle());
        this.lblShowlink.setText(movie.getShowlinksAsString());
        this.lblEdition.setText(movie.getEdition().getTitle());
        this.taTags.setText(movie.getTagsAsString());
        this.lblMoviePath.setText(movie.getPath());
        this.taNote.setText(movie.getNote());
        this.setArtwork(movie, MediaFileType.POSTER);
        this.setArtwork(movie, MediaFileType.FANART);
        this.setArtwork(movie, MediaFileType.BANNER);
        this.setArtwork(movie, MediaFileType.THUMB);
        this.setArtwork(movie, MediaFileType.CLEARLOGO);
        this.panelLogos.setMediaInformationSource(movie);
        this.setRating(movie);
        SwingUtilities.invokeLater(() -> {
            this.scrollPane.getVerticalScrollBar().setValue(0);
            this.scrollPane.getHorizontalScrollBar().setValue(0);
        });
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("hidemode 3", LAYOUT_ARTWORK_VISIBLE, "[][grow]"));
        JPanel panelLeft = new JPanel();
        panelLeft.setLayout(new ColumnLayout());
        this.add((Component)panelLeft, "cell 0 0 1 2, grow");
        for (Component component : this.generateArtworkComponents(MediaFileType.POSTER)) {
            panelLeft.add(component);
        }
        for (Component component : this.generateArtworkComponents(MediaFileType.FANART)) {
            panelLeft.add(component);
        }
        for (Component component : this.generateArtworkComponents(MediaFileType.BANNER)) {
            panelLeft.add(component);
        }
        for (Component component : this.generateArtworkComponents(MediaFileType.THUMB)) {
            panelLeft.add(component);
        }
        for (Component component : this.generateArtworkComponents(MediaFileType.CLEARLOGO)) {
            panelLeft.add(component);
        }
        JPanel panelTitle = new JPanel();
        this.add((Component)panelTitle, "cell 1 0,grow");
        panelTitle.setLayout((LayoutManager)new MigLayout("insets 0 0 n n", "[grow][]", "[][][shrink 0]"));
        this.lblMovieName = new TmmLabel("", 1.33);
        panelTitle.add((Component)this.lblMovieName, "flowx,cell 0 0,wmin 0,growx");
        this.btnPlay = new UpnpPlayButton(){

            @Override
            public MediaFile getMediaFile() {
                return MovieInformationPanel.this.selectionModel.getSelectedMovie().getMainFile();
            }

            @Override
            public MediaEntity getMediaEntity() {
                return MovieInformationPanel.this.selectionModel.getSelectedMovie();
            }
        };
        panelTitle.add((Component)this.btnPlay, "cell 1 0 1 2,aligny top");
        this.lblOriginalTitle = new JLabel("");
        panelTitle.add((Component)this.lblOriginalTitle, "cell 0 1,growx,wmin 0");
        panelTitle.add((Component)new JSeparator(), "cell 0 2 2 1,growx");
        JPanel panelRight = new JPanel();
        panelRight.setLayout((LayoutManager)new MigLayout("insets n 0 n n, hidemode 3", "[100lp,grow]", "[shrink 0][][shrink 0][][][][][shrink 0][][grow,top][shrink 0][]"));
        this.scrollPane = new NoBorderScrollPane(panelRight);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(8);
        this.add((Component)this.scrollPane, "cell 1 1,grow, wmin 0");
        JPanel panelTopDetails = new JPanel();
        panelRight.add((Component)panelTopDetails, "cell 0 0,grow");
        panelTopDetails.setLayout((LayoutManager)new MigLayout("insets 0", "[][][40lp!][][grow][]", "[]2lp[]2lp[grow]2lp[]2lp[]2lp[]2lp[]2lp[]2lp[]"));
        TmmLabel lblYearT = new TmmLabel(TmmResourceBundle.getString("metatag.year"));
        panelTopDetails.add((Component)lblYearT, "cell 0 0");
        this.lblYear = new JLabel("");
        panelTopDetails.add((Component)this.lblYear, "cell 1 0,growx");
        TmmLabel lblImdbIdT = new TmmLabel("IMDb:");
        panelTopDetails.add((Component)lblImdbIdT, "cell 3 0");
        this.lblImdbid = new LinkLabel("");
        panelTopDetails.add((Component)this.lblImdbid, "cell 3 0");
        this.lblCertificationLogo = new JLabel("");
        panelTopDetails.add((Component)this.lblCertificationLogo, "cell 5 0 1 3, top");
        TmmLabel lblReleaseDateT = new TmmLabel(TmmResourceBundle.getString("metatag.releasedate"));
        panelTopDetails.add((Component)lblReleaseDateT, "cell 0 1");
        this.lblReleaseDate = new JLabel("");
        panelTopDetails.add((Component)this.lblReleaseDate, "cell 1 1");
        TmmLabel lblTmdbIdT = new TmmLabel("TMDB:");
        panelTopDetails.add((Component)lblTmdbIdT, "cell 3 1");
        this.lblTmdbid = new LinkLabel("");
        panelTopDetails.add((Component)this.lblTmdbid, "cell 3 1");
        TmmLabel lblCertificationT = new TmmLabel(TmmResourceBundle.getString("metatag.certification"));
        panelTopDetails.add((Component)lblCertificationT, "cell 0 2");
        this.lblCertification = new JLabel("");
        panelTopDetails.add((Component)this.lblCertification, "cell 1 2,growx");
        this.panelOtherIds = new JPanel(new WrapLayout(0, 0, 0));
        panelTopDetails.add((Component)this.panelOtherIds, "cell 3 2 3 2,growx,top,wmin 0");
        TmmLabel lblRunningTimeT = new TmmLabel(TmmResourceBundle.getString("metatag.runtime"));
        panelTopDetails.add((Component)lblRunningTimeT, "cell 0 3,aligny top");
        this.lblRunningTime = new JLabel("");
        panelTopDetails.add((Component)this.lblRunningTime, "cell 1 3,aligny top");
        TmmLabel lblGenresT = new TmmLabel(TmmResourceBundle.getString("metatag.genre"));
        panelTopDetails.add((Component)lblGenresT, "cell 0 4");
        this.taGenres = new ReadOnlyTextPane();
        panelTopDetails.add((Component)this.taGenres, "cell 1 4 5 1,growx,wmin 0");
        TmmLabel lblDirectorT = new TmmLabel(TmmResourceBundle.getString("metatag.director"));
        panelTopDetails.add((Component)lblDirectorT, "cell 0 5");
        this.lblDirector = new JLabel("");
        panelTopDetails.add((Component)this.lblDirector, "cell 1 5 5 1,growx,wmin 0");
        TmmLabel lblProductionT = new TmmLabel(TmmResourceBundle.getString("metatag.production"));
        panelTopDetails.add((Component)lblProductionT, "cell 0 6");
        this.taProduction = new ReadOnlyTextPane();
        panelTopDetails.add((Component)this.taProduction, "cell 1 6 5 1,growx,wmin 0");
        TmmLabel lblCountryT = new TmmLabel(TmmResourceBundle.getString("metatag.country"));
        panelTopDetails.add((Component)lblCountryT, "cell 0 7");
        this.lblCountry = new JLabel("");
        panelTopDetails.add((Component)this.lblCountry, "cell 1 7 5 1,wmin 0");
        TmmLabel lblSpokenLanguagesT = new TmmLabel(TmmResourceBundle.getString("metatag.spokenlanguages"));
        panelTopDetails.add((Component)lblSpokenLanguagesT, "cell 0 8");
        this.lblSpokenLanguages = new JLabel("");
        panelTopDetails.add((Component)this.lblSpokenLanguages, "cell 1 8 5 1,wmin 0");
        panelRight.add((Component)new JSeparator(), "cell 0 1,growx");
        this.ratingPanel = new RatingPanel();
        panelRight.add((Component)this.ratingPanel, "flowx,cell 0 2,aligny center");
        JSeparator sepLogos = new JSeparator();
        panelRight.add((Component)sepLogos, "cell 0 3,growx");
        this.panelLogos = new MediaInformationLogosPanel();
        panelRight.add((Component)this.panelLogos, "cell 0 4,growx, wmin 0");
        panelRight.add((Component)new JSeparator(), "cell 0 5,growx");
        TmmLabel lblTaglineT = new TmmLabel(TmmResourceBundle.getString("metatag.tagline"));
        panelRight.add((Component)lblTaglineT, "cell 0 6,alignx left,aligny top");
        this.lblTagline = new JLabel();
        panelRight.add((Component)this.lblTagline, "cell 0 7,growx,wmin 0,aligny top");
        TmmLabel lblPlotT = new TmmLabel(TmmResourceBundle.getString("metatag.plot"));
        panelRight.add((Component)lblPlotT, "cell 0 8,alignx left,aligny top");
        this.taPlot = new ReadOnlyTextPaneHTML();
        panelRight.add((Component)this.taPlot, "cell 0 9,growx,wmin 0,aligny top");
        panelRight.add((Component)new JSeparator(), "cell 0 10,growx");
        JPanel panelBottomDetails = new JPanel();
        panelRight.add((Component)panelBottomDetails, "cell 0 11,grow");
        panelBottomDetails.setLayout((LayoutManager)new MigLayout("insets 0", "[][200lp,grow]", "[]2lp[]2lp[]2lp[]2lp[]2lp[]"));
        TmmLabel lblMoviesetT = new TmmLabel(TmmResourceBundle.getString("metatag.movieset"));
        panelBottomDetails.add((Component)lblMoviesetT, "cell 0 0");
        this.lblMovieSet = new JLabel("");
        panelBottomDetails.add((Component)this.lblMovieSet, "cell 1 0,growx,wmin 0");
        TmmLabel lblShowlinkT = new TmmLabel(TmmResourceBundle.getString("metatag.showlink"));
        panelBottomDetails.add((Component)lblShowlinkT, "cell 0 1");
        this.lblShowlink = new JLabel("");
        panelBottomDetails.add((Component)this.lblShowlink, "cell 1 1");
        TmmLabel lblEditionT = new TmmLabel(TmmResourceBundle.getString("metatag.edition"));
        panelBottomDetails.add((Component)lblEditionT, "cell 0 2");
        this.lblEdition = new JLabel("");
        panelBottomDetails.add((Component)this.lblEdition, "cell 1 2,growx,wmin 0");
        TmmLabel lblTagsT = new TmmLabel(TmmResourceBundle.getString("metatag.tags"));
        panelBottomDetails.add((Component)lblTagsT, "cell 0 3");
        this.taTags = new ReadOnlyTextPane();
        panelBottomDetails.add((Component)this.taTags, "cell 1 3,growx,wmin 0");
        TmmLabel lblMoviePathT = new TmmLabel(TmmResourceBundle.getString("metatag.path"));
        panelBottomDetails.add((Component)lblMoviePathT, "cell 0 4");
        this.lblMoviePath = new LinkTextArea("");
        panelBottomDetails.add((Component)this.lblMoviePath, "cell 1 4,growx,wmin 0");
        TmmLabel lblNoteT = new TmmLabel(TmmResourceBundle.getString("metatag.note"));
        panelBottomDetails.add((Component)lblNoteT, "cell 0 5");
        this.taNote = new ReadOnlyTextPaneHTML();
        panelBottomDetails.add((Component)this.taNote, "cell 1 5,growx,wmin 0");
    }

    @Override
    protected List<MediaFileType> getShowArtworkFromSettings() {
        return MovieModuleManager.getInstance().getSettings().getShowArtworkTypes();
    }

    @Override
    protected void setColumnLayout(boolean artworkVisible) {
        if (artworkVisible) {
            ((MigLayout)this.getLayout()).setColumnConstraints((Object)LAYOUT_ARTWORK_VISIBLE);
        } else {
            ((MigLayout)this.getLayout()).setColumnConstraints((Object)LAYOUT_ARTWORK_HIDDEN);
        }
    }

    private void setRating(Movie movie) {
        HashMap<String, MediaRating> ratings = new HashMap<String, MediaRating>(movie.getRatings());
        MediaRating customRating = movie.getRating();
        if (customRating != MediaMetadata.EMPTY_RATING) {
            ratings.put("custom", customRating);
        }
        this.ratingPanel.setRatings(ratings);
    }
}

