/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.support.model.dlna;

import org.jupnp.model.types.InvalidValueException;
import org.jupnp.support.avtransport.lastchange.AVTransportVariable;
import org.jupnp.support.model.dlna.DLNAAttribute;
import org.jupnp.support.model.dlna.InvalidDLNAProtocolAttributeException;

public class DLNAPlaySpeedAttribute
extends DLNAAttribute<AVTransportVariable.TransportPlaySpeed[]> {
    public DLNAPlaySpeedAttribute() {
        this.setValue(new AVTransportVariable.TransportPlaySpeed[0]);
    }

    public DLNAPlaySpeedAttribute(AVTransportVariable.TransportPlaySpeed[] speeds) {
        this.setValue(speeds);
    }

    public DLNAPlaySpeedAttribute(String[] speeds) {
        AVTransportVariable.TransportPlaySpeed[] sp = new AVTransportVariable.TransportPlaySpeed[speeds.length];
        try {
            for (int i = 0; i < speeds.length; ++i) {
                sp[i] = new AVTransportVariable.TransportPlaySpeed(speeds[i]);
            }
        }
        catch (InvalidValueException invalidValueException) {
            throw new InvalidDLNAProtocolAttributeException("Can't parse DLNA play speeds.");
        }
        this.setValue(sp);
    }

    @Override
    public void setString(String s, String cf) {
        AVTransportVariable.TransportPlaySpeed[] value = null;
        if (s != null && !s.isEmpty()) {
            String[] speeds = s.split(",");
            try {
                value = new AVTransportVariable.TransportPlaySpeed[speeds.length];
                for (int i = 0; i < speeds.length; ++i) {
                    value[i] = new AVTransportVariable.TransportPlaySpeed(speeds[i]);
                }
            }
            catch (InvalidValueException invalidValueException) {
                value = null;
            }
        }
        if (value == null) {
            throw new InvalidDLNAProtocolAttributeException("Can't parse DLNA play speeds from: " + s);
        }
        this.setValue(value);
    }

    @Override
    public String getString() {
        StringBuilder sb = new StringBuilder();
        for (AVTransportVariable.TransportPlaySpeed speed : (AVTransportVariable.TransportPlaySpeed[])this.getValue()) {
            if (((String)speed.getValue()).equals("1")) continue;
            sb.append(sb.length() == 0 ? "" : ",").append(speed);
        }
        return sb.toString();
    }
}

