/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies;

import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import javax.swing.ImageIcon;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.TmmDateFormat;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaFileAudioStream;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.movie.MovieComparator;
import org.tinymediamanager.core.movie.MovieEdition;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieScraperMetadataConfig;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.entities.MediaCertification;
import org.tinymediamanager.scraper.util.DateUtils;
import org.tinymediamanager.scraper.util.StrgUtils;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.components.table.TmmTableFormat;
import org.tinymediamanager.ui.movies.MovieBorderTableCellRenderer;
import org.tinymediamanager.ui.renderer.DateTableCellRenderer;
import org.tinymediamanager.ui.renderer.IntegerTableCellRenderer;
import org.tinymediamanager.ui.renderer.RightAlignTableCellRenderer;
import org.tinymediamanager.ui.renderer.RuntimeTableCellRenderer;

public class MovieTableFormat
extends TmmTableFormat<Movie> {
    private final MovieList movieList = MovieModuleManager.getInstance().getMovieList();

    public MovieTableFormat() {
        Date date3;
        MovieComparator movieComparator = new MovieComparator();
        MovieComparator originalTitleComparator = new MovieComparator(){

            @Override
            public int compare(Movie movie1, Movie movie2) {
                if (this.stringCollator != null) {
                    String titleMovie1 = StrgUtils.normalizeString(movie1.getOriginalTitleSortable().toLowerCase(Locale.ROOT));
                    String titleMovie2 = StrgUtils.normalizeString(movie2.getOriginalTitleSortable().toLowerCase(Locale.ROOT));
                    return this.stringCollator.compare(titleMovie1, titleMovie2);
                }
                return movie1.getOriginalTitleSortable().toLowerCase(Locale.ROOT).compareTo(movie2.getOriginalTitleSortable().toLowerCase(Locale.ROOT));
            }
        };
        TmmTableFormat.StringComparator stringComparator = new TmmTableFormat.StringComparator();
        TmmTableFormat.FloatComparator floatComparator = new TmmTableFormat.FloatComparator();
        TmmTableFormat.ImageComparator imageComparator = new TmmTableFormat.ImageComparator();
        TmmTableFormat.DateComparator dateComparator = new TmmTableFormat.DateComparator();
        TmmTableFormat.DateTimeComparator dateTimeComparator = new TmmTableFormat.DateTimeComparator();
        TmmTableFormat.VideoFormatComparator videoFormatComparator = new TmmTableFormat.VideoFormatComparator();
        TmmTableFormat.FileSizeComparator fileSizeComparator = new TmmTableFormat.FileSizeComparator();
        TmmTableFormat.IntegerComparator integerComparator = new TmmTableFormat.IntegerComparator();
        TmmTableFormat.CertificationComparator certificationComparator = new TmmTableFormat.CertificationComparator();
        FontMetrics fontMetrics = this.getFontMetrics();
        TmmTableFormat.Column col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.title"), "title", movie -> movie, Movie.class);
        col.setColumnComparator(movieComparator);
        col.setCellRenderer(new MovieBorderTableCellRenderer());
        col.setCellTooltip(this.showTooltip(Movie::getTitleSortable));
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.originaltitle"), "originalTitle", movie -> movie, Movie.class);
        col.setColumnComparator(originalTitleComparator);
        col.setCellRenderer(new MovieBorderTableCellRenderer());
        col.setCellTooltip(this.showTooltip(Movie::getOriginalTitleSortable));
        col.setDefaultHidden(true);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.sorttitle"), "sortTitle", Movie::getSortTitle, String.class);
        col.setColumnComparator(stringComparator);
        col.setColumnResizeable(true);
        col.setCellTooltip(this.showTooltip(Movie::getSortTitle));
        col.setDefaultHidden(true);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.year"), "year", MediaEntity::getYear, Integer.class);
        col.setColumnComparator(integerComparator);
        col.setCellRenderer(new IntegerTableCellRenderer());
        col.setColumnResizeable(false);
        col.setMinWidth(fontMetrics.stringWidth("2000") + this.getCellPadding());
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.releasedate"), "releaseDate", Movie::getReleaseDate, Date.class);
        col.setColumnComparator(dateComparator);
        col.setHeaderIcon(IconManager.DATE_AIRED);
        col.setCellRenderer(new DateTableCellRenderer());
        col.setColumnResizeable(false);
        col.setDefaultHidden(true);
        try {
            Date date2 = DateUtils.parseDate("2012-12-12");
            col.setMinWidth(fontMetrics.stringWidth(TmmDateFormat.getDateFormat().format(date2)) + this.getCellPadding());
        }
        catch (Exception date2) {
            // empty catch block
        }
        this.addColumn(col);
        Function<Movie, String> pathFunction = movie -> movie.getPathNIO().toString();
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.path"), "path", pathFunction, String.class);
        col.setColumnComparator(stringComparator);
        col.setColumnResizeable(true);
        col.setCellTooltip(this.showTooltip(pathFunction));
        col.setDefaultHidden(true);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.filename"), "filename", movie -> movie.getMainVideoFile().getFilename(), String.class);
        col.setColumnComparator(stringComparator);
        col.setColumnResizeable(true);
        col.setCellTooltip(this.showTooltip(movie -> movie.getMainVideoFile().getFilename()));
        col.setDefaultHidden(true);
        this.addColumn(col);
        Function<Movie, String> movieSetFunction = movie -> movie.getMovieSet() == null ? null : movie.getMovieSet().getTitleSortable();
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.movieset"), "movieset", movieSetFunction, String.class);
        col.setColumnComparator(stringComparator);
        col.setColumnResizeable(true);
        col.setCellTooltip(this.showTooltip(movieSetFunction));
        col.setDefaultHidden(true);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.rating"), "rating", movie -> {
            Float ratingValue = null;
            MediaRating mediaRating = movie.getRating();
            if (mediaRating != MediaMetadata.EMPTY_RATING && mediaRating.getRating() > 0.0f) {
                ratingValue = Float.valueOf(mediaRating.getRatingNormalized());
            }
            return ratingValue;
        }, Float.class);
        col.setColumnComparator(floatComparator);
        col.setHeaderIcon(IconManager.RATING);
        col.setCellRenderer(new RightAlignTableCellRenderer());
        col.setColumnResizeable(false);
        col.setMinWidth(fontMetrics.stringWidth("99.9") + this.getCellPadding());
        col.setCellTooltip(this.showTooltip(movie -> movie.getRating().getRating() + " (" + movie.getRating().getVotes() + " " + TmmResourceBundle.getString("metatag.votes") + ")"));
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.votes"), "votes", movie -> movie.getRating() == MediaMetadata.EMPTY_RATING ? null : Integer.valueOf(movie.getRating().getVotes()), Integer.class);
        col.setColumnComparator(integerComparator);
        col.setHeaderIcon(IconManager.VOTES);
        col.setCellRenderer(new RightAlignTableCellRenderer());
        col.setColumnResizeable(false);
        col.setMinWidth(fontMetrics.stringWidth("1000000") + this.getCellPadding());
        col.setDefaultHidden(true);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.userrating"), "userrating", movie -> this.getRating(movie.getUserRating()), Float.class);
        col.setColumnComparator(floatComparator);
        col.setHeaderIcon(IconManager.USER_RATING);
        col.setCellRenderer(new RightAlignTableCellRenderer());
        col.setColumnResizeable(false);
        col.setMinWidth(fontMetrics.stringWidth("10.0") + this.getCellPadding());
        col.setDefaultHidden(true);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, "IMDb", "imdb", movie -> this.getRating(movie.getRating("imdb")), Float.class);
        col.setColumnComparator(floatComparator);
        col.setHeaderTooltip(TmmResourceBundle.getString("metatag.rating") + " - IMDb");
        col.setCellRenderer(new RightAlignTableCellRenderer());
        col.setColumnResizeable(false);
        col.setMinWidth(fontMetrics.stringWidth("IMDb") + this.getCellPadding());
        col.setDefaultHidden(true);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, "RT", "rottenTomatoes", movie -> this.getRatingInteger(movie.getRating("tomatometerallcritics")), Integer.class);
        col.setColumnComparator(integerComparator);
        col.setHeaderTooltip(TmmResourceBundle.getString("metatag.rating") + " - Rotten Tomatoes");
        col.setCellRenderer(new RightAlignTableCellRenderer());
        col.setColumnResizeable(false);
        col.setMinWidth(fontMetrics.stringWidth("100") + this.getCellPadding());
        col.setDefaultHidden(true);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, "MS", "metacritic", movie -> this.getRatingInteger(movie.getRating("metacritic")), Integer.class);
        col.setColumnComparator(integerComparator);
        col.setHeaderTooltip(TmmResourceBundle.getString("metatag.rating") + " - Metascore");
        col.setCellRenderer(new RightAlignTableCellRenderer());
        col.setColumnResizeable(false);
        col.setMinWidth(fontMetrics.stringWidth("100") + this.getCellPadding());
        col.setDefaultHidden(true);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, "TMDB", "tmdb", movie -> this.getRating(movie.getRating("tmdb")), Float.class);
        col.setColumnComparator(floatComparator);
        col.setHeaderTooltip(TmmResourceBundle.getString("metatag.rating") + " - TMDB");
        col.setCellRenderer(new RightAlignTableCellRenderer());
        col.setColumnResizeable(false);
        col.setMinWidth(fontMetrics.stringWidth("TMDB") + this.getCellPadding());
        col.setDefaultHidden(true);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, "T250", "top250", movie -> {
            if (movie.getTop250() == 0) {
                return null;
            }
            return movie.getTop250();
        }, Integer.class);
        col.setColumnComparator(integerComparator);
        col.setHeaderTooltip(TmmResourceBundle.getString("metatag.top250"));
        col.setCellRenderer(new RightAlignTableCellRenderer());
        col.setColumnResizeable(false);
        col.setMinWidth(fontMetrics.stringWidth("250") + this.getCellPadding());
        col.setDefaultHidden(true);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.certification"), "certification", Movie::getCertification, MediaCertification.class);
        col.setColumnComparator(certificationComparator);
        col.setHeaderIcon(IconManager.CERTIFICATION);
        col.setColumnResizeable(true);
        col.setMinWidth(fontMetrics.stringWidth("not rated") + this.getCellPadding());
        col.setDefaultHidden(true);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.dateadded"), "dateAdded", MediaEntity::getDateAddedForUi, Date.class);
        col.setColumnComparator(dateTimeComparator);
        col.setHeaderIcon(IconManager.DATE_ADDED);
        col.setCellRenderer(new DateTableCellRenderer());
        col.setColumnResizeable(false);
        col.setDefaultHidden(true);
        try {
            date3 = DateUtils.parseDate("2012-12-12");
            col.setMinWidth(fontMetrics.stringWidth(TmmDateFormat.getDateFormat().format(date3)) + this.getCellPadding());
        }
        catch (Exception date3) {
            // empty catch block
        }
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.filecreationdate"), "fileCreationDate", movie -> movie.getMainVideoFile().getDateCreated(), Date.class);
        col.setColumnComparator(dateTimeComparator);
        col.setHeaderIcon(IconManager.DATE_CREATED);
        col.setCellRenderer(new DateTableCellRenderer());
        col.setColumnResizeable(false);
        col.setDefaultHidden(true);
        try {
            date3 = DateUtils.parseDate("2012-12-12");
            col.setMinWidth(fontMetrics.stringWidth(TmmDateFormat.getDateFormat().format(date3)) + this.getCellPadding());
        }
        catch (Exception date4) {
            // empty catch block
        }
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.runtime") + " [min]", "runtime", Movie::getRuntime, Integer.class);
        col.setColumnComparator(integerComparator);
        col.setHeaderIcon(IconManager.RUNTIME);
        col.setCellRenderer(new RuntimeTableCellRenderer(RuntimeTableCellRenderer.FORMAT.MINUTES));
        col.setColumnResizeable(false);
        col.setMinWidth(fontMetrics.stringWidth("200") + this.getCellPadding());
        col.setDefaultHidden(true);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.runtime") + " [hh:mm]", "runtime2", Movie::getRuntime, Integer.class);
        col.setColumnComparator(integerComparator);
        col.setHeaderIcon(IconManager.RUNTIME);
        col.setCellRenderer(new RuntimeTableCellRenderer(RuntimeTableCellRenderer.FORMAT.HOURS_MINUTES));
        col.setColumnResizeable(false);
        col.setMinWidth(fontMetrics.stringWidth("4:00") + this.getCellPadding());
        col.setDefaultHidden(true);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.format"), "videoFormat", Movie::getMediaInfoVideoFormat, String.class);
        col.setColumnComparator(videoFormatComparator);
        col.setHeaderIcon(IconManager.VIDEO_FORMAT);
        col.setColumnResizeable(false);
        col.setCellRenderer(new RightAlignTableCellRenderer());
        col.setMinWidth(fontMetrics.stringWidth("1080p") + this.getCellPadding());
        col.setDefaultHidden(true);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.aspectratio"), "aspectRatio", Movie::getMediaInfoAspectRatio, Float.class);
        col.setColumnComparator(floatComparator);
        col.setHeaderIcon(IconManager.ASPECT_RATIO);
        col.setCellRenderer(new RightAlignTableCellRenderer());
        col.setColumnResizeable(false);
        col.setMinWidth(fontMetrics.stringWidth("1.78") + this.getCellPadding());
        col.setDefaultHidden(true);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.aspectratio2"), "aspectRatio2", Movie::getMediaInfoAspectRatio2, Float.class);
        col.setColumnComparator(floatComparator);
        col.setHeaderIcon(IconManager.ASPECT_RATIO_2);
        col.setCellRenderer(new RightAlignTableCellRenderer());
        col.setColumnResizeable(false);
        col.setMinWidth(fontMetrics.stringWidth("1.78") + this.getCellPadding());
        col.setDefaultHidden(true);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.hdr"), "hdr", movie -> this.getCheckIcon(movie.isVideoInHDR()), ImageIcon.class);
        col.setColumnComparator(imageComparator);
        col.setHeaderIcon(IconManager.HDR);
        col.setColumnResizeable(false);
        col.setDefaultHidden(true);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.hdrformat"), "hdrFormat", Movie::getVideoHDRFormat, String.class);
        col.setColumnComparator(stringComparator);
        col.setHeaderIcon(IconManager.HDR);
        col.setMinWidth(fontMetrics.stringWidth("HDR10") + this.getCellPadding());
        col.setDefaultHidden(true);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.videocodec"), "videoCodec", Movie::getMediaInfoVideoCodec, String.class);
        col.setColumnComparator(stringComparator);
        col.setHeaderIcon(IconManager.VIDEO_CODEC);
        col.setMinWidth(fontMetrics.stringWidth("MPEG-2") + this.getCellPadding());
        col.setDefaultHidden(true);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.videobitrate"), "videoBitrate", Movie::getMediaInfoVideoBitrate, Integer.class);
        col.setColumnComparator(integerComparator);
        col.setHeaderIcon(IconManager.VIDEO_BITRATE);
        col.setCellRenderer(new IntegerTableCellRenderer());
        col.setMinWidth(fontMetrics.stringWidth("20000") + this.getCellPadding());
        col.setDefaultHidden(true);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.audio"), "audio", movie -> {
            MediaFile mediaFile;
            List<MediaFile> videos = movie.getMediaFiles(MediaFileType.VIDEO);
            if (!videos.isEmpty() && StringUtils.isNotBlank((CharSequence)(mediaFile = videos.get(0)).getAudioCodec())) {
                return mediaFile.getAudioCodec() + " " + mediaFile.getAudioChannels();
            }
            return "";
        }, String.class);
        col.setColumnComparator(stringComparator);
        col.setHeaderIcon(IconManager.AUDIO);
        col.setMinWidth(fontMetrics.stringWidth("DTS 7ch") + this.getCellPadding());
        col.setDefaultHidden(true);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.audiostreamcount"), "audiostreamcount", movie -> {
            int count = movie.getMainVideoFile().getAudioStreams().size();
            for (MediaFile audioFile : movie.getMediaFiles(MediaFileType.AUDIO)) {
                count += audioFile.getAudioStreams().size();
            }
            return count;
        }, Integer.class);
        col.setColumnComparator(integerComparator);
        col.setHeaderIcon(IconManager.AUDIO);
        col.setMinWidth(fontMetrics.stringWidth("9") + this.getCellPadding());
        col.setCellTooltip(this.showTooltip(movie -> {
            ArrayList<MediaFileAudioStream> audioStreams = new ArrayList<MediaFileAudioStream>(movie.getMainVideoFile().getAudioStreams());
            movie.getMediaFiles(MediaFileType.AUDIO).forEach(mediaFile -> audioStreams.addAll(mediaFile.getAudioStreams()));
            ArrayList<Object> tooltipText = new ArrayList<Object>();
            for (MediaFileAudioStream audioStream : audioStreams) {
                Object stream = audioStream.getCodec();
                if (StringUtils.isNotBlank((CharSequence)audioStream.getLanguage())) {
                    stream = (String)stream + " - " + audioStream.getLanguage();
                }
                if (StringUtils.isNotBlank((CharSequence)audioStream.getTitle())) {
                    stream = (String)stream + " (" + audioStream.getTitle() + ")";
                }
                tooltipText.add(stream);
            }
            return StringUtils.join(tooltipText, (String)"\n");
        }));
        col.setDefaultHidden(true);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.videofilesize"), "fileSize", movie -> Utils.formatFileSizeForDisplay(movie.getVideoFilesize()), String.class);
        col.setColumnComparator(fileSizeComparator);
        col.setHeaderIcon(IconManager.FILE_SIZE);
        col.setCellRenderer(new RightAlignTableCellRenderer());
        col.setColumnResizeable(false);
        col.setMinWidth(fontMetrics.stringWidth("500.00 MB") + this.getCellPadding());
        col.setDefaultHidden(true);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.totalfilesize"), "totalFileSize", movie -> Utils.formatFileSizeForDisplay(movie.getTotalFilesize()), String.class);
        col.setColumnComparator(fileSizeComparator);
        col.setHeaderIcon(IconManager.FILE_SIZE);
        col.setCellRenderer(new RightAlignTableCellRenderer());
        col.setColumnResizeable(false);
        col.setMinWidth(fontMetrics.stringWidth("500.00 MB") + this.getCellPadding());
        col.setDefaultHidden(true);
        this.addColumn(col);
        Function<Movie, String> movieEditionFunction = movie -> movie.getEdition() == null || movie.getEdition() == MovieEdition.NONE ? null : movie.getEdition().toString();
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.edition"), "edition", movieEditionFunction, String.class);
        col.setColumnComparator(stringComparator);
        col.setHeaderIcon(IconManager.EDITION);
        col.setCellTooltip(this.showTooltip(movieEditionFunction));
        col.setDefaultHidden(true);
        this.addColumn(col);
        Function<Movie, String> mediaSourceFunction = movie -> movie.getMediaSource() == null ? null : movie.getMediaSource().toString();
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.source"), "mediaSource", mediaSourceFunction, String.class);
        col.setColumnComparator(stringComparator);
        col.setHeaderIcon(IconManager.SOURCE);
        col.setCellTooltip(this.showTooltip(mediaSourceFunction));
        col.setMinWidth(fontMetrics.stringWidth("Blu-ray") + this.getCellPadding());
        col.setDefaultHidden(true);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("movieextendedsearch.newmovies"), "new", movie -> this.getNewIcon(movie.isNewlyAdded()), ImageIcon.class);
        col.setColumnComparator(imageComparator);
        col.setHeaderIcon(IconManager.NEW);
        col.setColumnResizeable(false);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.3d"), "video3d", movie -> this.getCheckIcon(movie.isVideoIn3D()), ImageIcon.class);
        col.setColumnComparator(imageComparator);
        col.setHeaderIcon(IconManager.VIDEO_3D);
        col.setColumnResizeable(false);
        col.setDefaultHidden(true);
        this.addColumn(col);
        Function<Movie, String> nfoFunction = movie -> {
            ArrayList<MovieScraperMetadataConfig> values = new ArrayList<MovieScraperMetadataConfig>();
            if (MovieModuleManager.getInstance().getSettings().isMovieDisplayAllMissingMetadata()) {
                for (MovieScraperMetadataConfig config : MovieScraperMetadataConfig.values()) {
                    if (!config.isMetaData() && !config.isCast()) continue;
                    values.add(config);
                }
            } else {
                values.addAll(MovieModuleManager.getInstance().getSettings().getMovieCheckMetadata());
            }
            List<MovieScraperMetadataConfig> missingMetadata = this.movieList.detectMissingFields((Movie)movie, (List<MovieScraperMetadataConfig>)values);
            if (!missingMetadata.isEmpty()) {
                StringBuilder missing = new StringBuilder(TmmResourceBundle.getString("tmm.missing") + ":");
                for (MovieScraperMetadataConfig metadataConfig : missingMetadata) {
                    missing.append("\n").append(metadataConfig.getDescription());
                }
                return missing.toString();
            }
            return null;
        };
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("tmm.metadata"), "metadata", movie -> this.getCheckIcon(this.movieList.detectMissingMetadata((Movie)movie).isEmpty()), ImageIcon.class);
        col.setColumnComparator(imageComparator);
        col.setHeaderIcon(IconManager.NFO);
        col.setColumnResizeable(false);
        col.setCellTooltip(this.showTooltip(nfoFunction));
        this.addColumn(col);
        Function<Movie, String> imageFunction = movie -> {
            ArrayList<MovieScraperMetadataConfig> values = new ArrayList<MovieScraperMetadataConfig>();
            if (MovieModuleManager.getInstance().getSettings().isMovieDisplayAllMissingArtwork()) {
                for (MovieScraperMetadataConfig config : MovieScraperMetadataConfig.values()) {
                    if (!config.isArtwork()) continue;
                    values.add(config);
                }
            } else {
                values.addAll(MovieModuleManager.getInstance().getSettings().getMovieCheckArtwork());
            }
            List<MovieScraperMetadataConfig> missingMetadata = this.movieList.detectMissingFields((Movie)movie, (List<MovieScraperMetadataConfig>)values);
            if (!missingMetadata.isEmpty()) {
                StringBuilder missing = new StringBuilder(TmmResourceBundle.getString("tmm.missing") + ":");
                for (MovieScraperMetadataConfig metadataConfig : missingMetadata) {
                    missing.append("\n").append(metadataConfig.getDescription());
                }
                return missing.toString();
            }
            return null;
        };
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("tmm.images"), "images", movie -> this.getCheckIcon(this.movieList.detectMissingArtwork((Movie)movie).isEmpty()), ImageIcon.class);
        col.setColumnComparator(imageComparator);
        col.setHeaderIcon(IconManager.IMAGES);
        col.setColumnResizeable(false);
        col.setCellTooltip(this.showTooltip(imageFunction));
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("tmm.trailer"), "trailer", movie -> this.getCheckIcon(movie.getHasTrailer()), ImageIcon.class);
        col.setColumnComparator(imageComparator);
        col.setHeaderIcon(IconManager.TRAILER);
        col.setColumnResizeable(false);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("tmm.subtitles"), "subtitles", movie -> this.getCheckIcon(movie.getHasSubtitles()), ImageIcon.class);
        col.setColumnComparator(imageComparator);
        col.setHeaderIcon(IconManager.SUBTITLES);
        col.setColumnResizeable(false);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.watched"), "watched", movie -> this.getCheckIcon(movie.isWatched()), ImageIcon.class);
        col.setColumnComparator(imageComparator);
        col.setHeaderIcon(IconManager.WATCHED);
        col.setColumnResizeable(false);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.note"), "note", movie -> this.getCheckIcon(movie.getHasNote()), ImageIcon.class);
        col.setColumnComparator(imageComparator);
        col.setHeaderIcon(IconManager.INFO);
        col.setColumnResizeable(false);
        col.setDefaultHidden(true);
        this.addColumn(col);
    }

    private Float getRating(MediaRating rating) {
        if (rating == MediaMetadata.EMPTY_RATING) {
            return null;
        }
        return Float.valueOf(rating.getRating());
    }

    private Integer getRatingInteger(MediaRating rating) {
        if (rating == MediaMetadata.EMPTY_RATING) {
            return null;
        }
        return Math.round(rating.getRating());
    }

    private <E> Function<E, String> showTooltip(Function<E, String> tooltipFunction) {
        return movie -> {
            if (MovieModuleManager.getInstance().getSettings().isShowMovieTableTooltips()) {
                return (String)tooltipFunction.apply(movie);
            }
            return null;
        };
    }
}

