/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.util.Set;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.tvshows.TvShowSelectionModel;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;

public class DebugDumpShowActionWithChilds
extends TmmAction {
    private static final long serialVersionUID = 1L;

    public DebugDumpShowActionWithChilds() {
        this.putValue("Name", TmmResourceBundle.getString("debug.entity.dump") + " (with childs)");
        this.putValue("ShortDescription", TmmResourceBundle.getString("debug.entity.dump.desc"));
    }

    @Override
    protected void processAction(ActionEvent e) {
        TvShowSelectionModel.SelectedObjects sel = TvShowUIModule.getInstance().getSelectionModel().getSelectedObjects(true, true);
        Set<TvShow> selectedTvShows = sel.getTvShows();
        for (TvShow tvShow : selectedTvShows) {
            TvShowModuleManager.getInstance().dump(tvShow, true);
        }
        Set<TvShowSeason> selectedSeason = sel.getSeasons();
        for (TvShowSeason se : selectedSeason) {
            TvShowModuleManager.getInstance().dump(se, true);
        }
        Set<TvShowEpisode> set = sel.getEpisodes();
        for (TvShowEpisode ep : set) {
            TvShowModuleManager.getInstance().dump(ep);
        }
    }
}

