/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.codecompare.decompile;

import ghidra.app.decompiler.ClangFuncNameToken;
import ghidra.features.codecompare.decompile.AbstractMatchedTokensAction;
import ghidra.features.codecompare.decompile.DecompilerCodeComparisonView;
import ghidra.features.codecompare.decompile.DualDecompilerActionContext;
import ghidra.features.codecompare.decompile.TokenPair;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.util.Msg;
import ghidra.util.datastruct.Duo;

public abstract class AbstractMatchedCalleeTokensAction
extends AbstractMatchedTokensAction {
    protected static final String MENU_GROUP = "A2_ApplyCallee";

    public AbstractMatchedCalleeTokensAction(String actionName, String owner, DecompilerCodeComparisonView comparisonProvider, boolean disableOnReadOnly) {
        super(actionName, owner, comparisonProvider, disableOnReadOnly);
    }

    @Override
    protected boolean isEnabledForDualDecompilerContext(DualDecompilerActionContext context) {
        TokenPair tokenPair = context.getTokenPair();
        if (tokenPair == null) {
            return false;
        }
        if (tokenPair.leftToken() == null || tokenPair.rightToken() == null) {
            return false;
        }
        PcodeOp leftOp = tokenPair.leftToken().getPcodeOp();
        PcodeOp rightOp = tokenPair.rightToken().getPcodeOp();
        if (leftOp == null || rightOp == null) {
            return false;
        }
        if (leftOp.getOpcode() != 7 || rightOp.getOpcode() != 7) {
            return false;
        }
        return tokenPair.leftToken() instanceof ClangFuncNameToken && tokenPair.rightToken() instanceof ClangFuncNameToken;
    }

    @Override
    public void dualDecompilerActionPerformed(DualDecompilerActionContext context) {
        DecompilerCodeComparisonView provider = context.getCodeComparisonView();
        TokenPair currentPair = context.getTokenPair();
        ClangFuncNameToken leftFuncToken = (ClangFuncNameToken)currentPair.leftToken();
        ClangFuncNameToken rightFuncToken = (ClangFuncNameToken)currentPair.rightToken();
        Function leftFunction = this.getFuncFromToken(leftFuncToken, provider.getProgram(Duo.Side.LEFT));
        Function rightFunction = this.getFuncFromToken(rightFuncToken, provider.getProgram(Duo.Side.RIGHT));
        if (leftFunction == null || rightFunction == null) {
            return;
        }
        this.doCalleeActionPerformed(leftFunction, rightFunction);
    }

    protected abstract void doCalleeActionPerformed(Function var1, Function var2);

    private Function getFuncFromToken(ClangFuncNameToken funcToken, Program program) {
        Address callTarget = funcToken.getPcodeOp().getInput(0).getAddress();
        Function func = program.getFunctionManager().getFunctionAt(callTarget);
        if (func == null) {
            Msg.showWarn((Object)((Object)this), null, (String)"Unable to Compare Callees", (Object)("Can't compare callees - null Function for " + funcToken.getText()));
            return null;
        }
        if (func.isExternal()) {
            Msg.showWarn((Object)((Object)this), null, (String)"Unable to Compare Callees", (Object)("Can't compare callees - " + func.getName() + " is external"));
            return null;
        }
        if (!func.isThunk()) {
            return func;
        }
        if ((func = func.getThunkedFunction(true)).isExternal()) {
            Msg.showWarn((Object)((Object)this), null, (String)"Unable to Compare", (Object)("Can't compare callees - " + func.getName() + " is external"));
            return null;
        }
        return func;
    }
}

