/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.merge.datatypes;

import ghidra.app.merge.MergeManager;
import ghidra.app.merge.MergeResolver;
import ghidra.app.merge.datatypes.CategoryMergePanel;
import ghidra.app.merge.datatypes.DataTypeMergePanel;
import ghidra.app.merge.datatypes.SourceArchiveMergePanel;
import ghidra.framework.data.DomainObjectMergeManager;
import ghidra.program.database.data.DataTypeManagerDB;
import ghidra.program.database.data.DataTypeUtilities;
import ghidra.program.model.data.AbstractIntegerDataType;
import ghidra.program.model.data.AlignmentType;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.BadDataType;
import ghidra.program.model.data.BitFieldDataType;
import ghidra.program.model.data.BuiltIn;
import ghidra.program.model.data.Category;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeDependencyException;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataTypeManagerDomainObject;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.data.Enum;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.PackingType;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.program.model.data.ParameterDefinitionImpl;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.SourceArchive;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.data.TypedefDataType;
import ghidra.program.model.data.Union;
import ghidra.program.model.listing.DataTypeChangeSet;
import ghidra.util.HelpLocation;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.UniversalID;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;

public class DataTypeMergeManager
implements MergeResolver {
    private static String[] DATA_TYPES_PHASE = new String[]{"Data Types"};
    private static final int RESULT = 0;
    private static final int ORIGINAL = 3;
    private static final int LATEST = 1;
    private static final int MY = 2;
    static final int CANCELED = -2;
    static final int ASK_USER = -1;
    static final int OPTION_LATEST = 0;
    static final int OPTION_MY = 1;
    static final int OPTION_ORIGINAL = 2;
    private DomainObjectMergeManager mergeManager;
    private DataTypeManagerDomainObject[] domainObjects = new DataTypeManagerDomainObject[4];
    private DataTypeManager[] dtms = new DataTypeManager[4];
    private TaskMonitor currentMonitor;
    private int originalConflictOption;
    private int conflictOption;
    private HashMap<UniversalID, Boolean> dirtyMap;
    private ArrayList<Long> myArchiveAddedList;
    private ArrayList<Long> myArchiveChangeList;
    private ArrayList<Long> archiveConflictList;
    private SourceArchiveMergePanel archiveMergePanel;
    private ArrayList<Long> myCatAddedList;
    private ArrayList<Long> myCatChangeList;
    private ArrayList<Long> catConflictList;
    private CategoryMergePanel catMergePanel;
    private ArrayList<Long> myDtAddedList;
    private ArrayList<Long> myDtChangeList;
    private ArrayList<Long> dtConflictList;
    private ArrayList<Long> dtSourceConflictList;
    private ArrayList<Long> origDtConflictList;
    private DataTypeMergePanel dtMergePanel;
    private int totalConflictCount;
    private int currentConflictIndex;
    private MyIdentityHashMap<Long, DataType> myResolvedDts;
    private MyIdentityHashMap<Long, DataType> latestResolvedDts;
    private MyIdentityHashMap<Long, DataType> origResolvedDts;
    private List<FixUpInfo> fixUpList;
    private HashSet<Long> fixUpIDSet;
    private int progressIndex;
    private int categoryChoice = -1;
    private int dataTypeChoice = -1;
    private int sourceArchiveChoice = -1;

    public DataTypeMergeManager(DomainObjectMergeManager mergeManager, DataTypeManagerDomainObject resultDomainObject, DataTypeManagerDomainObject myDomainObject, DataTypeManagerDomainObject originalDomainObject, DataTypeManagerDomainObject latestDomainObject, DataTypeChangeSet latestChanges, DataTypeChangeSet myChanges) {
        this.mergeManager = mergeManager;
        this.domainObjects[0] = resultDomainObject;
        this.domainObjects[3] = originalDomainObject;
        this.domainObjects[1] = latestDomainObject;
        this.domainObjects[2] = myDomainObject;
        this.dtms[0] = resultDomainObject.getDataTypeManager();
        this.dtms[3] = originalDomainObject.getDataTypeManager();
        this.dtms[1] = latestDomainObject.getDataTypeManager();
        this.dtms[2] = myDomainObject.getDataTypeManager();
        this.totalConflictCount = 0;
        this.setupSourceArchiveChanges(latestChanges, myChanges);
        this.setupDataTypeChanges(latestChanges, myChanges);
        this.setupCategoryChanges(latestChanges, myChanges);
        this.originalConflictOption = -1;
        this.conflictOption = -1;
    }

    @Override
    public void apply() {
        if (this.catMergePanel != null && this.catMergePanel.isVisible()) {
            this.conflictOption = this.catMergePanel.getSelectedOption();
            if (this.catMergePanel.getUseForAll()) {
                this.categoryChoice = this.conflictOption;
            }
        } else if (this.dtMergePanel != null && this.dtMergePanel.isVisible()) {
            this.conflictOption = this.dtMergePanel.getSelectedOption();
            if (this.dtMergePanel.getUseForAll()) {
                this.dataTypeChoice = this.conflictOption;
            }
        } else {
            this.conflictOption = this.archiveMergePanel.getSelectedOption();
            if (this.archiveMergePanel.getUseForAll()) {
                this.sourceArchiveChoice = this.conflictOption;
            }
        }
    }

    @Override
    public void cancel() {
        this.conflictOption = -2;
    }

    @Override
    public String getDescription() {
        return "Merge Data Types and Categories";
    }

    @Override
    public String getName() {
        return "Data Type Merger";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void merge(TaskMonitor monitor) {
        this.mergeManager.setInProgress(DATA_TYPES_PHASE);
        this.currentMonitor = monitor;
        monitor.initialize((long)(this.totalConflictCount + this.myCatAddedList.size() + this.myCatChangeList.size() + this.myDtAddedList.size() + this.myDtChangeList.size()));
        int transactionID = this.domainObjects[0].startTransaction("Merge Categories/Data Types");
        boolean commit = false;
        try {
            this.mergeManager.updateProgress(0, "Data Type Merge is processing changed source archives...");
            this.processSourceArchiveChanges();
            this.mergeManager.updateProgress(2, "Data Type Merge is processing added source archives...");
            this.processSourceArchiveAdditions();
            this.mergeManager.updateProgress(4, "Data Type Merge is processing source archive conflicts...");
            this.processSourceArchiveConflicts();
            this.mergeManager.updateProgress(6, "Data Type Merge is processing category changes...");
            this.processCategoryChanges();
            this.mergeManager.updateProgress(12, "Data Type Merge is processing deleted data types...");
            this.processDataTypesDeleted();
            this.mergeManager.updateProgress(25, "Data Type Merge is processing added data types...");
            this.processDataTypesAdded();
            this.mergeManager.updateProgress(37, "Data Type Merge is processing changed data types...");
            this.processDataTypeChanges();
            this.mergeManager.updateProgress(50, "Data Type Merge is processing data type conflicts...");
            this.processDataTypeConflicts();
            this.mergeManager.updateProgress(62, "Data Type Merge is processing deleted categories...");
            this.processCategoriesDeleted();
            this.mergeManager.updateProgress(75, "Data Type Merge is processing added categories...");
            this.processCategoriesAdded();
            this.mergeManager.updateProgress(87, "Data Type Merge is processing category conflicts...");
            this.processCategoryConflicts();
            this.fixupDirtyFlags();
            this.mergeManager.updateProgress(100, this.getDescription());
            if (this.mergeManager != null) {
                this.mergeManager.setResolveInformation("ResolvedLatestDataTypes", this.latestResolvedDts);
                this.mergeManager.setResolveInformation("ResolvedMyDataTypes", this.myResolvedDts);
                this.mergeManager.setResolveInformation("ResolvedOriginalDataTypes", this.origResolvedDts);
            }
            commit = true;
        }
        catch (CancelledException cancelledException) {
        }
        finally {
            this.domainObjects[0].endTransaction(transactionID, commit);
        }
        this.mergeManager.setCompleted(DATA_TYPES_PHASE);
    }

    void setConflictResolution(int option) {
        this.conflictOption = option;
        this.originalConflictOption = option;
    }

    private void processSourceArchiveChanges() throws CancelledException {
        this.conflictOption = 1;
        for (Long element : this.myArchiveChangeList) {
            this.currentMonitor.checkCancelled();
            this.currentMonitor.setProgress((long)(++this.progressIndex));
            long id = element;
            this.updateSourceArchive(id);
        }
        this.resetOption();
    }

    private void updateSourceArchive(long id) {
        UniversalID universalID = new UniversalID(id);
        SourceArchive resultSourceArchive = this.dtms[0].getSourceArchive(universalID);
        SourceArchive sourceArchive = null;
        int optionToUse = this.sourceArchiveChoice == -1 ? this.conflictOption : this.sourceArchiveChoice;
        switch (optionToUse) {
            case 0: {
                return;
            }
            case 1: {
                sourceArchive = this.dtms[2].getSourceArchive(universalID);
                break;
            }
            case 2: {
                sourceArchive = this.dtms[3].getSourceArchive(universalID);
                break;
            }
            default: {
                return;
            }
        }
        if (resultSourceArchive == null) {
            if (sourceArchive != null) {
                this.addSourceArchive(sourceArchive);
            }
            return;
        }
        if (sourceArchive == null) {
            this.removeSourceArchive(universalID);
            return;
        }
        this.updateSourceName(resultSourceArchive, sourceArchive.getName());
        this.adjustTime(resultSourceArchive, this.dtms[2].getSourceArchive(universalID));
    }

    private void updateSourceName(SourceArchive resultSourceArchive, String name) {
        if (!resultSourceArchive.getName().equals(name)) {
            resultSourceArchive.setName(name);
        }
    }

    private void processSourceArchiveAdditions() throws CancelledException {
        for (Long element : this.myArchiveAddedList) {
            this.currentMonitor.checkCancelled();
            this.currentMonitor.setProgress((long)(++this.progressIndex));
            long id = element;
            UniversalID universalID = new UniversalID(id);
            SourceArchive mySourceArchive = this.dtms[2].getSourceArchive(universalID);
            this.addSourceArchive(mySourceArchive);
        }
    }

    private void addSourceArchive(SourceArchive mySourceArchive) {
        SourceArchive resultSourceArchive = this.dtms[0].getSourceArchive(mySourceArchive.getSourceArchiveID());
        if (resultSourceArchive != null) {
            this.adjustTime(resultSourceArchive, mySourceArchive);
            return;
        }
        ((DataTypeManagerDB)this.dtms[0]).resolveSourceArchive(mySourceArchive);
    }

    private void removeSourceArchive(UniversalID universalID) {
        SourceArchive resultSourceArchive = this.dtms[0].getSourceArchive(universalID);
        if (resultSourceArchive == null) {
            return;
        }
        ((DataTypeManagerDB)this.dtms[0]).removeSourceArchive(resultSourceArchive);
    }

    private void adjustTime(SourceArchive resultSourceArchive, SourceArchive mySourceArchive) {
        UniversalID sourceID;
        Boolean dirtyFlagObject;
        long resultTime = resultSourceArchive.getLastSyncTime();
        long myTime = mySourceArchive.getLastSyncTime();
        if (myTime > resultTime) {
            resultSourceArchive.setLastSyncTime(myTime);
        }
        if ((dirtyFlagObject = this.dirtyMap.get(sourceID = mySourceArchive.getSourceArchiveID())) != null) {
            boolean finalDirtyFlag = dirtyFlagObject;
            if (resultSourceArchive.isDirty() != finalDirtyFlag) {
                resultSourceArchive.setDirtyFlag(finalDirtyFlag);
            }
        }
    }

    private void fixupDirtyFlags() {
        for (UniversalID sourceID : this.dirtyMap.keySet()) {
            boolean isDirty = this.dirtyMap.get(sourceID);
            SourceArchive sourceArchive = this.dtms[0].getSourceArchive(sourceID);
            if (sourceArchive.isDirty() == isDirty) continue;
            sourceArchive.setDirtyFlag(isDirty);
        }
    }

    private void processSourceArchiveConflicts() throws CancelledException {
        for (Long element : this.archiveConflictList) {
            this.currentMonitor.checkCancelled();
            this.currentMonitor.setProgress((long)(++this.progressIndex));
            long sourceArchiveID = element;
            ++this.currentConflictIndex;
            this.handleSourceArchiveConflict(sourceArchiveID, this.currentConflictIndex);
        }
        this.archiveConflictList.clear();
    }

    private void handleSourceArchiveConflict(long sourceID, int conflictIndex) throws CancelledException {
        if (this.sourceArchiveChoice == -1 && this.conflictOption == -1 && this.mergeManager != null) {
            this.showArchiveMergePanel(sourceID, conflictIndex);
            if (this.conflictOption == -2) {
                throw new CancelledException();
            }
        }
        this.updateSourceArchive(sourceID);
        this.resetOption();
    }

    private void processCategoriesAdded() throws CancelledException {
        for (Long element : this.myCatAddedList) {
            this.currentMonitor.checkCancelled();
            this.currentMonitor.setProgress((long)(++this.progressIndex));
            long id = element;
            Category myCat = this.dtms[2].getCategory(id);
            CategoryPath myPath = myCat.getCategoryPath();
            if (this.dtms[0].containsCategory(myPath)) continue;
            this.dtms[0].createCategory(myPath);
        }
    }

    private void processCategoryConflicts() throws CancelledException {
        for (Long element : this.catConflictList) {
            this.currentMonitor.checkCancelled();
            this.currentMonitor.setProgress((long)(++this.progressIndex));
            long id = element;
            ++this.currentConflictIndex;
            this.handleCategoryConflict(id, this.currentConflictIndex);
        }
        this.catConflictList.clear();
    }

    private void handleCategoryConflict(long id, int conflictIndex) throws CancelledException {
        if (this.categoryChoice == -1 && this.conflictOption == -1 && this.mergeManager != null) {
            this.showCategoryMergePanel(id, conflictIndex);
        }
        if (this.categoryWasRenamed(id, this.dtms[2]) || this.categoryWasMoved(id, this.dtms[2])) {
            this.categoryRenamedOrMoved(id);
        }
        if (this.dtms[2].getCategory(id) == null || this.dtms[1].getCategory(id) == null) {
            this.categoryDeleted(id);
        }
        this.resetOption();
    }

    private void processCategoryChanges() throws CancelledException {
        for (Long element : this.myCatChangeList) {
            this.currentMonitor.checkCancelled();
            this.currentMonitor.setProgress((long)(++this.progressIndex));
            long id = element;
            this.processCategoryRenamed(id);
            this.processCategoryMoved(id);
        }
    }

    private void processCategoriesDeleted() throws CancelledException {
        for (Long element : this.myCatChangeList) {
            this.currentMonitor.checkCancelled();
            long id = element;
            this.processCategoryDeleted(id);
        }
    }

    private void processDataTypeConflicts() throws CancelledException {
        while (this.dtConflictList.size() > 0) {
            this.currentMonitor.checkCancelled();
            this.currentMonitor.setProgress((long)(++this.progressIndex));
            long id = this.dtConflictList.get(0);
            ++this.currentConflictIndex;
            this.handleDataTypeConflict(id, this.currentConflictIndex);
            this.dtConflictList.remove(id);
        }
        this.fixUpDataTypes();
        this.showUnresolvedFixups();
    }

    private void showUnresolvedFixups() {
        if (this.fixUpList.isEmpty()) {
            return;
        }
        int count = 0;
        boolean logOnly = false;
        StringBuffer sb = new StringBuffer();
        sb.append("The following data types failed to properly resolve, possibly due\nto missing dependencies (" + this.fixUpList.size() + " data type failures):\n");
        for (FixUpInfo info : this.fixUpList) {
            if (!logOnly && count++ == 30) {
                sb.append("List has been truncated.  See log for additional data type failures");
                String msg = sb.toString();
                MergeManager.showBlockingError("Unresolved Data Types and Components", msg);
                logOnly = true;
                sb = new StringBuffer();
                sb.append("Continuation of data type failure listing:\n");
            }
            DataTypeManager dtm = info.getDataTypeManager();
            DataType dt = dtm.getDataType(info.id);
            DataType compDt = dtm.getDataType(info.compID);
            sb.append("   ");
            String kind = this.getKind(dt);
            if (kind != null) {
                sb.append(kind);
                sb.append(" ");
            }
            sb.append(dt.getDisplayName());
            sb.append(", ");
            if (info.index < 0) {
                if (dt instanceof FunctionDefinition) {
                    sb.append("return-type");
                } else {
                    sb.append("dependency");
                }
            } else if (dt instanceof FunctionDefinition) {
                sb.append("param-");
                sb.append(info.index);
            } else if (dt instanceof Union) {
                sb.append("component-");
                sb.append(info.index);
            } else if (dt instanceof Structure) {
                Structure resultStruct = (Structure)info.ht.get(info.id);
                sb.append("component-");
                sb.append(info.index);
                if (!resultStruct.isPackingEnabled()) {
                    sb.append(", offset-");
                    sb.append("0x");
                    sb.append(Integer.toHexString(info.offset));
                }
            } else {
                sb.append("index-");
                sb.append(info.index);
            }
            sb.append(": ");
            sb.append(compDt.getDisplayName());
            sb.append("\n");
        }
        if (logOnly) {
            Msg.error((Object)this, (Object)sb.toString());
        } else {
            String msg = sb.toString();
            MergeManager.showBlockingError("Unresolved Data Types and Components", msg);
        }
    }

    private String getKind(DataType dt) {
        if (dt instanceof Structure) {
            return "Structure";
        }
        if (dt instanceof Union) {
            return "Union";
        }
        if (dt instanceof TypeDef) {
            return "Typedef";
        }
        if (dt instanceof FunctionDefinition) {
            return "Function-Definition";
        }
        if (dt instanceof Enum) {
            return "Enum";
        }
        return null;
    }

    private void handleDataTypeConflict(long id, int conflictIndex) throws CancelledException {
        DataType myDt = this.dtms[2].getDataType(id);
        if (this.dataTypeChoice == -1 && this.conflictOption == -1 && this.mergeManager != null) {
            DataType latestDt = this.dtms[1].getDataType(id);
            DataType origDt = this.dtms[3].getDataType(id);
            this.showDataTypeMergePanel(conflictIndex, latestDt, myDt, origDt);
            if (this.conflictOption == -2) {
                throw new CancelledException();
            }
        }
        this.applyDataTypeConflict(id);
        this.resetOption();
    }

    private void applyDataTypeConflict(long id) {
        boolean dtAdded = false;
        if (this.dataTypeWasRenamed(id, this.dtms[2]) || this.dataTypeWasMoved(id, this.dtms[2])) {
            dtAdded = this.dataTypeRenamedOrMoved(id);
        }
        if (!dtAdded) {
            DataType resultDt;
            boolean latestSourceChanged;
            boolean wasDeleted;
            boolean myChanged = this.dataTypeWasChanged(id, this.dtms[2]);
            boolean latestChanged = this.dataTypeWasChanged(id, this.dtms[1]);
            boolean bl = wasDeleted = this.dataTypeWasDeleted(id, this.dtms[2]) || this.dataTypeWasDeleted(id, this.dtms[1]);
            if (myChanged || latestChanged || wasDeleted) {
                this.dataTypeChanged(id);
            }
            boolean sameSource = !this.dataTypeSourceWasChanged(id, this.dtms[1], this.dtms[2]);
            boolean mySourceChanged = sameSource ? false : this.dataTypeSourceWasChanged(id, this.dtms[2]);
            boolean bl2 = latestSourceChanged = sameSource ? false : this.dataTypeSourceWasChanged(id, this.dtms[1]);
            if (mySourceChanged || latestSourceChanged) {
                this.changeSourceArchive(id);
            }
            if ((resultDt = this.dtms[0].getDataType(id)) != null) {
                long timeNow = System.currentTimeMillis();
                resultDt.setLastChangeTime(timeNow);
            }
        }
        if (this.dtSourceConflictList.contains(id)) {
            this.setSourceDataType(id);
        }
    }

    private void setSourceDataType(long myID) {
        DataType myDt = this.dtms[2].getDataType(myID);
        SourceArchive sourceArchive = myDt.getSourceArchive();
        UniversalID dataTypeID = myDt.getUniversalID();
        int optionToUse = this.dataTypeChoice == -1 ? this.conflictOption : this.dataTypeChoice;
        switch (optionToUse) {
            case 0: {
                break;
            }
            case 1: {
                DataType latestDt = this.dtms[0].getDataType(sourceArchive, dataTypeID);
                long resultID = this.dtms[0].getID(latestDt);
                try {
                    DataType resultDt = this.dtms[0].replaceDataType(latestDt, myDt, false);
                    CategoryPath myCategoryPath = myDt.getCategoryPath();
                    if (!resultDt.getCategoryPath().equals((Object)myCategoryPath)) {
                        resultDt.setCategoryPath(myCategoryPath);
                    }
                    this.myResolvedDts.put(myID, resultDt);
                    this.latestResolvedDts.put(resultID, resultDt);
                }
                catch (DataTypeDependencyException e) {
                    String msg = "Cannot replace data type named " + latestDt.getName() + ".\nProblem: " + e.getMessage();
                    MergeManager.showBlockingError("Error Replacing Data Type", msg);
                }
                catch (DuplicateNameException e) {
                    e.printStackTrace();
                }
                break;
            }
            case 2: {
                DataType latestDt3 = this.dtms[0].getDataType(sourceArchive, dataTypeID);
                long resultId3 = this.dtms[0].getID(latestDt3);
                if (!this.dtms[0].remove(latestDt3)) break;
                this.latestResolvedDts.put(resultId3, null);
            }
        }
    }

    private void changeSourceArchive(long dtID) {
        int optionToUse = this.dataTypeChoice == -1 ? this.conflictOption : this.dataTypeChoice;
        switch (optionToUse) {
            case 0: {
                break;
            }
            case 1: {
                this.updateDataTypeSource(dtID, this.dtms[2], this.myResolvedDts);
                break;
            }
            case 2: {
                this.updateDataTypeSource(dtID, this.dtms[3], this.origResolvedDts);
            }
        }
    }

    private void dataTypeChanged(long id) {
        int optionToUse = this.dataTypeChoice == -1 ? this.conflictOption : this.dataTypeChoice;
        switch (optionToUse) {
            case 0: {
                DataType latestDt = this.dtms[0].getDataType(id);
                if (latestDt == null) {
                    this.dataTypeDeleted(id);
                    break;
                }
                this.updateHashTables(id, latestDt, this.latestResolvedDts);
                break;
            }
            case 1: {
                DataType myDt = this.dtms[2].getDataType(id);
                if (myDt == null) {
                    this.dataTypeDeleted(id);
                    break;
                }
                this.updateDataType(id, this.dtms[2], this.myResolvedDts, true);
                break;
            }
            case 2: {
                this.dtms[3].getDataType(id);
                this.updateDataType(id, this.dtms[3], this.origResolvedDts, true);
            }
        }
    }

    private boolean dataTypeRenamedOrMoved(long id) {
        DataType newDt = null;
        switch (this.conflictOption) {
            case 0: {
                break;
            }
            case 1: {
                DataType myDt = this.dtms[2].getDataType(id);
                newDt = this.updateDataTypeName(id, myDt, this.myResolvedDts);
                break;
            }
            case 2: {
                DataType origDt = this.dtms[3].getDataType(id);
                newDt = this.updateDataTypeName(id, origDt, this.origResolvedDts);
            }
        }
        return newDt != null;
    }

    private DataType updateDataTypeName(long id, DataType dt, MyIdentityHashMap<Long, DataType> resolvedDataTypes) {
        DataType resultDt = this.dtms[0].getDataType(id);
        DataType newDt = null;
        if (resultDt != null) {
            this.setDataTypeName(resultDt, dt);
            this.setCategoryPath(resultDt, dt.getCategoryPath());
        } else {
            newDt = this.addDataType(id, dt, resolvedDataTypes);
        }
        return newDt;
    }

    private void dataTypeDeleted(long id) {
        DataType latestDt = this.dtms[0].getDataType(id);
        DataType myDt = this.dtms[2].getDataType(id);
        switch (this.conflictOption) {
            case 0: {
                DataType dt;
                if (latestDt != null || this.myDtAddedList.contains(id) || (dt = (DataType)this.myResolvedDts.get(id)) == null) break;
                this.dtms[0].remove(dt);
                this.origResolvedDts.remove(id);
                this.myResolvedDts.remove(id);
                break;
            }
            case 1: {
                if (myDt == null) {
                    if (latestDt == null) break;
                    this.dtms[0].remove(latestDt);
                    break;
                }
                this.addDataType(id, myDt, this.myResolvedDts);
                break;
            }
            case 2: {
                DataType origDt = this.dtms[3].getDataType(id);
                this.addDataType(id, origDt, this.origResolvedDts);
            }
        }
    }

    private void setCategoryPath(DataType dt, CategoryPath newPath) {
        if (dt.getCategoryPath().equals((Object)newPath)) {
            return;
        }
        try {
            dt.setCategoryPath(newPath);
        }
        catch (DuplicateNameException duplicateNameException) {
            // empty catch block
        }
    }

    private DataType updateDataType(long id, DataTypeManager dtm, MyIdentityHashMap<Long, DataType> resolvedDataTypes, boolean updatePath) {
        DataType resultDt = this.dtms[0].getDataType(id);
        DataType myDt = dtm.getDataType(id);
        if (resultDt == null) {
            resultDt = (DataType)resolvedDataTypes.get(id);
        }
        if (resultDt == null) {
            resultDt = this.addDataType(id, myDt, resolvedDataTypes);
        } else if (resultDt instanceof Composite) {
            this.updateComposite(id, (Composite)myDt, (Composite)resultDt, resolvedDataTypes);
        } else if (resultDt instanceof FunctionDefinition) {
            this.updateFunctionDef(id, (FunctionDefinition)myDt, (FunctionDefinition)resultDt, resolvedDataTypes);
        } else if (resultDt instanceof Enum) {
            ((Enum)resultDt).replaceWith(myDt);
        } else {
            try {
                resultDt = this.dtms[0].replaceDataType(resultDt, myDt, true);
            }
            catch (DataTypeDependencyException e) {
                String msg = "Cannot replace data type named " + resultDt.getName() + ".\nProblem: " + e.getMessage();
                MergeManager.showBlockingError("Error Replacing Data Type", msg);
                return null;
            }
        }
        this.updateHashTables(id, resultDt, resolvedDataTypes);
        if (updatePath && !resultDt.getCategoryPath().equals((Object)myDt.getCategoryPath())) {
            this.setCategoryPath(resultDt, myDt.getCategoryPath());
        }
        return resultDt;
    }

    private DataType updateDataTypeSource(long id, DataTypeManager dtm, MyIdentityHashMap<Long, DataType> resolvedDataTypes) {
        DataType resultDt = this.dtms[0].getDataType(id);
        DataType myDt = dtm.getDataType(id);
        SourceArchive mySourceArchive = myDt.getSourceArchive();
        if (resultDt == null) {
            resultDt = (DataType)resolvedDataTypes.get(id);
        }
        if (resultDt == null) {
            resultDt = this.addDataType(id, myDt, resolvedDataTypes);
        } else {
            SourceArchive resultSourceArchive = resultDt.getSourceArchive();
            if (!resultSourceArchive.getSourceArchiveID().equals((Object)mySourceArchive.getSourceArchiveID())) {
                resultDt.setSourceArchive(mySourceArchive);
            }
        }
        this.updateHashTables(id, resultDt, resolvedDataTypes);
        return resultDt;
    }

    private DataType addDataType(long dataTypeID, DataType dataType, MyIdentityHashMap<Long, DataType> resolvedDataTypes) {
        DataType existingDt = (DataType)resolvedDataTypes.get(dataTypeID);
        if (existingDt != null) {
            return existingDt;
        }
        if (!this.myDtAddedList.contains(dataTypeID) && (existingDt = this.dtms[0].getDataType(dataTypeID)) != null) {
            Msg.warn((Object)this, (Object)("Unexpectedly found data type \"" + existingDt.getPathName() + "\" when trying to add it."));
            return existingDt;
        }
        DataType newDt = dataType;
        if (dataType instanceof Composite) {
            return this.addComposite(dataTypeID, (Composite)dataType, resolvedDataTypes);
        }
        if (dataType instanceof Pointer) {
            newDt = this.createPointer(dataTypeID, (Pointer)dataType, resolvedDataTypes);
        } else if (dataType instanceof Array) {
            newDt = this.createArray(dataTypeID, (Array)dataType, resolvedDataTypes);
        } else if (dataType instanceof TypeDef) {
            newDt = this.createTypeDef(dataTypeID, (TypeDef)dataType, resolvedDataTypes);
        } else if (dataType instanceof FunctionDefinition) {
            newDt = this.addFunctionDef(dataTypeID, (FunctionDefinition)dataType, resolvedDataTypes);
        }
        if (newDt != null) {
            newDt = this.dtms[0].addDataType(newDt, DataTypeConflictHandler.DEFAULT_HANDLER);
            this.updateHashTables(dataTypeID, newDt, resolvedDataTypes);
        }
        return newDt;
    }

    private DataType getResolvedBaseType(long id, DataType dt, MyIdentityHashMap<Long, DataType> resolvedDataTypes) {
        DataTypeManager dtm = dt.getDataTypeManager();
        boolean doCheck = false;
        DataType baseDt = dt;
        if (baseDt instanceof TypeDef) {
            TypeDef td = (TypeDef)baseDt;
            baseDt = td.getDataType();
            doCheck = true;
        }
        if (baseDt instanceof Pointer || baseDt instanceof Array) {
            baseDt = DataTypeUtilities.getBaseDataType((DataType)baseDt);
            doCheck = true;
        }
        if (baseDt == null || baseDt == DataType.DEFAULT) {
            return DataType.DEFAULT;
        }
        if (!doCheck) {
            throw new AssertException("Unexpected condition - method only valid for typedef, pointer or array");
        }
        long baseID = dtm.getID(baseDt);
        DataType resolvedDt = (DataType)resolvedDataTypes.get(baseID);
        if (resolvedDt == null) {
            if (!this.myDtAddedList.contains(baseID)) {
                resolvedDt = this.dtms[0].getDataType(baseID);
                if (resolvedDt == null) {
                    if (baseDt instanceof BuiltIn || this.origDtConflictList.contains(baseID)) {
                        resolvedDt = this.addDataType(baseID, baseDt, resolvedDataTypes);
                    } else {
                        this.fixUpList.add(new FixUpInfo(id, baseID, baseDt, -1, resolvedDataTypes));
                    }
                } else {
                    resolvedDataTypes.put(baseID, resolvedDt);
                }
            } else {
                this.fixUpList.add(new FixUpInfo(id, baseID, baseDt, -1, resolvedDataTypes));
            }
        }
        return resolvedDt;
    }

    private DataType createPointer(long id, Pointer pointerDt, MyIdentityHashMap<Long, DataType> resolvedDataTypes) {
        DataType innerDt = pointerDt.getDataType();
        if (innerDt == DataType.DEFAULT || innerDt == null) {
            return pointerDt;
        }
        DataType resolvedDt = this.getResolvedBaseType(id, (DataType)pointerDt, resolvedDataTypes);
        if (resolvedDt != null) {
            if (innerDt instanceof Pointer || innerDt instanceof Array || innerDt instanceof TypeDef) {
                resolvedDt = this.addDataType(innerDt.getDataTypeManager().getID(innerDt), innerDt, resolvedDataTypes);
            }
            if (resolvedDt != null) {
                return PointerDataType.getPointer((DataType)resolvedDt, (int)(pointerDt.hasLanguageDependantLength() ? -1 : pointerDt.getLength()));
            }
        }
        return null;
    }

    private DataType createTypeDef(long id, TypeDef originalTypeDef, MyIdentityHashMap<Long, DataType> resolvedDataTypes) {
        DataType innerDataType = originalTypeDef.getDataType();
        if (innerDataType == DataType.DEFAULT) {
            return originalTypeDef;
        }
        SourceArchive originalSourceArchive = originalTypeDef.getSourceArchive();
        SourceArchive resultSourceArchive = this.getDataTypeManager(resolvedDataTypes).resolveSourceArchive(originalSourceArchive);
        DataType resolvedBaseDt = this.getResolvedBaseType(id, (DataType)originalTypeDef, resolvedDataTypes);
        if (resolvedBaseDt != null) {
            if (innerDataType instanceof Array || innerDataType instanceof Pointer || innerDataType instanceof TypeDef) {
                resolvedBaseDt = this.addDataType(innerDataType.getDataTypeManager().getID(innerDataType), innerDataType, resolvedDataTypes);
            }
            if (resolvedBaseDt != null) {
                TypedefDataType typedefDataType = new TypedefDataType(originalTypeDef.getCategoryPath(), originalTypeDef.getName(), resolvedBaseDt, originalTypeDef.getUniversalID(), resultSourceArchive, originalTypeDef.getLastChangeTime(), originalTypeDef.getLastChangeTimeInSourceArchive(), this.dtms[0]);
                return typedefDataType;
            }
        }
        return null;
    }

    private DataType createArray(long id, Array array, MyIdentityHashMap<Long, DataType> resolvedDataTypes) {
        DataType dt = array.getDataType();
        if (dt == DataType.DEFAULT) {
            return array;
        }
        DataType resolvedDt = this.getResolvedBaseType(id, (DataType)array, resolvedDataTypes);
        if (resolvedDt != null) {
            if (dt instanceof Array || dt instanceof Pointer || dt instanceof TypeDef) {
                resolvedDt = this.addDataType(dt.getDataTypeManager().getID(dt), dt, resolvedDataTypes);
            }
            if (resolvedDt != null) {
                int elementLen = resolvedDt instanceof Dynamic ? array.getElementLength() : resolvedDt.getLength();
                return new ArrayDataType(resolvedDt, array.getNumElements(), elementLen);
            }
        }
        return null;
    }

    private DataType addComposite(long id, Composite myDt, MyIdentityHashMap<Long, DataType> resolvedDataTypes) {
        long oldLastChangeTime = myDt.getLastChangeTime();
        long oldLastChangeTimeInSourceArchive = myDt.getLastChangeTimeInSourceArchive();
        DataType newDt = myDt.clone(this.dtms[0]);
        this.updateComposite(id, myDt, (Composite)newDt, resolvedDataTypes);
        SourceArchive originalSourceArchive = myDt.getSourceArchive();
        SourceArchive resultSourceArchive = this.getDataTypeManager(resolvedDataTypes).resolveSourceArchive(originalSourceArchive);
        newDt.setSourceArchive(resultSourceArchive);
        newDt = this.dtms[0].addDataType(newDt, DataTypeConflictHandler.DEFAULT_HANDLER);
        newDt.setLastChangeTime(oldLastChangeTime);
        newDt.setLastChangeTimeInSourceArchive(oldLastChangeTimeInSourceArchive);
        this.updateHashTables(id, newDt, resolvedDataTypes);
        return newDt;
    }

    private DataType addFunctionDef(long id, FunctionDefinition myDt, MyIdentityHashMap<Long, DataType> resolvedDataTypes) {
        FunctionDefinition newDt = (FunctionDefinition)myDt.clone(this.dtms[0]);
        this.setCategoryPath((DataType)newDt, myDt.getCategoryPath());
        this.updateFunctionDef(id, myDt, newDt, resolvedDataTypes);
        return newDt;
    }

    private void updateHashTables(long id, DataType newDt, Map<Long, DataType> resolvedDataTypes) {
        resolvedDataTypes.put(id, newDt);
        if (!this.myDtAddedList.contains(id)) {
            if (resolvedDataTypes == this.myResolvedDts) {
                this.origResolvedDts.put(id, newDt);
                this.latestResolvedDts.put(id, newDt);
            } else if (resolvedDataTypes == this.origResolvedDts) {
                this.myResolvedDts.put(id, newDt);
                this.latestResolvedDts.put(id, newDt);
            } else {
                this.origResolvedDts.put(id, newDt);
                this.myResolvedDts.put(id, newDt);
            }
        }
    }

    private DataType getResolvedComponent(long compID, Map<Long, DataType> resolvedDataTypes) {
        DataType resolvedDt = resolvedDataTypes.get(compID);
        if (resolvedDt != null) {
            DataType baseResultDt;
            DataTypeManager dtm;
            long baseID;
            if (resolvedDt.isDeleted()) {
                return null;
            }
            boolean doCheck = false;
            DataType baseDt = resolvedDt;
            if (baseDt instanceof TypeDef) {
                TypeDef td = (TypeDef)baseDt;
                baseDt = td.getDataType();
                doCheck = true;
            }
            if (baseDt instanceof Pointer || baseDt instanceof Array) {
                baseDt = DataTypeUtilities.getBaseDataType((DataType)baseDt);
                doCheck = true;
            }
            if (doCheck && baseDt != null && baseDt != DataType.DEFAULT && !this.myDtAddedList.contains(baseID = (dtm = baseDt.getDataTypeManager()).getID(baseDt)) && ((baseResultDt = this.dtms[0].getDataType(baseID)) == null || baseResultDt.isDeleted())) {
                return null;
            }
        }
        return resolvedDt;
    }

    private void removeFixUps(long sourceDtID) {
        if (!this.fixUpIDSet.remove(sourceDtID)) {
            return;
        }
        Iterator<FixUpInfo> iter = this.fixUpList.iterator();
        while (iter.hasNext()) {
            FixUpInfo info = iter.next();
            if (info.id != sourceDtID) continue;
            iter.remove();
        }
    }

    private static int computeNextNonPackedOrdinal(DataTypeComponent resultDtc, List<DataTypeComponent> compList, int index) {
        DataTypeComponent nextDtc;
        int undefinedSpace;
        int nextOrdinal = resultDtc.getOrdinal() + 1;
        if (index < compList.size() - 1 && (undefinedSpace = (nextDtc = compList.get(index + 1)).getOffset() - resultDtc.getOffset() - resultDtc.getLength()) > 0) {
            nextOrdinal += undefinedSpace;
        }
        return nextOrdinal;
    }

    private void updateStructure(long sourceDtID, Structure sourceDt, Structure destStruct, MyIdentityHashMap<Long, DataType> resolvedDataTypes) {
        this.removeFixUps(sourceDtID);
        destStruct.deleteAll();
        this.updateAlignment((Composite)sourceDt, (Composite)destStruct);
        DataTypeManager sourceDTM = sourceDt.getDataTypeManager();
        boolean packed = sourceDt.isPackingEnabled();
        DataTypeComponent[] comps = sourceDt.getDefinedComponents();
        ArrayList<DataTypeComponent> compList = new ArrayList<DataTypeComponent>();
        int prevOffset = -1;
        int index = -1;
        for (DataTypeComponent dtc : comps) {
            int offset = dtc.getOffset();
            if (offset == prevOffset) {
                compList.add(index, dtc);
                continue;
            }
            prevOffset = offset;
            index = compList.size();
            compList.add(dtc);
        }
        comps = null;
        HashMap<Long, String> badIdDtMsgs = new HashMap<Long, String>();
        for (int i = 0; i < compList.size(); ++i) {
            DataTypeComponent sourceComp = (DataTypeComponent)compList.get(i);
            DataType sourceCompDt = sourceComp.getDataType();
            BitFieldDataType bfDt = null;
            String comment = sourceComp.getComment();
            DataType resultCompDt = null;
            if (sourceComp.isBitFieldComponent() && (sourceCompDt = (bfDt = (BitFieldDataType)sourceCompDt).getBaseDataType()) instanceof AbstractIntegerDataType) {
                resultCompDt = sourceCompDt.clone(this.dtms[0]);
            }
            long sourceComponentID = sourceDTM.getID(sourceCompDt);
            if (resultCompDt == null) {
                resultCompDt = this.getResolvedComponent(sourceComponentID, resolvedDataTypes);
            }
            if (resultCompDt == null) {
                if (!this.myDtAddedList.contains(sourceComponentID)) {
                    resultCompDt = this.dtms[0].getDataType(sourceComponentID);
                }
                if (resultCompDt == null) {
                    this.fixUpList.add(new FixUpInfo(sourceDtID, sourceComponentID, sourceComp.getOrdinal(), sourceComp, resolvedDataTypes));
                    this.fixUpIDSet.add(sourceDtID);
                }
                if (!(bfDt == null || resultCompDt != null && BitFieldDataType.isValidBaseDataType((DataType)resultCompDt))) {
                    resultCompDt = bfDt.getPrimitiveBaseDataType();
                }
            }
            if (resultCompDt != null && !resultCompDt.isDeleted()) {
                AbstractIntegerDataType primitiveBaseDt;
                long dtId = this.dtms[0].getID(resultCompDt);
                String badMsg = (String)badIdDtMsgs.get(dtId);
                int length = resultCompDt.getLength();
                if (length <= 0) {
                    length = sourceComp.getLength();
                }
                if (packed) {
                    if (bfDt != null) {
                        try {
                            destStruct.addBitField(resultCompDt, bfDt.getDeclaredBitSize(), sourceComp.getFieldName(), comment);
                            continue;
                        }
                        catch (InvalidDataTypeException e) {
                            this.displayError((Composite)destStruct, (Exception)((Object)e));
                            primitiveBaseDt = bfDt.getPrimitiveBaseDataType();
                            comment = this.buildDataTypeFailureComment(sourceCompDt, e.getMessage(), sourceComp.getComment());
                            try {
                                destStruct.addBitField((DataType)primitiveBaseDt, bfDt.getDeclaredBitSize(), sourceComp.getFieldName(), comment);
                                continue;
                            }
                            catch (InvalidDataTypeException exc) {
                                throw new RuntimeException(exc);
                            }
                        }
                    }
                    if (badMsg == null) {
                        try {
                            destStruct.add(resultCompDt, length, sourceComp.getFieldName(), comment);
                        }
                        catch (IllegalArgumentException e) {
                            comment = this.buildDataTypeFailureComment(sourceCompDt, e.getMessage(), comment);
                            destStruct.add((DataType)BadDataType.dataType, sourceComp.getLength(), sourceComp.getFieldName(), comment);
                            if (e.getCause() instanceof DataTypeDependencyException) {
                                badIdDtMsgs.put(dtId, e.getMessage());
                            }
                            this.displayError((Composite)destStruct, e);
                        }
                        continue;
                    }
                    comment = this.buildDataTypeFailureComment(sourceCompDt, badMsg, comment);
                    destStruct.add((DataType)BadDataType.dataType, sourceComp.getLength(), sourceComp.getFieldName(), badMsg + "; " + comment);
                    continue;
                }
                if (bfDt != null) {
                    try {
                        destStruct.insertBitFieldAt(sourceComp.getOffset(), sourceComp.getLength(), bfDt.getBitOffset(), resultCompDt, bfDt.getDeclaredBitSize(), sourceComp.getFieldName(), comment);
                        continue;
                    }
                    catch (InvalidDataTypeException e) {
                        this.displayError((Composite)destStruct, (Exception)((Object)e));
                        primitiveBaseDt = bfDt.getPrimitiveBaseDataType();
                        comment = this.buildDataTypeFailureComment(sourceCompDt, e.getMessage(), sourceComp.getComment());
                        try {
                            destStruct.addBitField((DataType)primitiveBaseDt, bfDt.getDeclaredBitSize(), sourceComp.getFieldName(), comment);
                            continue;
                        }
                        catch (InvalidDataTypeException exc) {
                            throw new RuntimeException(exc);
                        }
                    }
                }
                if (badMsg == null) {
                    try {
                        if (i < compList.size() - 1) {
                            int offset = sourceComp.getOffset();
                            DataTypeComponent nextDtc = (DataTypeComponent)compList.get(i + 1);
                            int available = nextDtc.getOffset() - offset;
                            if (length > available) {
                                int extraBytesNeeded = length - available;
                                length = available;
                                String message = "Structure Merge: Not enough undefined bytes to fit " + resultCompDt.getPathName() + " in structure " + destStruct.getPathName() + " at offset 0x" + Integer.toHexString(offset) + ".\nIt needs " + extraBytesNeeded + " more byte(s) to be able to fit.";
                                Msg.warn((Object)this, (Object)message);
                            }
                        }
                        destStruct.insertAtOffset(sourceComp.getOffset(), resultCompDt, length, sourceComp.getFieldName(), comment);
                    }
                    catch (IllegalArgumentException e) {
                        comment = this.buildDataTypeFailureComment(sourceCompDt, e.getMessage(), comment);
                        destStruct.insertAtOffset(sourceComp.getOffset(), (DataType)BadDataType.dataType, length, sourceComp.getFieldName(), comment);
                        if (e.getCause() instanceof DataTypeDependencyException) {
                            badIdDtMsgs.put(dtId, e.getMessage());
                        }
                        this.displayError((Composite)destStruct, e);
                    }
                    continue;
                }
                comment = this.buildDataTypeFailureComment(sourceCompDt, badMsg, comment);
                destStruct.insertAtOffset(sourceComp.getOffset(), (DataType)BadDataType.dataType, sourceComp.getLength(), sourceComp.getFieldName(), comment);
                continue;
            }
            if (packed) {
                destStruct.add((DataType)BadDataType.dataType, sourceComp.getLength(), sourceComp.getFieldName(), comment);
                continue;
            }
            destStruct.insertAtOffset(sourceComp.getOffset(), (DataType)BadDataType.dataType, sourceComp.getLength(), sourceComp.getFieldName(), comment);
        }
        if (!packed) {
            DataTypeMergeManager.adjustStructureSize(destStruct, sourceDt.getLength());
        }
    }

    private static void adjustStructureSize(Structure struct, int preferredSize) {
        DataTypeComponent comp;
        DataTypeComponent dtc = struct.getComponentContaining(preferredSize);
        if (dtc == null) {
            struct.growStructure(preferredSize - struct.getLength());
            return;
        }
        int startOrdinal = dtc.getOrdinal();
        if (dtc.getOffset() != preferredSize) {
            ++startOrdinal;
        }
        for (int i = struct.getNumComponents() - 1; i >= startOrdinal && (comp = struct.getComponent(i)).getOffset() >= preferredSize && comp.getDataType() == DataType.DEFAULT; --i) {
            struct.delete(i);
        }
    }

    private void displayError(Composite destComposite, Exception e) {
        String msg = "Some of your changes to " + destComposite.getName() + " cannot be merged.\nProblem: " + e.getMessage();
        String typeName = destComposite instanceof Union ? "Union" : "Structure";
        MergeManager.showBlockingError(typeName + " Update Failed", msg);
    }

    private void updateUnion(long sourceDtID, Union sourceDt, Union destUnion, MyIdentityHashMap<Long, DataType> resolvedDataTypes) {
        this.removeFixUps(sourceDtID);
        while (destUnion.getNumComponents() > 0) {
            destUnion.delete(0);
        }
        this.updateAlignment((Composite)sourceDt, (Composite)destUnion);
        DataTypeManager sourceDTM = sourceDt.getDataTypeManager();
        for (DataTypeComponent sourceComp : sourceDt.getComponents()) {
            DataType sourceCompDt = sourceComp.getDataType();
            BitFieldDataType bfDt = null;
            String comment = sourceComp.getComment();
            DataType resultCompDt = null;
            if (sourceComp.isBitFieldComponent() && (sourceCompDt = (bfDt = (BitFieldDataType)sourceCompDt).getBaseDataType()) instanceof AbstractIntegerDataType) {
                resultCompDt = sourceCompDt.clone(this.dtms[0]);
            }
            long sourceCompID = sourceDTM.getID(sourceCompDt);
            if (resultCompDt == null) {
                resultCompDt = this.getResolvedComponent(sourceCompID, resolvedDataTypes);
            }
            if (resultCompDt == null) {
                if (!this.myDtAddedList.contains(sourceCompID)) {
                    DataType resultsDt = this.dtms[0].getDataType(sourceCompID);
                    if (resultsDt != null) {
                        resultCompDt = resultsDt;
                    } else {
                        FixUpInfo info = new FixUpInfo(sourceDtID, sourceCompID, sourceComp.getOrdinal(), sourceComp, resolvedDataTypes);
                        this.fixUpList.add(info);
                        this.fixUpIDSet.add(sourceDtID);
                    }
                } else {
                    this.fixUpList.add(new FixUpInfo(sourceDtID, sourceCompID, sourceComp.getOrdinal(), sourceComp, resolvedDataTypes));
                    this.fixUpIDSet.add(sourceDtID);
                }
                if (!(bfDt == null || resultCompDt != null && BitFieldDataType.isValidBaseDataType((DataType)resultCompDt))) {
                    resultCompDt = bfDt.getPrimitiveBaseDataType();
                }
            }
            if (resultCompDt != null) {
                if (bfDt != null) {
                    try {
                        destUnion.addBitField(resultCompDt, bfDt.getDeclaredBitSize(), sourceComp.getFieldName(), comment);
                        continue;
                    }
                    catch (InvalidDataTypeException e) {
                        this.displayError((Composite)destUnion, (Exception)((Object)e));
                        AbstractIntegerDataType primitiveBaseDt = bfDt.getPrimitiveBaseDataType();
                        comment = this.buildDataTypeFailureComment(sourceCompDt, e.getMessage(), sourceComp.getComment());
                        try {
                            destUnion.addBitField((DataType)primitiveBaseDt, bfDt.getDeclaredBitSize(), sourceComp.getFieldName(), comment);
                            continue;
                        }
                        catch (InvalidDataTypeException exc) {
                            throw new RuntimeException(exc);
                        }
                    }
                }
                int compLen = resultCompDt.getLength();
                if (compLen <= 0) {
                    compLen = sourceComp.getLength();
                }
                try {
                    destUnion.add(resultCompDt, compLen, sourceComp.getFieldName(), comment);
                }
                catch (IllegalArgumentException e) {
                    comment = this.buildDataTypeFailureComment(sourceCompDt, e.getMessage(), comment);
                    destUnion.add((DataType)BadDataType.dataType, compLen, sourceComp.getFieldName(), comment);
                    this.displayError((Composite)destUnion, e);
                }
                continue;
            }
            destUnion.add((DataType)BadDataType.dataType, sourceComp.getLength(), sourceComp.getFieldName(), comment);
        }
    }

    private void updateAlignment(Composite sourceDt, Composite destinationDt) {
        if (sourceDt.isDefaultAligned()) {
            destinationDt.setToDefaultAligned();
        } else if (sourceDt.isMachineAligned()) {
            destinationDt.setToMachineAligned();
        } else {
            destinationDt.setExplicitMinimumAlignment(sourceDt.getExplicitMinimumAlignment());
        }
        if (sourceDt.isPackingEnabled()) {
            if (sourceDt.hasExplicitPackingValue()) {
                destinationDt.setExplicitPackingValue(sourceDt.getExplicitPackingValue());
            } else {
                destinationDt.setToDefaultPacking();
            }
        } else {
            destinationDt.setPackingEnabled(false);
        }
    }

    private void updateComposite(long sourceDtID, Composite sourceDt, Composite destDt, MyIdentityHashMap<Long, DataType> resolvedDataTypes) {
        if (sourceDt instanceof Structure) {
            this.updateStructure(sourceDtID, (Structure)sourceDt, (Structure)destDt, resolvedDataTypes);
        } else {
            this.updateUnion(sourceDtID, (Union)sourceDt, (Union)destDt, resolvedDataTypes);
        }
    }

    private void updateFunctionDef(long sourceFunctionDefDtID, FunctionDefinition sourceFunctionDefDt, FunctionDefinition destDt, MyIdentityHashMap<Long, DataType> resolvedDataTypes) {
        this.removeFixUps(sourceFunctionDefDtID);
        long oldLastChangeTime = sourceFunctionDefDt.getLastChangeTime();
        long oldLastChangeTimeInSourceArchive = sourceFunctionDefDt.getLastChangeTimeInSourceArchive();
        DataTypeManager sourceDTM = sourceFunctionDefDt.getDataTypeManager();
        DataType sourceReturnType = sourceFunctionDefDt.getReturnType();
        ParameterDefinition[] sourceVars = sourceFunctionDefDt.getArguments();
        ParameterDefinition[] destVars = new ParameterDefinition[sourceVars.length];
        boolean sourceHasVarArgs = sourceFunctionDefDt.hasVarArgs();
        boolean sourceHasNoReturn = sourceFunctionDefDt.hasNoReturn();
        DataType resolvedRDT = DataType.DEFAULT;
        if (sourceReturnType != null) {
            long returnTypeID = sourceDTM.getID(sourceReturnType);
            resolvedRDT = this.getResolvedParam(sourceFunctionDefDtID, returnTypeID, sourceReturnType, -1, resolvedDataTypes);
        }
        destDt.setReturnType(resolvedRDT);
        for (int i = 0; i < sourceVars.length; ++i) {
            DataType varDt = sourceVars[i].getDataType();
            long varID = sourceDTM.getID(varDt);
            DataType resolvedDt = this.getResolvedParam(sourceFunctionDefDtID, varID, varDt, i, resolvedDataTypes);
            destVars[i] = new ParameterDefinitionImpl(sourceVars[i].getName(), resolvedDt, sourceVars[i].getComment());
        }
        destDt.setArguments(destVars);
        destDt.setVarArgs(sourceHasVarArgs);
        destDt.setNoReturn(sourceHasNoReturn);
        destDt.setLastChangeTime(oldLastChangeTime);
        destDt.setLastChangeTimeInSourceArchive(oldLastChangeTimeInSourceArchive);
    }

    private DataType getResolvedParam(long id, long paramDatatypeID, DataType sourceParamDataType, int index, MyIdentityHashMap<Long, DataType> resolvedDataTypes) {
        DataType resolvedDt = this.getResolvedComponent(paramDatatypeID, resolvedDataTypes);
        if (resolvedDt == null) {
            if (!this.myDtAddedList.contains(paramDatatypeID)) {
                DataType resultsDt = this.dtms[0].getDataType(paramDatatypeID);
                if (resultsDt != null) {
                    resolvedDt = resultsDt;
                } else {
                    resolvedDt = DataType.DEFAULT;
                    FixUpInfo info = new FixUpInfo(id, paramDatatypeID, sourceParamDataType, index, resolvedDataTypes);
                    this.fixUpList.add(info);
                    this.fixUpIDSet.add(id);
                }
            } else {
                resolvedDt = DataType.DEFAULT;
                this.fixUpList.add(new FixUpInfo(id, paramDatatypeID, sourceParamDataType, index, resolvedDataTypes));
                this.fixUpIDSet.add(id);
            }
        }
        return resolvedDt;
    }

    private void processDataTypeChanges() throws CancelledException {
        for (Long element : this.myDtChangeList) {
            this.currentMonitor.checkCancelled();
            this.currentMonitor.setProgress((long)(++this.progressIndex));
            long id = element;
            DataType dt = this.dtms[2].getDataType(id);
            if (dt instanceof Pointer || dt instanceof Array || dt instanceof BuiltIn) continue;
            this.processDataTypeRenamed(id);
            this.processDataTypeMoved(id);
            this.processDataTypeEdited(id);
            this.processDataTypeSourceChanged(id);
        }
    }

    private void processCategoryRenamed(long id) {
        Category resultCat;
        if (this.categoryWasRenamed(id, this.dtms[2]) && (resultCat = this.dtms[0].getCategory(id)) != null) {
            Category myCat = this.dtms[2].getCategory(id);
            String myCatName = myCat.getName();
            if (!resultCat.getName().equals(myCatName)) {
                this.setCategoryName(resultCat, myCatName);
            }
        }
    }

    private void processCategoryMoved(long id) {
        Category resultCat;
        Category myCat = this.dtms[2].getCategory(id);
        if (myCat == null) {
            return;
        }
        if (this.categoryWasMoved(id, this.dtms[2]) && (resultCat = this.dtms[0].getCategory(id)) != null) {
            Category myParent = myCat.getParent();
            Category resultNewParent = this.dtms[0].getCategory(myParent.getCategoryPath());
            if (resultNewParent == null) {
                resultNewParent = this.dtms[0].createCategory(myParent.getCategoryPath());
            }
            this.moveCategory(resultNewParent, resultCat);
        }
    }

    private void processCategoryDeleted(long id) {
        Category resultCat;
        Category myCat = this.dtms[2].getCategory(id);
        if (myCat == null && (resultCat = this.dtms[0].getCategory(id)) != null && !this.isParent(resultCat.getCategoryPath())) {
            resultCat.getParent().removeCategory(resultCat.getName(), this.currentMonitor);
        }
    }

    private boolean isParent(CategoryPath catPath) {
        for (Long id : this.myDtAddedList) {
            DataType dt = this.dtms[2].getDataType(id.longValue());
            if (!catPath.equals((Object)dt.getCategoryPath())) continue;
            return true;
        }
        return false;
    }

    private void moveCategory(Category newParent, Category category) {
        Category[] cats;
        for (Category cat : cats = newParent.getCategories()) {
            if (category != cat) continue;
            return;
        }
        Object newName = category.getName();
        String baseName = newName;
        int index = ((String)newName).indexOf(".conflict");
        if (index > 0) {
            baseName = ((String)newName).substring(0, index);
        }
        int oneUpNumber = 0;
        try {
            while (true) {
                if (newParent.getCategory((String)newName) == null) {
                    newParent.moveCategory(category, this.currentMonitor);
                    return;
                }
                newName = baseName + ".conflict" + ++oneUpNumber;
            }
        }
        catch (DuplicateNameException e) {
            throw new AssertException("Got DuplicateNameException");
        }
        catch (IllegalArgumentException e) {
            return;
        }
    }

    /*
     * Loose catch block
     */
    private void setCategoryName(Category category, String newName) {
        if (category.getName().equals(newName)) {
            return;
        }
        Object name = newName;
        String baseName = newName;
        int index = newName.indexOf(".conflict");
        if (index > 0) {
            baseName = newName.substring(0, index);
        }
        int oneUpNumber = 0;
        while (true) {
            try {
                category.setName((String)name);
                return;
            }
            catch (DuplicateNameException e) {
                name = baseName + ".conflict" + ++oneUpNumber;
                continue;
            }
            break;
        }
        catch (InvalidNameException e) {
            throw new AssertException("Got InvalidNameException: " + String.valueOf((Object)e));
        }
    }

    /*
     * Loose catch block
     */
    private void setDataTypeName(DataType dt, DataType dtToCopy) {
        if (this.isAutoNamedTypedef(dtToCopy) && dt instanceof TypeDef) {
            ((TypeDef)dt).enableAutoNaming();
            return;
        }
        Object newName = dtToCopy.getName();
        if (dt.getName().equals(newName)) {
            return;
        }
        String baseName = newName;
        int index = ((String)newName).indexOf(".conflict");
        if (index > 0) {
            baseName = ((String)newName).substring(0, index);
        }
        int oneUpNumber = 0;
        while (true) {
            try {
                dt.setName((String)newName);
                return;
            }
            catch (DuplicateNameException e) {
                newName = baseName + ".conflict" + ++oneUpNumber;
                continue;
            }
            break;
        }
        catch (InvalidNameException e) {
            throw new AssertException("Got InvalidNameException: " + String.valueOf((Object)e));
        }
    }

    private boolean categoryWasMoved(long id, DataTypeManager dtm1, DataTypeManager dtm2) {
        Category cat1 = dtm1.getCategory(id);
        Category cat2 = dtm2.getCategory(id);
        if (cat1 != null && cat2 != null) {
            Category parent1 = cat1.getParent();
            Category parent2 = cat2.getParent();
            if (parent1 != null && parent2 != null) {
                return !parent1.getCategoryPath().equals((Object)parent2.getCategoryPath());
            }
            return parent1 != null || parent2 != null;
        }
        return false;
    }

    private boolean categoryWasMoved(long id, DataTypeManager dtm) {
        return this.categoryWasMoved(id, this.dtms[3], dtm);
    }

    private boolean categoryWasRenamed(long id, DataTypeManager dtm1, DataTypeManager dtm2) {
        Category cat1 = dtm1.getCategory(id);
        Category cat2 = dtm2.getCategory(id);
        if (cat1 != null && cat2 != null) {
            return !cat1.getName().equals(cat2.getName());
        }
        return false;
    }

    private boolean categoryWasRenamed(long id, DataTypeManager dtm) {
        return this.categoryWasRenamed(id, this.dtms[3], dtm);
    }

    private boolean dataTypeWasMoved(long id, DataTypeManager dtm) {
        return this.dataTypeWasMoved(id, this.dtms[3], dtm);
    }

    private boolean dataTypeWasMoved(long id, DataTypeManager dtm1, DataTypeManager dtm2) {
        DataType dt1 = dtm1.getDataType(id);
        DataType dt2 = dtm2.getDataType(id);
        if (dt1 != null && dt2 != null) {
            CategoryPath p2;
            CategoryPath p1 = dt1.getCategoryPath();
            return !p1.equals((Object)(p2 = dt2.getCategoryPath()));
        }
        return false;
    }

    private boolean dataTypeWasRenamed(long id, DataTypeManager dtm) {
        return this.dataTypeWasRenamed(id, this.dtms[3], dtm);
    }

    private boolean isAutoNamedTypedef(DataType dt) {
        if (dt instanceof TypeDef) {
            TypeDef td = (TypeDef)dt;
            return td.isAutoNamed();
        }
        return false;
    }

    private boolean dataTypeWasRenamed(long id, DataTypeManager dtm1, DataTypeManager dtm2) {
        DataType dt1 = dtm1.getDataType(id);
        DataType dt2 = dtm2.getDataType(id);
        if (dt1 != null && dt2 != null) {
            String name2;
            if (this.isAutoNamedTypedef(dt1)) {
                return this.isAutoNamedTypedef(dt2);
            }
            if (this.isAutoNamedTypedef(dt2)) {
                return false;
            }
            String name1 = dt1.getName();
            return !name1.equals(name2 = dt2.getName());
        }
        return false;
    }

    private boolean dataTypeWasChanged(long id, DataTypeManager dtm) {
        return this.dataTypeWasChanged(id, this.dtms[3], dtm);
    }

    private boolean dataTypeWasChanged(long id, DataTypeManager dtm1, DataTypeManager dtm2) {
        DataType dt1 = dtm1.getDataType(id);
        DataType dt2 = dtm2.getDataType(id);
        if (dt1 != null && dt2 != null && dt1.getClass() == dt2.getClass()) {
            if (dt1 instanceof Composite) {
                Composite c1 = (Composite)dt1;
                Composite c2 = (Composite)dt2;
                return this.compositeDataTypeWasChanged(c1, c2);
            }
            return !dt1.isEquivalent(dt2);
        }
        return false;
    }

    private int getNumDefinedComponents(Composite c) {
        if (c instanceof Structure) {
            return ((Structure)c).getNumDefinedComponents();
        }
        return c.getNumComponents();
    }

    private boolean compositeDataTypeWasChanged(Composite c1, Composite c2) {
        int c2ComponentCnt;
        DataTypeManager dtm1 = c1.getDataTypeManager();
        DataTypeManager dtm2 = c2.getDataTypeManager();
        PackingType packingType = c1.getPackingType();
        AlignmentType alignmentType = c1.getAlignmentType();
        if (packingType != c2.getPackingType() || alignmentType != c2.getAlignmentType() || packingType == PackingType.EXPLICIT && c1.getExplicitPackingValue() != c2.getExplicitPackingValue() || alignmentType == AlignmentType.EXPLICIT && c1.getExplicitMinimumAlignment() != c2.getExplicitMinimumAlignment()) {
            return true;
        }
        int c1ComponentCnt = this.getNumDefinedComponents(c1);
        if (c1ComponentCnt != (c2ComponentCnt = this.getNumDefinedComponents(c2))) {
            return true;
        }
        boolean checkOffsets = false;
        if (c1 instanceof Structure && !((Structure)c1).isPackingEnabled()) {
            if (c1.getNumComponents() != c2.getNumComponents()) {
                return true;
            }
            checkOffsets = true;
        }
        DataTypeComponent[] c1Components = c1.getDefinedComponents();
        DataTypeComponent[] c2Components = c2.getDefinedComponents();
        for (int i = 0; i < c1ComponentCnt; ++i) {
            DataTypeComponent dtc1 = c1Components[i];
            DataTypeComponent dtc2 = c2Components[i];
            if (!this.isChangedComponent(dtc1, dtc2, dtm1, dtm2, checkOffsets)) continue;
            return true;
        }
        return false;
    }

    private boolean isChangedComponent(DataTypeComponent dtc1, DataTypeComponent dtc2, DataTypeManager dtm1, DataTypeManager dtm2, boolean checkOffsets) {
        if (checkOffsets && dtc1.getOffset() != dtc2.getOffset()) {
            return true;
        }
        if (dtm1.getID(dtc1.getDataType()) != dtm2.getID(dtc2.getDataType())) {
            return true;
        }
        return !Objects.equals(dtc1.getFieldName(), dtc2.getFieldName()) || !Objects.equals(dtc1.getComment(), dtc2.getComment());
    }

    private boolean dataTypeSourceWasChanged(long id, DataTypeManager dtm) {
        return this.dataTypeSourceWasChanged(id, this.dtms[3], dtm);
    }

    private boolean dataTypeSourceWasChanged(long id, DataTypeManager dtm1, DataTypeManager dtm2) {
        DataType dt1 = dtm1.getDataType(id);
        DataType dt2 = dtm2.getDataType(id);
        if (dt1 != null && dt2 != null) {
            SourceArchive sourceArchive1 = dt1.getSourceArchive();
            SourceArchive sourceArchive2 = dt2.getSourceArchive();
            if (!sourceArchive1.getSourceArchiveID().equals((Object)sourceArchive2.getSourceArchiveID())) {
                return true;
            }
            UniversalID universalID1 = dt1.getUniversalID();
            UniversalID universalID2 = dt2.getUniversalID();
            if (universalID1 == null || universalID2 == null) {
                String msg = "Null Universal ID encountered for data type ID " + id + "\n    DataType1 is \"" + dt1.getPathName() + "\".\n        Universal ID = " + String.valueOf(universalID1) + "\n        DataType Class = " + dt1.getClass().getName() + "\n        DataTypeManager = " + dtm1.getName() + "\n        Source Archive = " + sourceArchive1.getName() + "\n    DataType2 is \"" + dt2.getPathName() + "\".\n        Universal ID = " + String.valueOf(universalID2) + "\n        DataType Class = " + dt2.getClass().getName() + "\n        DataTypeManager = " + dtm2.getName() + "\n        Source Archive = " + sourceArchive2.getName() + "        ";
                Msg.error((Object)this, (Object)msg);
            }
            if (!Objects.equals(universalID1, universalID2)) {
                return true;
            }
        }
        return false;
    }

    private boolean dataTypeWasDeleted(long id, DataTypeManager dtm) {
        DataType dt1 = this.dtms[3].getDataType(id);
        DataType dt2 = dtm.getDataType(id);
        return dt1 != null && dt2 == null;
    }

    private void categoryRenamedOrMoved(long id) throws CancelledException {
        if (this.conflictOption == -2) {
            throw new CancelledException();
        }
        int optionToUse = this.categoryChoice == -1 ? this.conflictOption : this.categoryChoice;
        switch (optionToUse) {
            case 0: {
                break;
            }
            case 1: {
                this.useMyCategoryName(id);
                break;
            }
            case 2: {
                this.useOriginalCategoryName(id);
                break;
            }
            case -2: {
                throw new CancelledException();
            }
        }
    }

    private void useOriginalCategoryName(long id) {
        Category origCat = this.dtms[3].getCategory(id);
        Category resultCat = this.dtms[0].getCategory(id);
        this.setCategoryName(resultCat, origCat.getName());
        if (!resultCat.getCategoryPath().equals((Object)origCat.getCategoryPath())) {
            CategoryPath origParentCatPath = origCat.getCategoryPath().getParent();
            if (!this.dtms[0].containsCategory(origParentCatPath)) {
                this.dtms[0].createCategory(origParentCatPath);
            }
            Category parent = this.dtms[0].getCategory(origCat.getCategoryPath().getParent());
            this.moveCategory(parent, resultCat);
        }
    }

    private void useMyCategoryName(long id) {
        Category myCat = this.dtms[2].getCategory(id);
        Category resultCat = this.dtms[0].getCategory(id);
        if (resultCat != null) {
            this.setCategoryName(resultCat, myCat.getName());
            if (!resultCat.getCategoryPath().equals((Object)myCat.getCategoryPath())) {
                CategoryPath myParentCatPath = myCat.getCategoryPath().getParent();
                if (!this.dtms[0].containsCategory(myParentCatPath)) {
                    this.dtms[0].createCategory(myParentCatPath);
                }
                Category resultParentCat = this.dtms[0].getCategory(myCat.getCategoryPath().getParent());
                this.moveCategory(resultParentCat, resultCat);
            }
        } else {
            this.dtms[0].createCategory(myCat.getCategoryPath());
        }
    }

    private void categoryDeleted(long id) throws CancelledException {
        Category myCat = this.dtms[2].getCategory(id);
        Category latestCat = this.dtms[1].getCategory(id);
        Category origCat = this.dtms[3].getCategory(id);
        if (this.conflictOption == -2) {
            throw new CancelledException();
        }
        int optionToUse = this.categoryChoice == -1 ? this.conflictOption : this.categoryChoice;
        switch (optionToUse) {
            case 0: {
                if (latestCat == null || this.dtms[0].containsCategory(latestCat.getCategoryPath())) break;
                this.dtms[0].createCategory(latestCat.getCategoryPath());
                break;
            }
            case 1: {
                if (myCat == null) {
                    this.deleteLatestCategory(latestCat);
                    break;
                }
                this.dtms[0].createCategory(myCat.getCategoryPath());
                break;
            }
            case 2: {
                Category parentCat = this.dtms[0].getCategory(origCat.getParent().getCategoryPath());
                if (latestCat != null) {
                    if (this.categoryWasMoved(id, this.dtms[0])) {
                        Category resultCat = this.dtms[0].getCategory(id);
                        this.moveCategory(parentCat, resultCat);
                        break;
                    }
                    Category resultCat = this.dtms[0].getCategory(id);
                    if (resultCat != null) {
                        this.setCategoryName(resultCat, origCat.getName());
                        break;
                    }
                    this.dtms[0].createCategory(origCat.getCategoryPath());
                    break;
                }
                this.dtms[0].createCategory(origCat.getCategoryPath());
                break;
            }
            case -2: {
                throw new CancelledException();
            }
        }
    }

    private void deleteLatestCategory(Category latestCat) {
        Category parentCat;
        DataType[] dts = latestCat.getDataTypes();
        boolean doDelete = true;
        if (dts.length > 0) {
            for (DataType dt : dts) {
                long dtID = this.dtms[1].getID(dt);
                DataType myDt = this.dtms[2].getDataType(dtID);
                if (myDt == null || !myDt.getCategoryPath().equals((Object)dt.getCategoryPath())) continue;
                doDelete = false;
                break;
            }
        } else {
            Category[] cats;
            for (Category cat : cats = latestCat.getCategories()) {
                long catID = cat.getID();
                Category c = this.dtms[2].getCategory(catID);
                if (c == null || !c.getParent().getCategoryPath().equals((Object)cat.getParent().getCategoryPath())) continue;
                doDelete = false;
                break;
            }
        }
        if (doDelete && (parentCat = this.dtms[0].getCategory(latestCat.getParent().getCategoryPath())) != null) {
            parentCat.removeCategory(latestCat.getName(), TaskMonitor.DUMMY);
        }
    }

    private void showArchiveMergePanel(long id, int conflictIndex) {
        UniversalID sourceID = new UniversalID(id);
        SourceArchive mySourceArchive = this.dtms[2].getSourceArchive(sourceID);
        SourceArchive latestSourceArchive = this.dtms[1].getSourceArchive(sourceID);
        SourceArchive originalSourceArchive = this.dtms[3].getSourceArchive(sourceID);
        try {
            SwingUtilities.invokeAndWait(() -> {
                if (this.archiveMergePanel == null) {
                    this.archiveMergePanel = new SourceArchiveMergePanel(this.mergeManager, this.totalConflictCount);
                }
                this.archiveMergePanel.setConflictInfo(conflictIndex, latestSourceArchive, mySourceArchive, originalSourceArchive);
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        this.mergeManager.setApplyEnabled(false);
        this.mergeManager.showComponent((JComponent)this.archiveMergePanel, "SourceArchiveMerge", new HelpLocation("Repository", "SourceArchiveConflict"));
    }

    private void showCategoryMergePanel(long id, int conflictIndex) {
        Category myCat = this.dtms[2].getCategory(id);
        Category latestCat = this.dtms[1].getCategory(id);
        Category originalCat = this.dtms[3].getCategory(id);
        String latestPath = latestCat != null ? latestCat.getCategoryPathName() : null;
        String path = myCat != null ? myCat.getCategoryPathName() : null;
        String origPath = originalCat != null ? originalCat.getCategoryPathName() : null;
        try {
            SwingUtilities.invokeAndWait(() -> {
                if (this.catMergePanel == null) {
                    this.catMergePanel = new CategoryMergePanel(this.mergeManager, this.totalConflictCount);
                }
                this.catMergePanel.setConflictInfo(conflictIndex, latestPath, path, origPath, this.categoryWasRenamed(id, this.dtms[1]), this.categoryWasRenamed(id, this.dtms[2]), this.categoryWasMoved(id, this.dtms[1]), this.categoryWasMoved(id, this.dtms[2]), latestCat == null, myCat == null);
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        this.mergeManager.setApplyEnabled(false);
        this.mergeManager.showComponent((JComponent)this.catMergePanel, "CategoryMerge", new HelpLocation("Repository", "DataTypeConflict"));
    }

    private void showDataTypeMergePanel(int conflictIndex, DataType latestDt, DataType myDt, DataType origDt) {
        try {
            SwingUtilities.invokeAndWait(() -> {
                if (this.dtMergePanel == null) {
                    this.dtMergePanel = new DataTypeMergePanel(this.mergeManager, this.totalConflictCount);
                }
                this.dtMergePanel.setConflictInfo(conflictIndex, latestDt, myDt, origDt);
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        this.mergeManager.showComponent((JComponent)this.dtMergePanel, "DataTypeMerge", new HelpLocation("Repository", "DataTypeConflicts"));
    }

    private void processDataTypesDeleted() throws CancelledException {
        for (Long element : this.myDtChangeList) {
            this.currentMonitor.checkCancelled();
            long id = element;
            this.processDataTypeDeleted(id);
        }
    }

    private void processDataTypesAdded() throws CancelledException {
        for (Long element : this.myDtAddedList) {
            DataType myDt;
            this.currentMonitor.checkCancelled();
            this.currentMonitor.setProgress((long)(++this.progressIndex));
            long myDtKey = element;
            if (this.equivalentDataTypeFound(myDtKey, myDt = this.dtms[2].getDataType(myDtKey))) continue;
            if (myDt instanceof Composite || myDt instanceof Pointer || myDt instanceof Array || myDt instanceof TypeDef || myDt instanceof FunctionDefinition) {
                this.addDataType(myDtKey, myDt, this.myResolvedDts);
                continue;
            }
            DataType resolvedDt = this.dtms[0].addDataType(myDt, DataTypeConflictHandler.DEFAULT_HANDLER);
            this.myResolvedDts.put(myDtKey, resolvedDt);
        }
    }

    private boolean equivalentDataTypeFound(long myDtID, DataType myDt) {
        if (this.myResolvedDts.containsKey(myDtID)) {
            return true;
        }
        DataType resultDt = this.dtms[0].getDataType(myDt.getCategoryPath(), myDt.getName());
        if (resultDt != null) {
            SourceArchive resultSourceArchive = resultDt.getSourceArchive();
            SourceArchive mySourceArchive = myDt.getSourceArchive();
            UniversalID resultDtUniversalID = resultDt.getUniversalID();
            UniversalID myDtUniversalID = myDt.getUniversalID();
            if (!resultSourceArchive.getSourceArchiveID().equals((Object)mySourceArchive.getSourceArchiveID()) || !Objects.equals(resultDtUniversalID, myDtUniversalID)) {
                return false;
            }
            if (resultDt.isEquivalent(myDt)) {
                this.myResolvedDts.put(myDtID, resultDt);
                return true;
            }
        }
        return false;
    }

    private void fixUpDataTypes() {
        ArrayList<FixUpInfo> unresolvedFixups = new ArrayList<FixUpInfo>();
        Collections.sort(this.fixUpList);
        for (int i = 0; i < this.fixUpList.size(); ++i) {
            FixUpInfo info = this.fixUpList.get(i);
            DataType dt = (DataType)info.ht.get(info.id);
            if (dt instanceof Union) {
                int count = 1;
                for (int n = i + 1; n < this.fixUpList.size() && this.fixUpList.get((int)n).id == info.id; ++n) {
                    ++count;
                }
                this.fixUpUnion(info.id, (Union)dt, i, count, unresolvedFixups);
                i += count - 1;
                continue;
            }
            if (dt instanceof Structure) {
                Structure struct = (Structure)dt;
                if (this.fixUpStructure(info, struct)) continue;
                unresolvedFixups.add(info);
                continue;
            }
            if (dt instanceof FunctionDefinition) {
                FunctionDefinition fndef = (FunctionDefinition)dt;
                if (this.fixUpFunctionDef(info, fndef)) continue;
                unresolvedFixups.add(info);
                continue;
            }
            DataTypeManager dtm = info.getDataTypeManager();
            if (this.resolve(info.compID, dtm, info.ht) == null) continue;
            this.resolve(info.id, dtm, info.ht);
        }
        this.fixUpList = unresolvedFixups;
    }

    private String buildDataTypeFailureComment(DataType dt, String reason, String oldComment) {
        StringBuilder sb = new StringBuilder("Failed to apply '");
        sb.append(dt.getDisplayName());
        sb.append("'");
        if (!StringUtils.isBlank((CharSequence)reason)) {
            sb.append(", ");
            sb.append(reason);
        }
        if (!StringUtils.isBlank((CharSequence)oldComment)) {
            sb.append("; ");
            sb.append(oldComment);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fixUpFunctionDef(FixUpInfo info, FunctionDefinition fd) {
        DataType dt = this.resolve(info.compID, info.getDataTypeManager(), info.ht);
        long lastChangeTime = fd.getLastChangeTime();
        try {
            if (dt != null) {
                if (info.index < 0) {
                    fd.setReturnType(dt);
                } else {
                    ParameterDefinition[] args = fd.getArguments();
                    args[info.index].setDataType(dt);
                }
                boolean args = true;
                return args;
            }
            if (info.index < 0) {
            } else {
                ParameterDefinition[] args = fd.getArguments();
                ParameterDefinition arg = args[info.index];
                String comment = this.buildDataTypeFailureComment(info.componentDataType, null, arg.getComment());
                arg.setComment(comment);
            }
        }
        finally {
            fd.setLastChangeTime(lastChangeTime);
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    private boolean fixUpPackedStructureComponent(FixUpInfo info, Structure struct, DataType dt) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 7[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fixUpNonPackedStructureComponent(FixUpInfo info, Structure struct, DataType dt) {
        block20: {
            int ordinal = info.index;
            DataTypeComponent dtc = null;
            if (ordinal >= 0 || ordinal < struct.getNumComponents()) {
                dtc = struct.getComponent(ordinal);
            }
            long lastChangeTime = struct.getLastChangeTime();
            try {
                int bytesAvailable;
                int nextOffset;
                DataTypeComponent nextDefinedDtc;
                int bytesNeeded;
                if (dtc.isBitFieldComponent()) {
                    if (info.bitOffset < 0) {
                        throw new AssertException("Expected bitfield fixup location");
                    }
                    if (dt == null || dt.isDeleted()) {
                        String comment = this.buildDataTypeFailureComment(info.componentDataType, null, dtc.getComment());
                        dtc.setComment(comment);
                        boolean bl = false;
                        return bl;
                    }
                    if (!BitFieldDataType.isValidBaseDataType((DataType)dt)) break block20;
                    BitFieldDataType bfDt = (BitFieldDataType)dtc.getDataType();
                    struct.delete(ordinal);
                    try {
                        struct.insertBitFieldAt(dtc.getOffset(), bfDt.getLength(), bfDt.getBitOffset(), dt, bfDt.getDeclaredBitSize(), dtc.getFieldName(), dtc.getComment());
                        break block20;
                    }
                    catch (InvalidDataTypeException e) {
                        AbstractIntegerDataType primitiveBaseDt = bfDt.getPrimitiveBaseDataType();
                        String comment = this.buildDataTypeFailureComment(info.componentDataType, e.getMessage(), dtc.getComment());
                        try {
                            struct.insertBitFieldAt(dtc.getOffset(), bfDt.getLength(), bfDt.getBitOffset(), (DataType)primitiveBaseDt, bfDt.getDeclaredBitSize(), dtc.getFieldName(), comment);
                            break block20;
                        }
                        catch (InvalidDataTypeException exc) {
                            throw new RuntimeException(exc);
                        }
                    }
                }
                if (info.bitOffset >= 0) {
                    throw new AssertException("Unexpected bitfield fixup location");
                }
                if (dtc.getDataType() != BadDataType.dataType) {
                    throw new AssertException("Expected bad datatype placeholder");
                }
                if (dt == null || dt.isDeleted()) {
                    String comment = this.buildDataTypeFailureComment(info.componentDataType, null, dtc.getComment());
                    dtc.setComment(comment);
                    boolean e = false;
                    return e;
                }
                int offset = dtc.getOffset();
                int dtcLength = dtc.getLength();
                int length = dt.getLength();
                if (length <= 0) {
                    length = dtcLength;
                }
                if ((bytesNeeded = length - dtcLength) > 0 && (nextDefinedDtc = struct.getDefinedComponentAtOrAfterOffset(nextOffset = offset + dtcLength)) != null && (bytesAvailable = nextDefinedDtc.getOffset() - nextOffset) < bytesNeeded) {
                    length = dtcLength + bytesAvailable;
                    String message = "Structure Merge: Not enough undefined bytes to fit " + dt.getPathName() + " in structure " + struct.getPathName() + " at offset 0x" + Integer.toHexString(offset) + ".\nIt needs " + (bytesNeeded - bytesAvailable) + " more byte(s) to be able to fit.";
                    Msg.warn((Object)this, (Object)message);
                }
                try {
                    struct.replaceAtOffset(offset, dt, length, dtc.getFieldName(), dtc.getComment());
                }
                catch (IllegalArgumentException e) {
                    this.displayError((Composite)struct, e);
                    String comment = this.buildDataTypeFailureComment(info.componentDataType, e.getMessage(), dtc.getComment());
                    dtc.setComment(comment);
                }
            }
            finally {
                struct.setLastChangeTime(lastChangeTime);
            }
        }
        return true;
    }

    private boolean fixUpStructure(FixUpInfo info, Structure struct) {
        DataType compDt = this.resolve(info.compID, info.getDataTypeManager(), info.ht);
        if (struct.isPackingEnabled() ? this.fixUpPackedStructureComponent(info, struct, compDt) : this.fixUpNonPackedStructureComponent(info, struct, compDt)) {
            return true;
        }
        String loc = struct.isPackingEnabled() ? "ordinal " + info.index : "offset 0x" + Integer.toHexString(info.offset);
        Msg.warn((Object)this, (Object)("Structure Merge: Failed to resolve data type '" + info.componentDataType.getName() + "' at " + loc + " in " + struct.getPathName()));
        return false;
    }

    private boolean fixUpUnionComponent(Union union, FixUpInfo info) {
        DataType compDt = this.resolve(info.compID, info.getDataTypeManager(), info.ht);
        int ordinal = info.index;
        DataTypeComponent dtc = null;
        if (ordinal >= 0 && ordinal <= union.getNumComponents()) {
            dtc = union.getComponent(ordinal);
        }
        if (dtc == null) {
            throw new AssertException("Expected bad datatype placeholder");
        }
        if (dtc.isBitFieldComponent()) {
            if (info.bitOffset < 0) {
                throw new AssertException("Expected bitfield fixup location");
            }
            if (compDt == null || compDt.isDeleted()) {
                String comment = this.buildDataTypeFailureComment(info.componentDataType, null, dtc.getComment());
                dtc.setComment(comment);
            } else if (BitFieldDataType.isValidBaseDataType((DataType)compDt)) {
                BitFieldDataType bfDt = (BitFieldDataType)dtc.getDataType();
                union.delete(ordinal);
                try {
                    union.insertBitField(ordinal, compDt, bfDt.getDeclaredBitSize(), dtc.getFieldName(), dtc.getComment());
                    return true;
                }
                catch (InvalidDataTypeException e) {
                    Msg.error((Object)this, (Object)"Unexpected datatype merge fixup error", (Throwable)e);
                }
            }
        } else {
            if (info.bitOffset >= 0) {
                throw new AssertException("Unexpected bitfield fixup location");
            }
            if (dtc.getDataType() != BadDataType.dataType) {
                throw new AssertException("Expected bad datatype placeholder");
            }
            if (compDt == null || compDt.isDeleted()) {
                String comment = this.buildDataTypeFailureComment(info.componentDataType, null, dtc.getComment());
                dtc.setComment(comment);
                return false;
            }
            int length = compDt.getLength();
            if (length <= 0) {
                length = dtc.getLength();
            }
            union.delete(ordinal);
            try {
                union.insert(ordinal, compDt, length, dtc.getFieldName(), dtc.getComment());
                return true;
            }
            catch (IllegalArgumentException e) {
                this.displayError((Composite)union, e);
                String comment = this.buildDataTypeFailureComment(info.componentDataType, null, dtc.getComment());
                union.insert(ordinal, (DataType)BadDataType.dataType, dtc.getLength(), dtc.getFieldName(), comment);
            }
        }
        Msg.warn((Object)this, (Object)("Union Merge: Failed to resolve data type '" + info.componentDataType.getName() + "' at ordinal " + info.index + " in " + union.getPathName()));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fixUpUnion(long id, Union union, int firstFixupIndex, int fixupCount, ArrayList<FixUpInfo> unresolvedFixups) {
        long lastChangeTime = union.getLastChangeTime();
        try {
            int endIndex = firstFixupIndex + fixupCount;
            for (int i = firstFixupIndex; i < endIndex; ++i) {
                FixUpInfo info = this.fixUpList.get(i);
                if (this.fixUpUnionComponent(union, info)) continue;
                Msg.warn((Object)this, (Object)("Union Merge: Failed to apply data type at ordinal " + info.index + " in " + union.getPathName()));
                unresolvedFixups.add(info);
            }
        }
        finally {
            union.setLastChangeTime(lastChangeTime);
        }
    }

    private DataType resolve(long id, DataTypeManager dtm, MyIdentityHashMap<Long, DataType> resolvedDataTypes) {
        DataType dt = this.getResolvedComponent(id, resolvedDataTypes);
        if (dt == null && resolvedDataTypes.containsKey(id)) {
            return null;
        }
        if (dt == null && !this.myDtAddedList.contains(id)) {
            dt = this.dtms[0].getDataType(id);
        }
        if (dt == null) {
            long baseID;
            DataType rdt;
            DataType otherDt = dtm.getDataType(id);
            if (otherDt instanceof BuiltIn) {
                return otherDt;
            }
            boolean doCheck = false;
            DataType baseDt = otherDt;
            if (baseDt instanceof TypeDef) {
                TypeDef td = (TypeDef)baseDt;
                long baseID2 = dtm.getID(baseDt = td.getDataType());
                if (!this.myDtAddedList.contains(baseID2)) {
                    return null;
                }
                doCheck = true;
            }
            if (baseDt instanceof Pointer || baseDt instanceof Array) {
                baseDt = DataTypeUtilities.getBaseDataType((DataType)baseDt);
                doCheck = true;
            }
            if (doCheck && ((rdt = this.resolve(baseID = dtm.getID(baseDt), dtm, resolvedDataTypes)) != null && !rdt.isDeleted() || baseDt instanceof BuiltIn)) {
                dt = this.addDataType(id, otherDt, resolvedDataTypes);
            }
        }
        if (dt != null && dt.isDeleted()) {
            return null;
        }
        return dt;
    }

    private void processDataTypeSourceChanged(long id) {
        if (this.dataTypeSourceWasChanged(id, this.dtms[2])) {
            this.updateDataTypeSource(id, this.dtms[2], this.myResolvedDts);
        }
    }

    private void processDataTypeRenamed(long id) {
        DataType myDt = this.dtms[2].getDataType(id);
        DataType dt = this.dtms[0].getDataType(id);
        if (this.dataTypeWasRenamed(id, this.dtms[2]) && dt != null) {
            this.setDataTypeName(dt, myDt);
        }
    }

    private void processDataTypeEdited(long id) {
        if (this.dataTypeWasChanged(id, this.dtms[2])) {
            this.updateDataType(id, this.dtms[2], this.myResolvedDts, false);
        }
    }

    private void processDataTypeDeleted(long myDtID) {
        DataType myDt = this.dtms[2].getDataType(myDtID);
        if (myDt == null && (myDt = this.dtms[0].getDataType(myDtID)) != null) {
            this.dtms[0].remove(myDt);
        }
    }

    private void processDataTypeMoved(long id) {
        DataType resultDt;
        DataType myDt;
        CategoryPath myParentPath;
        if (this.dataTypeWasMoved(id, this.dtms[2]) && !(myParentPath = (myDt = this.dtms[2].getDataType(id)).getCategoryPath()).equals((Object)(resultDt = this.dtms[0].getDataType(id)).getCategoryPath())) {
            Category resultParent = this.dtms[0].createCategory(myParentPath);
            try {
                resultParent.moveDataType(resultDt, DataTypeConflictHandler.DEFAULT_HANDLER);
            }
            catch (DataTypeDependencyException e) {
                String msg = "Move data type named " + resultDt.getName() + " failed.\nProblem: " + e.getMessage();
                MergeManager.showBlockingError("Error Moving Data Type", msg);
            }
        }
    }

    private void setupSourceArchiveChanges(DataTypeChangeSet latestChanges, DataTypeChangeSet myChanges) {
        long[] latestArchiveChanges = latestChanges.getSourceArchiveChanges();
        long[] latestArchiveAdds = latestChanges.getSourceArchiveAdditions();
        Arrays.sort(latestArchiveChanges);
        Arrays.sort(latestArchiveAdds);
        long[] myArchiveChanges = myChanges.getSourceArchiveChanges();
        long[] myArchiveAdds = myChanges.getSourceArchiveAdditions();
        this.dirtyMap = new HashMap();
        this.archiveConflictList = new ArrayList();
        this.myArchiveChangeList = new ArrayList();
        this.myArchiveAddedList = new ArrayList();
        this.determineSourceArchiveAddConflicts(latestArchiveAdds, myArchiveAdds);
        this.determineSourceArchiveChangeConflicts(latestArchiveChanges, myArchiveChanges);
        this.totalConflictCount += this.archiveConflictList.size();
    }

    private void determineSourceArchiveChangeConflicts(long[] latestArchiveChanges, long[] myArchiveChanges) {
        for (long myChangeID : myArchiveChanges) {
            boolean changedInLatest;
            UniversalID sourceID = new UniversalID(myChangeID);
            Long myChangeIDObject = myChangeID;
            if (this.myArchiveAddedList.contains(myChangeIDObject) || this.archiveConflictList.contains(myChangeIDObject)) continue;
            SourceArchive mySourceArchive = this.dtms[2].getSourceArchive(sourceID);
            this.loadDirtyMap(sourceID, mySourceArchive);
            int searchIndex = Arrays.binarySearch(latestArchiveChanges, myChangeID);
            boolean bl = changedInLatest = searchIndex >= 0;
            if (changedInLatest) {
                boolean myChangedName;
                boolean removedLatest;
                SourceArchive origSourceArchive = this.dtms[3].getSourceArchive(sourceID);
                if (origSourceArchive == null) continue;
                SourceArchive latestSourceArchive = this.dtms[1].getSourceArchive(sourceID);
                boolean removedMy = mySourceArchive == null;
                boolean bl2 = removedLatest = latestSourceArchive == null;
                if (removedMy && removedLatest) continue;
                if (removedMy || removedLatest) {
                    this.archiveConflictList.add(myChangeIDObject);
                    continue;
                }
                String origName = origSourceArchive.getName();
                String latestName = latestSourceArchive.getName();
                String myName = mySourceArchive.getName();
                boolean sameName = StringUtils.equals((CharSequence)myName, (CharSequence)latestName);
                boolean latestChangedName = !StringUtils.equals((CharSequence)origName, (CharSequence)latestName);
                boolean bl3 = myChangedName = !StringUtils.equals((CharSequence)origName, (CharSequence)myName);
                if (!sameName && latestChangedName && myChangedName) {
                    this.archiveConflictList.add(myChangeIDObject);
                    continue;
                }
            }
            this.myArchiveChangeList.add(myChangeID);
        }
    }

    private void determineSourceArchiveAddConflicts(long[] latestArchiveAdds, long[] myArchiveAdds) {
        for (long myAddID : myArchiveAdds) {
            UniversalID sourceID = new UniversalID(myAddID);
            SourceArchive mySourceArchive = this.dtms[2].getSourceArchive(sourceID);
            if (mySourceArchive == null) continue;
            this.loadDirtyMap(sourceID, mySourceArchive);
            boolean foundConflict = false;
            for (long latestAddID : latestArchiveAdds) {
                if (myAddID != latestAddID) continue;
                SourceArchive latestSourceArchive = this.dtms[1].getSourceArchive(new UniversalID(latestAddID));
                if (StringUtils.equals((CharSequence)mySourceArchive.getName(), (CharSequence)latestSourceArchive.getName())) continue;
                this.archiveConflictList.add(myAddID);
                foundConflict = true;
                break;
            }
            if (foundConflict) continue;
            this.myArchiveAddedList.add(myAddID);
        }
    }

    private void loadDirtyMap(UniversalID sourceID, SourceArchive mySourceArchive) {
        if (mySourceArchive == null) {
            return;
        }
        if (!this.dirtyMap.containsKey(sourceID)) {
            SourceArchive latestSourceArchive = this.dtms[1].getSourceArchive(sourceID);
            boolean latestDirty = latestSourceArchive != null ? latestSourceArchive.isDirty() : false;
            boolean myDirty = mySourceArchive.isDirty();
            this.dirtyMap.put(sourceID, myDirty || latestDirty);
        }
    }

    private void setupDataTypeChanges(DataTypeChangeSet latestChanges, DataTypeChangeSet myChanges) {
        long[] latestDtChanges = latestChanges.getDataTypeChanges();
        long[] latestDtAdds = latestChanges.getDataTypeAdditions();
        long[] myDtChanges = myChanges.getDataTypeChanges();
        long[] myDtAdds = myChanges.getDataTypeAdditions();
        this.dtConflictList = new ArrayList();
        this.dtSourceConflictList = new ArrayList();
        this.myDtChangeList = new ArrayList();
        for (long myDtChange : myDtChanges) {
            this.myDtChangeList.add(myDtChange);
        }
        this.processAddIDs(myDtAdds);
        ArrayList<Long> resultDtChangeList = new ArrayList<Long>();
        for (long latestDtChange : latestDtChanges) {
            resultDtChangeList.add(latestDtChange);
        }
        ArrayList<Long> resultDtAddList = new ArrayList<Long>();
        for (long latestDtAdd : latestDtAdds) {
            resultDtAddList.add(latestDtAdd);
        }
        this.myDtChangeList.removeAll(this.myDtAddedList);
        this.myDtChangeList.removeAll(this.dtConflictList);
        this.dtConflictList.addAll(this.myDtChangeList);
        this.myDtChangeList.removeAll(resultDtChangeList);
        ArrayList<Long> resultDtCombinedList = new ArrayList<Long>();
        resultDtCombinedList.addAll(resultDtChangeList);
        resultDtCombinedList.addAll(resultDtAddList);
        this.dtConflictList.retainAll(resultDtCombinedList);
        resultDtCombinedList = null;
        this.eliminateFakeConflicts();
        this.origDtConflictList = new ArrayList<Long>(this.dtConflictList);
        this.myResolvedDts = new MyIdentityHashMap();
        this.latestResolvedDts = new MyIdentityHashMap();
        this.origResolvedDts = new MyIdentityHashMap();
        this.fixUpList = new ArrayList<FixUpInfo>();
        this.fixUpIDSet = new HashSet();
        this.totalConflictCount += this.dtConflictList.size();
    }

    private void processAddIDs(long[] myDtAdds) {
        this.myDtAddedList = new ArrayList();
        for (long myDtAdd : myDtAdds) {
            DataType myDt = this.dtms[2].getDataType(myDtAdd);
            if (myDt != null) {
                DataType resultDt;
                SourceArchive sourceArchive = myDt.getSourceArchive();
                UniversalID dataTypeID = myDt.getUniversalID();
                DataType dataType = resultDt = dataTypeID != null ? this.dtms[0].getDataType(sourceArchive, dataTypeID) : null;
                if (!(resultDt == null || resultDt.getCategoryPath().equals((Object)myDt.getCategoryPath()) && DataTypeUtilities.equalsIgnoreConflict((String)resultDt.getName(), (String)myDt.getName()) && resultDt.isEquivalent(myDt))) {
                    this.dtConflictList.add(myDtAdd);
                    this.dtSourceConflictList.add(myDtAdd);
                    continue;
                }
                this.myDtAddedList.add(myDtAdd);
                continue;
            }
            Long l = myDtAdd;
            if (this.myDtChangeList.contains(l)) continue;
            this.myDtChangeList.add(l);
        }
    }

    private void eliminateFakeConflicts() {
        for (int i = 0; i < this.dtConflictList.size(); ++i) {
            boolean wasDeleted;
            DataType latestDt;
            long id = this.dtConflictList.get(i);
            DataType myDt = this.dtms[2].getDataType(id);
            if (myDt instanceof Pointer || myDt instanceof Array) {
                this.dtConflictList.remove(i);
                --i;
                continue;
            }
            if (myDt == null && ((latestDt = this.dtms[1].getDataType(id)) instanceof Pointer || latestDt instanceof Array)) {
                this.dtConflictList.remove(i);
                --i;
                continue;
            }
            boolean renamedMy = this.dataTypeWasRenamed(id, this.dtms[2]) || this.dataTypeWasMoved(id, this.dtms[2]);
            boolean renamedLatest = this.dataTypeWasRenamed(id, this.dtms[1]) || this.dataTypeWasMoved(id, this.dtms[1]);
            boolean myChanged = this.dataTypeWasChanged(id, this.dtms[2]);
            boolean latestChanged = this.dataTypeWasChanged(id, this.dtms[1]);
            boolean sameSource = !this.dataTypeSourceWasChanged(id, this.dtms[1], this.dtms[2]);
            boolean mySourceChanged = sameSource ? false : this.dataTypeSourceWasChanged(id, this.dtms[2]);
            boolean latestSourceChanged = sameSource ? false : this.dataTypeSourceWasChanged(id, this.dtms[1]);
            boolean bl = wasDeleted = this.dataTypeWasDeleted(id, this.dtms[2]) || this.dataTypeWasDeleted(id, this.dtms[1]);
            if (!(this.dataTypeWasDeleted(id, this.dtms[2]) || this.dataTypeWasDeleted(id, this.dtms[1]) || this.dataTypeWasChanged(id, this.dtms[1], this.dtms[2]))) {
                myChanged = false;
                latestChanged = false;
            }
            if (!(wasDeleted || this.dataTypeWasRenamed(id, this.dtms[1], this.dtms[2]) || this.dataTypeWasMoved(id, this.dtms[1], this.dtms[2]))) {
                renamedMy = false;
                renamedLatest = false;
            }
            if (this.dtSourceConflictList.contains(id) || renamedMy && renamedLatest || renamedMy && wasDeleted || renamedLatest && wasDeleted || myChanged && latestChanged || (myChanged || latestChanged) && wasDeleted || mySourceChanged && latestSourceChanged || (mySourceChanged || latestSourceChanged) && wasDeleted) continue;
            this.dtConflictList.remove(i);
            if (myChanged || renamedMy || mySourceChanged) {
                this.myDtChangeList.add(id);
            }
            --i;
        }
        Collections.sort(this.dtConflictList);
    }

    private void setupCategoryChanges(DataTypeChangeSet latestChanges, DataTypeChangeSet myChanges) {
        this.myCatChangeList = new ArrayList();
        long[] myCatChanges = myChanges.getCategoryChanges();
        Arrays.sort(myCatChanges);
        for (long myCatChange : myCatChanges) {
            this.myCatChangeList.add(myCatChange);
        }
        this.myCatAddedList = new ArrayList();
        long[] myCatAdds = myChanges.getCategoryAdditions();
        Arrays.sort(myCatAdds);
        for (long myCatAdd : myCatAdds) {
            if (this.dtms[2].getCategory(myCatAdd) != null) {
                this.myCatAddedList.add(myCatAdd);
                continue;
            }
            Long l = myCatAdd;
            if (this.myCatChangeList.contains(l)) continue;
            this.myCatChangeList.add(l);
        }
        Collections.sort(this.myCatChangeList);
        long[] latestCatChanges = latestChanges.getCategoryChanges();
        Arrays.sort(latestCatChanges);
        ArrayList<Long> resultCatChangeList = new ArrayList<Long>();
        for (long latestCatChange : latestCatChanges) {
            resultCatChangeList.add(latestCatChange);
        }
        this.myCatChangeList.removeAll(this.myCatAddedList);
        this.catConflictList = new ArrayList<Long>(this.myCatChangeList);
        this.myCatChangeList.removeAll(resultCatChangeList);
        this.catConflictList.retainAll(resultCatChangeList);
        for (int i = 0; i < this.catConflictList.size(); ++i) {
            boolean wasDeleted;
            long id = this.catConflictList.get(i);
            if (this.dtms[2].getCategory(id) == null && this.dtms[1].getCategory(id) == null) {
                this.catConflictList.remove(i);
                --i;
                continue;
            }
            boolean renamedMy = this.categoryWasRenamed(id, this.dtms[2]) || this.categoryWasMoved(id, this.dtms[2]);
            boolean renamedLatest = this.categoryWasRenamed(id, this.dtms[1]) || this.categoryWasMoved(id, this.dtms[1]);
            boolean bl = wasDeleted = this.dtms[2].getCategory(id) == null || this.dtms[1].getCategory(id) == null;
            if (this.dtms[2].getCategory(id) != null && this.dtms[1].getCategory(id) != null && !this.categoryWasRenamed(id, this.dtms[2], this.dtms[1]) && !this.categoryWasMoved(id, this.dtms[2], this.dtms[1])) {
                renamedMy = false;
                renamedLatest = false;
            }
            if (renamedMy && renamedLatest || renamedMy && wasDeleted || renamedLatest && wasDeleted) continue;
            if (renamedMy) {
                this.myCatChangeList.add(id);
            }
            this.catConflictList.remove(i);
            --i;
        }
        this.totalConflictCount += this.catConflictList.size();
    }

    private void resetOption() {
        if (this.mergeManager != null) {
            this.conflictOption = this.originalConflictOption;
        }
    }

    @Override
    public String[][] getPhases() {
        return new String[][]{DATA_TYPES_PHASE};
    }

    private DataTypeManager getDataTypeManager(Map<Long, DataType> dataTypeMap) {
        if (dataTypeMap == this.origResolvedDts) {
            return this.dtms[3];
        }
        if (dataTypeMap == this.latestResolvedDts) {
            return this.dtms[0];
        }
        return this.dtms[2];
    }

    private static class MyIdentityHashMap<K, V>
    extends HashMap<K, V> {
        private MyIdentityHashMap() {
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this);
        }

        @Override
        public boolean equals(Object o) {
            return o == this;
        }
    }

    private class FixUpInfo
    implements Comparable<FixUpInfo> {
        final long id;
        final long compID;
        final DataType componentDataType;
        final int index;
        final MyIdentityHashMap<Long, DataType> ht;
        int offset = -1;
        int bitOffset = -1;
        int bitSize = -1;

        FixUpInfo(long id, long compID, DataType componentDataType, int index, MyIdentityHashMap<Long, DataType> resolvedDataTypes) {
            this.id = id;
            this.compID = compID;
            this.componentDataType = componentDataType;
            this.index = index;
            this.ht = resolvedDataTypes;
            if (componentDataType instanceof BitFieldDataType) {
                throw new IllegalArgumentException("BitFieldDataType not allowed - base type expected");
            }
        }

        FixUpInfo(long id, long compID, int destOrdinal, DataTypeComponent sourceDtc, MyIdentityHashMap<Long, DataType> resolvedDataTypes) {
            this(id, compID, FixUpInfo.getDataType(sourceDtc), destOrdinal, resolvedDataTypes);
            this.offset = sourceDtc.getOffset();
            if (sourceDtc.isBitFieldComponent()) {
                BitFieldDataType bfDt = (BitFieldDataType)sourceDtc.getDataType();
                this.bitSize = bfDt.getDeclaredBitSize();
                this.bitOffset = bfDt.getBitOffset();
            }
        }

        private static DataType getDataType(DataTypeComponent sourceDtc) {
            DataType dt = sourceDtc.getDataType();
            if (dt instanceof BitFieldDataType) {
                BitFieldDataType bfDt = (BitFieldDataType)dt;
                dt = bfDt.getBaseDataType();
            }
            return dt;
        }

        @Override
        public int compareTo(FixUpInfo o) {
            long c = this.id - o.id;
            if (c == 0L) {
                c = Integer.toUnsignedLong(o.index) - Integer.toUnsignedLong(this.index);
            }
            if (c == 0L) {
                return 0;
            }
            return c < 0L ? -1 : 1;
        }

        public String toString() {
            String htStr = "MY";
            DataTypeManager dtm = DataTypeMergeManager.this.dtms[2];
            if (this.ht == DataTypeMergeManager.this.origResolvedDts) {
                htStr = "ORIGINAL";
                dtm = DataTypeMergeManager.this.dtms[3];
            } else if (this.ht == DataTypeMergeManager.this.latestResolvedDts) {
                htStr = "LATEST/RESULTS";
                dtm = DataTypeMergeManager.this.dtms[1];
            }
            Object bitInfo = "";
            if (this.bitOffset >= 0) {
                bitInfo = "\nbitOffset=" + this.bitOffset + ",\nbitSize = " + this.bitSize + ",\n";
            }
            return "\nID = " + Long.toHexString(this.id) + ",\ndt = " + String.valueOf(dtm.getDataType(this.id)) + ",\ncomponent ID = " + Long.toHexString(this.compID) + ",\ncomponent dt = " + String.valueOf(dtm.getDataType(this.compID)) + ",\noffset/index = " + this.index + ",\n" + (String)bitInfo + "ht = " + htStr + "\n";
        }

        DataTypeManager getDataTypeManager() {
            if (this.ht == DataTypeMergeManager.this.origResolvedDts) {
                return DataTypeMergeManager.this.dtms[3];
            }
            if (this.ht == DataTypeMergeManager.this.latestResolvedDts) {
                return DataTypeMergeManager.this.dtms[0];
            }
            return DataTypeMergeManager.this.dtms[2];
        }
    }
}

