/*
 * Decompiled with CFR 0.152.
 */
package ghidra.bsfv;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.ToolBarData;
import ghidra.app.decompiler.CTokenHighlightMatcher;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.DecompilerHighlightService;
import ghidra.app.decompiler.DecompilerHighlighter;
import ghidra.bsfv.BSimFeatureVisualizerPlugin;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import java.awt.Color;
import resources.Icons;

public class ClearDecompilerHighlightsAction
extends DockingAction {
    BSimFeatureVisualizerPlugin plugin;

    public ClearDecompilerHighlightsAction(BSimFeatureVisualizerPlugin plugin) {
        super("Clear Decompiler Highlights", plugin.getName());
        this.plugin = plugin;
        this.setToolBarData(new ToolBarData(Icons.DELETE_ICON));
        this.setDescription("Remove decompiler highlights");
        this.setHelpLocation(new HelpLocation(plugin.getName(), "Removing_Decompiler_Highlights"));
    }

    public void actionPerformed(ActionContext context) {
        this.clearHighlights();
    }

    void clearHighlights() {
        DecompilerHighlightService service = (DecompilerHighlightService)this.plugin.getTool().getService(DecompilerHighlightService.class);
        if (service == null) {
            Msg.showError((Object)((Object)this), null, (String)"DecompilerHighlightService not found", (Object)"DecompilerHighlightService not found.");
            return;
        }
        DecompilerHighlighter highlighter = service.createHighlighter("BSimFeatureHighlighter", (CTokenHighlightMatcher)new ClearingHighlightMatcher(this));
        highlighter.applyHighlights();
    }

    private class ClearingHighlightMatcher
    implements CTokenHighlightMatcher {
        private ClearingHighlightMatcher(ClearDecompilerHighlightsAction clearDecompilerHighlightsAction) {
        }

        public Color getTokenHighlight(ClangToken token) {
            return null;
        }
    }
}

