/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import javajs.util.M4;
import javajs.util.P3i;
import javajs.util.SB;
import org.jmol.symmetry.SymmetryOperation;
import org.jmol.util.Logger;

public final class HallInfo {
    private String hallSymbol;
    private String primitiveHallSymbol;
    private char latticeCode = '\u0000';
    private String latticeExtension;
    private boolean isCentrosymmetric;
    private HallRotationTerm[] rotationTerms = new HallRotationTerm[16];
    protected int nRotations;
    protected P3i vector12ths;
    protected String vectorCode;

    HallInfo(String hallSymbol) {
        this.init(hallSymbol);
    }

    public int getRotationCount() {
        return this.nRotations;
    }

    public boolean isGenerated() {
        return this.nRotations > 0;
    }

    public char getLatticeCode() {
        return this.latticeCode;
    }

    public boolean isCentrosymmetric() {
        return this.isCentrosymmetric;
    }

    public String getHallSymbol() {
        return this.hallSymbol;
    }

    private void init(String hallSymbol) {
        try {
            String str = this.hallSymbol = hallSymbol.trim();
            str = this.extractLatticeInfo(str);
            if (HallTranslation.getLatticeIndex(this.latticeCode) == 0) {
                return;
            }
            this.latticeExtension = HallTranslation.getLatticeExtension(this.latticeCode, this.isCentrosymmetric);
            str = this.extractVectorInfo(str) + this.latticeExtension;
            if (Logger.debugging) {
                Logger.debug("Hallinfo: " + hallSymbol + " " + str);
            }
            int prevOrder = 0;
            char prevAxisType = '\u0000';
            this.primitiveHallSymbol = "P";
            while (str.length() > 0 && this.nRotations < 16) {
                str = this.extractRotationInfo(str, prevOrder, prevAxisType);
                HallRotationTerm r = this.rotationTerms[this.nRotations - 1];
                prevOrder = r.order;
                prevAxisType = r.axisType;
                this.primitiveHallSymbol = this.primitiveHallSymbol + " " + r.primitiveCode;
            }
            this.primitiveHallSymbol = this.primitiveHallSymbol + this.vectorCode;
        }
        catch (Exception e) {
            Logger.error("Invalid Hall symbol " + e);
            this.nRotations = 0;
        }
    }

    String dumpInfo() {
        SB sb = new SB();
        sb.append("\nHall symbol: ").append(this.hallSymbol).append("\nprimitive Hall symbol: ").append(this.primitiveHallSymbol).append("\nlattice type: ").append(this.getLatticeDesignation());
        for (int i = 0; i < this.nRotations; ++i) {
            sb.append("\n\nrotation term ").appendI(i + 1).append(this.rotationTerms[i].dumpInfo(this.vectorCode));
        }
        return sb.toString();
    }

    private String getLatticeDesignation() {
        return HallTranslation.getLatticeDesignation2(this.latticeCode, this.isCentrosymmetric);
    }

    private String extractLatticeInfo(String name) {
        int i = name.indexOf(" ");
        if (i < 0) {
            return "";
        }
        String term = name.substring(0, i).toUpperCase();
        this.latticeCode = term.charAt(0);
        if (this.latticeCode == '-') {
            this.isCentrosymmetric = true;
            this.latticeCode = term.charAt(1);
        }
        return name.substring(i + 1).trim();
    }

    private String extractVectorInfo(String name) {
        this.vector12ths = new P3i();
        this.vectorCode = "";
        int i = name.indexOf("(");
        int j = name.indexOf(")", i);
        if (i > 0 && j > i) {
            String term = name.substring(i + 1, j);
            this.vectorCode = " (" + term + ")";
            name = name.substring(0, i).trim();
            i = term.indexOf(" ");
            if (i >= 0) {
                this.vector12ths.x = Integer.parseInt(term.substring(0, i));
                if ((i = (term = term.substring(i + 1).trim()).indexOf(" ")) >= 0) {
                    this.vector12ths.y = Integer.parseInt(term.substring(0, i));
                    term = term.substring(i + 1).trim();
                }
            }
            this.vector12ths.z = Integer.parseInt(term);
        }
        return name;
    }

    private String extractRotationInfo(String name, int prevOrder, char prevAxisType) {
        String code;
        int i = name.indexOf(" ");
        if (i >= 0) {
            code = name.substring(0, i);
            name = name.substring(i + 1).trim();
        } else {
            code = name;
            name = "";
        }
        this.rotationTerms[this.nRotations] = new HallRotationTerm(this, code, prevOrder, prevAxisType);
        ++this.nRotations;
        return name;
    }

    public String toString() {
        return this.hallSymbol;
    }

    public void generateAllOperators(HallReceiver sg) {
        M4 mat1 = new M4();
        M4 operation = new M4();
        M4[] newOps = new M4[7];
        for (int i = 0; i < 7; ++i) {
            newOps[i] = new M4();
        }
        int nOps = sg.getMatrixOperationCount();
        for (int i = 0; i < this.nRotations; ++i) {
            HallRotationTerm rt = this.rotationTerms[i];
            mat1.setM4(rt.seitzMatrix12ths);
            int nRot = rt.order;
            newOps[0].setIdentity();
            for (int j = 1; j <= nRot; ++j) {
                M4 m = newOps[j];
                m.mul2(mat1, newOps[0]);
                newOps[0].setM4(m);
                int nNew = 0;
                for (int k = 0; k < nOps; ++k) {
                    operation.mul2(m, sg.getMatrixOperation(k));
                    operation.m03 = ((int)operation.m03 + 12) % 12;
                    operation.m13 = ((int)operation.m13 + 12) % 12;
                    operation.m23 = ((int)operation.m23 + 12) % 12;
                    if (!sg.addHallOperationCheckDuplicates(operation)) continue;
                    ++nNew;
                }
                nOps += nNew;
            }
        }
    }

    static String getHallLatticeEquivalent(int shellXLATTCode) {
        char latticeCode = HallTranslation.getLatticeCode(shellXLATTCode);
        boolean isCentrosymmetric = shellXLATTCode > 0;
        return (isCentrosymmetric ? "-" : "") + latticeCode + " 1";
    }

    static String getLatticeDesignation(int latt) {
        return HallTranslation.getLatticeDesignation(latt);
    }

    public static int getLatticeIndex(char latticeCode) {
        return HallTranslation.getLatticeIndex(latticeCode);
    }

    public static int getLatticeIndexFromCode(int latticeParameter) {
        return HallInfo.getLatticeIndex(HallTranslation.getLatticeCode(latticeParameter));
    }

    private static final class HallRotationTerm {
        String primitiveCode;
        M4 seitzMatrix12ths = new M4();
        int order;
        char axisType = '\u0000';
        private String inputCode;
        private String lookupCode;
        private String translationString;
        private HallRotation rotation;
        private HallTranslation translation;
        private boolean isImproper;
        private char diagonalReferenceAxis = '\u0000';
        private boolean allPositive = true;

        HallRotationTerm(HallInfo hallInfo, String code, int prevOrder, char prevAxisType) {
            this.inputCode = code;
            code = code + "   ";
            if (code.charAt(0) == '-') {
                this.isImproper = true;
                code = code.substring(1);
            }
            this.primitiveCode = "";
            this.order = code.charAt(0) - 48;
            this.diagonalReferenceAxis = '\u0000';
            this.axisType = '\u0000';
            int ptr = 2;
            char c = code.charAt(1);
            block0 : switch (c) {
                case 'x': 
                case 'y': 
                case 'z': {
                    switch (code.charAt(2)) {
                        case '\"': 
                        case '\'': {
                            this.diagonalReferenceAxis = c;
                            c = code.charAt(2);
                            ++ptr;
                        }
                    }
                }
                case '*': {
                    this.axisType = c;
                    break;
                }
                case '\"': 
                case '\'': {
                    this.axisType = c;
                    switch (code.charAt(2)) {
                        case 'x': 
                        case 'y': 
                        case 'z': {
                            this.diagonalReferenceAxis = code.charAt(2);
                            ++ptr;
                            break block0;
                        }
                    }
                    this.diagonalReferenceAxis = prevAxisType;
                    break;
                }
                default: {
                    this.axisType = (char)(this.order == 1 ? 95 : (hallInfo.nRotations == 0 ? 122 : (hallInfo.nRotations == 2 ? 42 : (prevOrder == 2 || prevOrder == 4 ? 120 : 39))));
                    code = code.substring(0, 1) + this.axisType + code.substring(1);
                }
            }
            this.primitiveCode = this.primitiveCode + (this.axisType == '_' ? "1" : code.substring(0, 2));
            if (this.diagonalReferenceAxis != '\u0000') {
                code = code.substring(0, 1) + this.diagonalReferenceAxis + this.axisType + code.substring(ptr);
                this.primitiveCode = this.primitiveCode + this.diagonalReferenceAxis;
                ptr = 3;
            }
            this.lookupCode = code.substring(0, ptr);
            this.rotation = HallRotation.lookup(this.lookupCode);
            if (this.rotation == null) {
                Logger.error("Rotation lookup could not find " + this.inputCode + " ? " + this.lookupCode);
                return;
            }
            this.translation = new HallTranslation('\u0000', null);
            this.translationString = "";
            int len = code.length();
            for (int i = ptr; i < len; ++i) {
                char translationCode = code.charAt(i);
                HallTranslation t = HallTranslation.getHallTranslation(translationCode, this.order);
                if (t == null) continue;
                this.translationString = this.translationString + "" + t.translationCode;
                this.translation.rotationShift12ths += t.rotationShift12ths;
                this.translation.vectorShift12ths.add(t.vectorShift12ths);
            }
            this.primitiveCode = (this.isImproper ? "-" : "") + this.primitiveCode + this.translationString;
            this.seitzMatrix12ths.setM4(this.isImproper ? this.rotation.seitzMatrixInv : this.rotation.seitzMatrix);
            this.seitzMatrix12ths.m03 = this.translation.vectorShift12ths.x;
            this.seitzMatrix12ths.m13 = this.translation.vectorShift12ths.y;
            this.seitzMatrix12ths.m23 = this.translation.vectorShift12ths.z;
            switch (this.axisType) {
                case 'x': {
                    this.seitzMatrix12ths.m03 += (float)this.translation.rotationShift12ths;
                    break;
                }
                case 'y': {
                    this.seitzMatrix12ths.m13 += (float)this.translation.rotationShift12ths;
                    break;
                }
                case 'z': {
                    this.seitzMatrix12ths.m23 += (float)this.translation.rotationShift12ths;
                }
            }
            if (hallInfo.vectorCode.length() > 0) {
                M4 m1 = M4.newM4(null);
                M4 m2 = M4.newM4(null);
                P3i v = hallInfo.vector12ths;
                m1.m03 = v.x;
                m1.m13 = v.y;
                m1.m23 = v.z;
                m2.m03 = -v.x;
                m2.m13 = -v.y;
                m2.m23 = -v.z;
                this.seitzMatrix12ths.mul2(m1, this.seitzMatrix12ths);
                this.seitzMatrix12ths.mul(m2);
            }
            if (Logger.debugging) {
                Logger.debug("code = " + code + "; primitive code =" + this.primitiveCode + "\n Seitz Matrix(12ths):" + this.seitzMatrix12ths);
            }
        }

        String dumpInfo(String vectorCode) {
            SB sb = new SB();
            sb.append("\ninput code: ").append(this.inputCode).append("; primitive code: ").append(this.primitiveCode).append("\norder: ").appendI(this.order).append(this.isImproper ? " (improper axis)" : "");
            if (this.axisType != '_') {
                sb.append("; axisType: ").appendC(this.axisType);
                if (this.diagonalReferenceAxis != '\u0000') {
                    sb.appendC(this.diagonalReferenceAxis);
                }
            }
            if (this.translationString.length() > 0) {
                sb.append("; translation: ").append(this.translationString);
            }
            if (vectorCode.length() > 0) {
                sb.append("; vector offset: ").append(vectorCode);
            }
            if (this.rotation != null) {
                sb.append("\noperator: ").append(this.getXYZ(this.allPositive)).append("\nSeitz matrix:\n").append(SymmetryOperation.dumpSeitz(this.seitzMatrix12ths, false));
            }
            return sb.toString();
        }

        String getXYZ(boolean allPositive) {
            return SymmetryOperation.getXYZFromMatrix(this.seitzMatrix12ths, true, allPositive, true);
        }
    }

    private static final class HallTranslation {
        protected char translationCode = '\u0000';
        protected int rotationOrder;
        protected int rotationShift12ths;
        protected P3i vectorShift12ths;
        private static final String[] latticeTranslationData = new String[]{"\u0000", "unknown", "", "P", "primitive", "", "I", "body-centered", " 1n", "R", "rhombohedral", " 1r 1r", "F", "face-centered", " 1ab 1bc 1ac", "A", "A-centered", " 1bc", "B", "B-centered", " 1ac", "C", "C-centered", " 1ab", "S", "rhombohedral(S)", " 1s 1s", "T", "rhombohedral(T)", " 1t 1t"};
        private static final int nLatticeTypes = latticeTranslationData.length / 3 - 1;
        private static HallTranslation[] hallTranslationTerms;

        protected HallTranslation(char translationCode, P3i params) {
            this.translationCode = translationCode;
            if (params != null) {
                if (params.z >= 0) {
                    this.vectorShift12ths = params;
                    return;
                }
                this.rotationOrder = params.x;
                this.rotationShift12ths = params.y;
            }
            this.vectorShift12ths = new P3i();
        }

        protected static int getLatticeIndex(char latt) {
            int i = 1;
            int ipt = 3;
            while (i <= nLatticeTypes) {
                if (latticeTranslationData[ipt].charAt(0) == latt) {
                    return i;
                }
                ++i;
                ipt += 3;
            }
            return 0;
        }

        protected static char getLatticeCode(int latt) {
            if (latt < 0) {
                latt = -latt;
            }
            return latt == 0 ? (char)'\u0000' : (latt > nLatticeTypes ? HallTranslation.getLatticeCode(HallTranslation.getLatticeIndex((char)latt)) : latticeTranslationData[latt * 3].charAt(0));
        }

        protected static String getLatticeDesignation(int latt) {
            String str;
            boolean isCentrosymmetric = latt > 0;
            String string = str = isCentrosymmetric ? "-" : "";
            if (latt < 0) {
                latt = -latt;
            }
            if (latt == 0 || latt > nLatticeTypes) {
                return "";
            }
            return str + HallTranslation.getLatticeCode(latt) + ": " + (isCentrosymmetric ? "centrosymmetric " : "") + latticeTranslationData[latt * 3 + 1];
        }

        protected static String getLatticeDesignation2(char latticeCode, boolean isCentrosymmetric) {
            int latt = HallTranslation.getLatticeIndex(latticeCode);
            if (!isCentrosymmetric) {
                latt = -latt;
            }
            return HallTranslation.getLatticeDesignation(latt);
        }

        protected static String getLatticeExtension(char latt, boolean isCentrosymmetric) {
            int i = 1;
            int ipt = 3;
            while (i <= nLatticeTypes) {
                if (latticeTranslationData[ipt].charAt(0) == latt) {
                    return latticeTranslationData[ipt + 2] + (isCentrosymmetric ? " -1" : "");
                }
                ++i;
                ipt += 3;
            }
            return "";
        }

        private static synchronized HallTranslation[] getHallTerms() {
            HallTranslation[] hallTranslationArray;
            if (hallTranslationTerms == null) {
                hallTranslationTerms = new HallTranslation[]{new HallTranslation('a', P3i.new3(6, 0, 0)), new HallTranslation('b', P3i.new3(0, 6, 0)), new HallTranslation('c', P3i.new3(0, 0, 6)), new HallTranslation('n', P3i.new3(6, 6, 6)), new HallTranslation('u', P3i.new3(3, 0, 0)), new HallTranslation('v', P3i.new3(0, 3, 0)), new HallTranslation('w', P3i.new3(0, 0, 3)), new HallTranslation('d', P3i.new3(3, 3, 3)), new HallTranslation('1', P3i.new3(2, 6, -1)), new HallTranslation('1', P3i.new3(3, 4, -1)), new HallTranslation('2', P3i.new3(3, 8, -1)), new HallTranslation('1', P3i.new3(4, 3, -1)), new HallTranslation('3', P3i.new3(4, 9, -1)), new HallTranslation('1', P3i.new3(6, 2, -1)), new HallTranslation('2', P3i.new3(6, 4, -1)), new HallTranslation('4', P3i.new3(6, 8, -1)), new HallTranslation('5', P3i.new3(6, 10, -1)), new HallTranslation('r', P3i.new3(4, 8, 8)), new HallTranslation('s', P3i.new3(8, 8, 4)), new HallTranslation('t', P3i.new3(8, 4, 8))};
                hallTranslationArray = hallTranslationTerms;
            } else {
                hallTranslationArray = hallTranslationTerms;
            }
            return hallTranslationArray;
        }

        static HallTranslation getHallTranslation(char translationCode, int order) {
            HallTranslation ht = null;
            int i = HallTranslation.getHallTerms().length;
            while (--i >= 0) {
                HallTranslation h = hallTranslationTerms[i];
                if (h.translationCode != translationCode || h.rotationOrder != 0 && h.rotationOrder != order) continue;
                ht = new HallTranslation(translationCode, null);
                ht.translationCode = translationCode;
                ht.rotationShift12ths = h.rotationShift12ths;
                ht.vectorShift12ths = h.vectorShift12ths;
                return ht;
            }
            return ht;
        }
    }

    private static final class HallRotation {
        private String rotCode;
        protected M4 seitzMatrix = new M4();
        protected M4 seitzMatrixInv = new M4();
        private static HallRotation[] hallRotationTerms;

        /*
         * Enabled aggressive block sorting
         */
        private HallRotation(String code, String matrixData) {
            this.rotCode = code;
            float[] data = new float[16];
            float[] dataInv = new float[16];
            dataInv[15] = 1.0f;
            data[15] = 1.0f;
            int i = 0;
            int ipt = 0;
            while (true) {
                block7: {
                    if (ipt >= 11) {
                        this.seitzMatrix.setA(data);
                        this.seitzMatrixInv.setA(dataInv);
                        return;
                    }
                    int value = 0;
                    switch (matrixData.charAt(i)) {
                        case ' ': {
                            ++ipt;
                            break block7;
                        }
                        case '+': 
                        case '1': {
                            value = 1;
                            break;
                        }
                        case '-': {
                            value = -1;
                        }
                    }
                    data[ipt] = value;
                    dataInv[ipt] = -value;
                    ++ipt;
                }
                ++i;
            }
        }

        protected static HallRotation lookup(String code) {
            int i = HallRotation.getHallTerms().length;
            while (--i >= 0) {
                if (!HallRotation.hallRotationTerms[i].rotCode.equals(code)) continue;
                return hallRotationTerms[i];
            }
            return null;
        }

        private static synchronized HallRotation[] getHallTerms() {
            HallRotation[] hallRotationArray;
            if (hallRotationTerms == null) {
                hallRotationTerms = new HallRotation[]{new HallRotation("1_", "+00 0+0 00+"), new HallRotation("2x", "+00 0-0 00-"), new HallRotation("2y", "-00 0+0 00-"), new HallRotation("2z", "-00 0-0 00+"), new HallRotation("2'", "0-0 -00 00-"), new HallRotation("2\"", "0+0 +00 00-"), new HallRotation("2x'", "-00 00- 0-0"), new HallRotation("2x\"", "-00 00+ 0+0"), new HallRotation("2y'", "00- 0-0 -00"), new HallRotation("2y\"", "00+ 0-0 +00"), new HallRotation("2z'", "0-0 -00 00-"), new HallRotation("2z\"", "0+0 +00 00-"), new HallRotation("3x", "+00 00- 0+-"), new HallRotation("3y", "-0+ 0+0 -00"), new HallRotation("3z", "0-0 +-0 00+"), new HallRotation("3*", "00+ +00 0+0"), new HallRotation("4x", "+00 00- 0+0"), new HallRotation("4y", "00+ 0+0 -00"), new HallRotation("4z", "0-0 +00 00+"), new HallRotation("6x", "+00 0+- 0+0"), new HallRotation("6y", "00+ 0+0 -0+"), new HallRotation("6z", "+-0 +00 00+")};
                hallRotationArray = hallRotationTerms;
            } else {
                hallRotationArray = hallRotationTerms;
            }
            return hallRotationArray;
        }
    }

    public static interface HallReceiver {
        public int getMatrixOperationCount();

        public M4 getMatrixOperation(int var1);

        public boolean addHallOperationCheckDuplicates(M4 var1);
    }
}

