import { Connection, Diagnostic } from "vscode-languageserver";
import { TextDocument } from "vscode-languageserver-textdocument";
import { WorkspaceFolderContext } from "./workspaceManager";
/**
 * Acts as an interface to ansible-playbook command.
 */
export declare class AnsiblePlaybook {
    private connection;
    private context;
    private useProgressTracker;
    /**
     *
     * @param connection - establishes connection with the client
     * @param context - provides workspace context of the client
     */
    constructor(connection: Connection, context: WorkspaceFolderContext);
    /**
     * Acts as an interface to ansible-playbook <file> --syntax-check command and a cache of its output.
     * ansible syntax-check may provide diagnostics for more than just the file for which
     * it was triggered, and this is reflected in the implementation.
     *
     * Perform ansible syntax-check for the given document.
     */
    doValidate(textDocument: TextDocument): Promise<Map<string, Diagnostic[]>>;
    private processReport;
}
