/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import net.sf.mpxj.Duration;
import net.sf.mpxj.EventManager;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.Relation;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Task;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.mpp.DocumentInputStreamFactory;
import net.sf.mpxj.mpp.FixedData;
import net.sf.mpxj.mpp.FixedMeta;
import net.sf.mpxj.mpp.MPPUtility;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;

public class ConstraintFactory {
    public void process(DirectoryEntry projectDir, ProjectFile file, DocumentInputStreamFactory inputStreamFactory) throws IOException {
        DirectoryEntry consDir;
        try {
            consDir = (DirectoryEntry)projectDir.getEntry("TBkndCons");
        }
        catch (FileNotFoundException ex) {
            consDir = null;
        }
        if (consDir != null) {
            FixedMeta consFixedMeta = new FixedMeta((InputStream)new DocumentInputStream((DocumentEntry)consDir.getEntry("FixedMeta")), 10);
            FixedData consFixedData = new FixedData(consFixedMeta, 20, inputStreamFactory.getInstance(consDir, "FixedData"));
            int count = consFixedMeta.getAdjustedItemCount();
            int lastConstraintID = -1;
            ProjectProperties properties = file.getProjectProperties();
            EventManager eventManager = file.getEventManager();
            boolean project15 = NumberHelper.getInt(properties.getMppFileType()) == 14 && NumberHelper.getInt(properties.getApplicationVersion()) > 14;
            int durationUnitsOffset = project15 ? 18 : 14;
            int durationOffset = project15 ? 14 : 16;
            for (int loop = 0; loop < count; ++loop) {
                int taskID2;
                int constraintID;
                byte[] data;
                int index;
                byte[] metaData = consFixedMeta.getByteArrayValue(loop);
                if (MPPUtility.getShort(metaData, 0) != 0 || (index = consFixedData.getIndexFromOffset(MPPUtility.getInt(metaData, 4))) == -1 || (data = consFixedData.getByteArrayValue(index)).length < 14 || (constraintID = MPPUtility.getInt(data, 0)) <= lastConstraintID) continue;
                lastConstraintID = constraintID;
                int taskID1 = MPPUtility.getInt(data, 4);
                if (taskID1 == (taskID2 = MPPUtility.getInt(data, 8))) continue;
                Task task1 = file.getTaskByUniqueID(taskID1);
                Task task2 = file.getTaskByUniqueID(taskID2);
                if (task1 == null || task2 == null) continue;
                RelationType type = RelationType.getInstance(MPPUtility.getShort(data, 12));
                TimeUnit durationUnits = MPPUtility.getDurationTimeUnits(MPPUtility.getShort(data, durationUnitsOffset));
                Duration lag = MPPUtility.getAdjustedDuration(properties, MPPUtility.getInt(data, durationOffset), durationUnits);
                Relation relation = task2.addPredecessor(task1, type, lag);
                relation.setUniqueID(constraintID);
                eventManager.fireRelationReadEvent(relation);
            }
        }
    }
}

