<?php
/*************************************************************************************
 * roff.php
 * ---------------------------------
 * Author: Artur Iwicki (iwicki DOT artur AT svgames DOT pl)
 * Copyright: (c) 2017 Artur Iwicki
 * Release Version: 1.0.9.1
 * Date Started: 2017-11-17
 *
 * roff (Unix man page) language file for GeSHi.
 *
 * CHANGES
 * -------
 * 2018-12-06 (1.0.1)
 *  - Fix reqex for line-start requests (must start with [.'], not [\.'])
 *  - Add some missing whitespace escapes
 * 2017-11-20 (1.0.0)
 *  - First Release
 *
 *************************************************************************************
 *
 *     This file is part of GeSHi.
 *
 *   GeSHi is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   GeSHi is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with GeSHi; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 ************************************************************************************/

$language_data = array (
    'LANG_NAME' => 'roff',
    'COMMENT_SINGLE' => array(
        1 => '\\"',
        2 => '\\#',
        ),
    'COMMENT_MULTI' => array(),
    'COMMENT_REGEXP' => array(
        1 => '/^\\.\\\\"[[:print:]]*/m'
        ),
    'QUOTEMARKS' => array(),
    'ESCAPE_CHAR' => '',
    'CASE_KEYWORDS' => GESHI_CAPS_NO_CHANGE,
    'CASE_SENSITIVE' => array(
        GESHI_COMMENTS => false,
        ),
    'KEYWORDS' => array(
        ),
    'SYMBOLS' => array(
        0 => array(
            '\\[-D]',    '\\(-D',
            '\\[Sd]',    '\\(Sd',
            '\\[TP]',    '\\(TP',
            '\\[Tp]',    '\\(Tp',
            '\\[ss]',    '\\(ss',
            '\\[ff]',    '\\(ff',
            '\\[fi]',    '\\(fi',
            '\\[fl]',    '\\(fl',
            '\\[Fi]',    '\\(Fi',
            '\\[Fl]',    '\\(Fl',
            '\\[/L]',    '\\(/L',
            '\\[/l]',    '\\(/l',
            '\\[/O]',    '\\(/O',
            '\\[/o]',    '\\(/o',
            '\\[AE]',    '\\(AE',
            '\\[ae]',    '\\(ae',
            '\\[OE]',    '\\(OE',
            '\\[oe]',    '\\(oe',
            '\\[IJ]',    '\\(IJ',
            '\\[ij]',    '\\(ij',
            '\\[.i]',    '\\(.i',
            '\\[.j]',    '\\(.j',
            '\\[\'A]',    '\\(\'A',
            '\\[\'C]',    '\\(\'C',
            '\\[\'E]',    '\\(\'E',
            '\\[\'I]',    '\\(\'I',
            '\\[\'O]',    '\\(\'O',
            '\\[\'U]',    '\\(\'U',
            '\\[\'Y]',    '\\(\'Y',
            '\\[\'a]',    '\\(\'a',
            '\\[\'c]',    '\\(\'c',
            '\\[\'e]',    '\\(\'e',
            '\\[\'i]',    '\\(\'i',
            '\\[\'o]',    '\\(\'o',
            '\\[\'u]',    '\\(\'u',
            '\\[\'y]',    '\\(\'y',
            '\\[:A]',    '\\(:A',
            '\\[:E]',    '\\(:E',
            '\\[:I]',    '\\(:I',
            '\\[:O]',    '\\(:O',
            '\\[:U]',    '\\(:U',
            '\\[:Y]',    '\\(:Y',
            '\\[:a]',    '\\(:a',
            '\\[:e]',    '\\(:e',
            '\\[:i]',    '\\(:i',
            '\\[:o]',    '\\(:o',
            '\\[:u]',    '\\(:u',
            '\\[:y]',    '\\(:y',
            '\\[^A]',    '\\(^A',
            '\\[^E]',    '\\(^E',
            '\\[^I]',    '\\(^I',
            '\\[^O]',    '\\(^O',
            '\\[^U]',    '\\(^U',
            '\\[^a]',    '\\(^a',
            '\\[^e]',    '\\(^e',
            '\\[^i]',    '\\(^i',
            '\\[^o]',    '\\(^o',
            '\\[^u]',    '\\(^u',
            '\\[`A]',    '\\(`A',
            '\\[`E]',    '\\(`E',
            '\\[`I]',    '\\(`I',
            '\\[`O]',    '\\(`O',
            '\\[`U]',    '\\(`U',
            '\\[`a]',    '\\(`a',
            '\\[`e]',    '\\(`e',
            '\\[`i]',    '\\(`i',
            '\\[`o]',    '\\(`o',
            '\\[`u]',    '\\(`u',
            '\\[~A]',    '\\(~A',
            '\\[~N]',    '\\(~N',
            '\\[~O]',    '\\(~O',
            '\\[~a]',    '\\(~a',
            '\\[~n]',    '\\(~n',
            '\\[~o]',    '\\(~o',
            '\\[vS]',    '\\(vS',
            '\\[vs]',    '\\(vs',
            '\\[vZ]',    '\\(vZ',
            '\\[vz]',    '\\(vz',
            '\\[,C]',    '\\(,C',
            '\\[,c]',    '\\(,c',
            '\\[oA]',    '\\(oA',
            '\\[oa]',    '\\(oa',
            '\\[a"]',    '\\(a"',
            '\\[a-]',    '\\(a-',
            '\\[a.]',    '\\(a.',
            '\\[a^]',    '\\(a^',
            '\\[aa]',    '\\(aa',
            '\\[ga]',    '\\(ga',
            '\\[ab]',    '\\(ab',
            '\\[ac]',    '\\(ac',
            '\\[ad]',    '\\(ad',
            '\\[ah]',    '\\(ah',
            '\\[ao]',    '\\(ao',
            '\\[a~]',    '\\(a~',
            '\\[ho]',    '\\(ho',
            '\\[ha]',    '\\(ha',
            '\\[ti]',    '\\(ti',
            '\\[Bq]',    '\\(Bq',
            '\\[bq]',    '\\(bq',
            '\\[lq]',    '\\(lq',
            '\\[rq]',    '\\(rq',
            '\\[oq]',    '\\(oq',
            '\\[cq]',    '\\(cq',
            '\\[aq]',    '\\(aq',
            '\\[dq]',    '\\(dq',
            '\\[Fo]',    '\\(Fo',
            '\\[Fc]',    '\\(Fc',
            '\\[fo]',    '\\(fo',
            '\\[fc]',    '\\(fc',
            '\\[r!]',    '\\(r!',
            '\\[r?]',    '\\(r?',
            '\\[em]',    '\\(em',
            '\\[en]',    '\\(en',
            '\\[hy]',    '\\(hy',
            '\\[lB]',    '\\(lB',
            '\\[rB]',    '\\(rB',
            '\\[lC]',    '\\(lC',
            '\\[rC]',    '\\(rC',
            '\\[la]',    '\\(la',
            '\\[ra]',    '\\(ra',
            '\\[bv]',    '\\(bv',
            '\\[braceex]',
            '\\[bracketlefttp]',
            '\\[bracketleftbt]',
            '\\[bracketleftex]',
            '\\[bracketrighttp]',
            '\\[bracketrightbt]',
            '\\[bracketrightex]',
            '\\[lt]',    '\\(lt',
            '\\[bracelefttp]',
            '\\[lk]',    '\\(lk',
            '\\[braceleftmid]',
            '\\[lb]',    '\\(lb',
            '\\[braceleftbt]',
            '\\[braceleftex]',
            '\\[rt]',    '\\(rt',
            '\\[bracerighttp]',
            '\\[rk]',    '\\(rk',
            '\\[bracerightmid]',
            '\\[rb]',    '\\(rb',
            '\\[bracerightbt]',
            '\\[bracerightex]',
            '\\[parenlefttp]',
            '\\[parenleftbt]',
            '\\[parenleftex]',
            '\\[parenrighttp]',
            '\\[parenrightbt]',
            '\\[parenrightex]',
            '\\[&lt;-]',    '\\(&lt;-',
            '\\[-&gt;]',    '\\(-&gt;',
            '\\[&lt;&gt;]',    '\\(&lt;&gt;',
            '\\[da]',    '\\(da',
            '\\[ua]',    '\\(ua',
            '\\[va]',    '\\(va',
            '\\[lA]',    '\\(lA',
            '\\[rA]',    '\\(rA',
            '\\[hA]',    '\\(hA',
            '\\[dA]',    '\\(dA',
            '\\[uA]',    '\\(uA',
            '\\[vA]',    '\\(vA',
            '\\[an]',    '\\(an',
            '\\[ba]',    '\\(ba',
            '\\[br]',    '\\(br',
            '\\[ul]',    '\\(ul',
            '\\[rn]',    '\\(rn',
            '\\[ru]',    '\\(ru',
            '\\[bb]',    '\\(bb',
            '\\[sl]',    '\\(sl',
            '\\[rs]',    '\\(rs',
            '\\[ci]',    '\\(ci',
            '\\[bu]',    '\\(bu',
            '\\[dd]',    '\\(dd',
            '\\[dg]',    '\\(dg',
            '\\[lz]',    '\\(lz',
            '\\[sq]',    '\\(sq',
            '\\[ps]',    '\\(ps',
            '\\[sc]',    '\\(sc',
            '\\[lh]',    '\\(lh',
            '\\[rh]',    '\\(rh',
            '\\[at]',    '\\(at',
            '\\[sh]',    '\\(sh',
            '\\[CR]',    '\\(CR',
            '\\[OK]',    '\\(OK',
            '\\[co]',    '\\(co',
            '\\[rg]',    '\\(rg',
            '\\[tm]',    '\\(tm',
            '\\[bs]',    '\\(bs',
            '\\[Do]',    '\\(Do',
            '\\[ct]',    '\\(ct',
            '\\[eu]',    '\\(eu',
            '\\[Eu]',    '\\(Eu',
            '\\[Ye]',    '\\(Ye',
            '\\[Po]',    '\\(Po',
            '\\[Cs]',    '\\(Cs',
            '\\[Fn]',    '\\(Fn',
            '\\[de]',    '\\(de',
            '\\[%0]',    '\\(%0',
            '\\[fm]',    '\\(fm',
            '\\[sd]',    '\\(sd',
            '\\[mc]',    '\\(mc',
            '\\[Of]',    '\\(Of',
            '\\[Om]',    '\\(Om',
            '\\[AN]',    '\\(AN',
            '\\[OR]',    '\\(OR',
            '\\[no]',    '\\(no',
            '\\[tno]',
            '\\[te]',    '\\(te',
            '\\[fa]',    '\\(fa',
            '\\[st]',    '\\(st',
            '\\[3d]',    '\\(3d',
            '\\[tf]',    '\\(tf',
            '\\[or]',    '\\(or',
            '\\[12]',    '\\(12',
            '\\[14]',    '\\(14',
            '\\[34]',    '\\(34',
            '\\[18]',    '\\(18',
            '\\[38]',    '\\(38',
            '\\[58]',    '\\(58',
            '\\[78]',    '\\(78',
            '\\[S1]',    '\\(S1',
            '\\[S2]',    '\\(S2',
            '\\[S3]',    '\\(S3',
            '\\[pl]',    '\\(pl',
            '\\[mi]',    '\\(mi',
            '\\[-+]',    '\\(-+',
            '\\[+-]',    '\\(+-',
            '\\[t+-]',
            '\\[pc]',    '\\(pc',
            '\\[md]',    '\\(md',
            '\\[mu]',    '\\(mu',
            '\\[tmu]',
            '\\[c*]',    '\\(c*',
            '\\[c+]',    '\\(c+',
            '\\[di]',    '\\(di',
            '\\[tdi]',
            '\\[f/]',    '\\(f/',
            '\\[**]',    '\\(**',
            '\\[&lt;=]',    '\\(&lt;=',
            '\\[&gt;=]',    '\\(&gt;=',
            '\\[&lt;&lt;]',    '\\(&lt;&lt;',
            '\\[&gt;&gt;]',    '\\(&gt;&gt;',
            '\\[eq]',    '\\(eq',
            '\\[!=]',    '\\(!=',
            '\\[==]',    '\\(==',
            '\\[ne]',    '\\(ne',
            '\\[=~]',    '\\(=~',
            '\\[|=]',    '\\(|=',
            '\\[ap]',    '\\(ap',
            '\\[~~]',    '\\(~~',
            '\\[~=]',    '\\(~=',
            '\\[pt]',    '\\(pt',
            '\\[es]',    '\\(es',
            '\\[mo]',    '\\(mo',
            '\\[nm]',    '\\(nm',
            '\\[sb]',    '\\(sb',
            '\\[nb]',    '\\(nb',
            '\\[sp]',    '\\(sp',
            '\\[nc]',    '\\(nc',
            '\\[ib]',    '\\(ib',
            '\\[ip]',    '\\(ip',
            '\\[ca]',    '\\(ca',
            '\\[cu]',    '\\(cu',
            '\\[/_]',    '\\(/_',
            '\\[pp]',    '\\(pp',
            '\\[is]',    '\\(is',
            '\\[integral]',
            '\\[sum]',
            '\\[product]',
            '\\[coproduct]',
            '\\[gr]',    '\\(gr',
            '\\[sr]',    '\\(sr',
            '\\[sqrt]',
            '\\[radicalex]',
            '\\[sqrtex]',
            '\\[lc]',    '\\(lc',
            '\\[rc]',    '\\(rc',
            '\\[lf]',    '\\(lf',
            '\\[rf]',    '\\(rf',
            '\\[if]',    '\\(if',
            '\\[Ah]',    '\\(Ah',
            '\\[Im]',    '\\(Im',
            '\\[Re]',    '\\(Re',
            '\\[wp]',    '\\(wp',
            '\\[pd]',    '\\(pd',
            '\\[-h]',    '\\(-h',
            '\\[hbar]',
            '\\[*A]',    '\\(*A',
            '\\[*B]',    '\\(*B',
            '\\[*G]',    '\\(*G',
            '\\[*D]',    '\\(*D',
            '\\[*E]',    '\\(*E',
            '\\[*Z]',    '\\(*Z',
            '\\[*Y]',    '\\(*Y',
            '\\[*H]',    '\\(*H',
            '\\[*I]',    '\\(*I',
            '\\[*K]',    '\\(*K',
            '\\[*L]',    '\\(*L',
            '\\[*M]',    '\\(*M',
            '\\[*N]',    '\\(*N',
            '\\[*C]',    '\\(*C',
            '\\[*O]',    '\\(*O',
            '\\[*P]',    '\\(*P',
            '\\[*R]',    '\\(*R',
            '\\[*S]',    '\\(*S',
            '\\[*T]',    '\\(*T',
            '\\[*U]',    '\\(*U',
            '\\[*F]',    '\\(*F',
            '\\[*X]',    '\\(*X',
            '\\[*Q]',    '\\(*Q',
            '\\[*W]',    '\\(*W',
            '\\[*a]',    '\\(*a',
            '\\[*b]',    '\\(*b',
            '\\[*g]',    '\\(*g',
            '\\[*d]',    '\\(*d',
            '\\[*e]',    '\\(*e',
            '\\[*z]',    '\\(*z',
            '\\[*y]',    '\\(*y',
            '\\[*h]',    '\\(*h',
            '\\[*i]',    '\\(*i',
            '\\[*k]',    '\\(*k',
            '\\[*l]',    '\\(*l',
            '\\[*m]',    '\\(*m',
            '\\[*n]',    '\\(*n',
            '\\[*c]',    '\\(*c',
            '\\[*o]',    '\\(*o',
            '\\[*p]',    '\\(*p',
            '\\[*r]',    '\\(*r',
            '\\[ts]',    '\\(ts',
            '\\[*s]',    '\\(*s',
            '\\[*t]',    '\\(*t',
            '\\[*u]',    '\\(*u',
            '\\[*f]',    '\\(*f',
            '\\[*x]',    '\\(*x',
            '\\[*q]',    '\\(*q',
            '\\[*w]',    '\\(*w',
            '\\[+h]',    '\\(+h',
            '\\[+f]',    '\\(+f',
            '\\[+p]',    '\\(+p',
            '\\[+e]',    '\\(+e',
            '\\[CL]',    '\\(CL',
            '\\[SP]',    '\\(SP',
            '\\[HE]',    '\\(HE',
            '\\[DI]',    '\\(DI',
            ),
        1 => array(
            // Special characters
            '\\\\', '\\´', '\\`', '\\-',
            '\\_',  '\\.', '\\%', '\\!',
            '\\0',  '\\|', '\\^', '\\&',
            '\\)',  '\\/', '\\,', '\\~',
            '\\:',  '\\{', '\\}', '\\a',
            '\\c',  '\\d', '\\e', '\\E',
            '\\p',  '\\r', '\\t', '\\u',

            // Whitespace escapes
            '\\ ', '\\h', "\\\n",

            // Text modifiers
            '\\fB', '\\fI', '\\fR', '\\fP',
            '\\f0', '\\f1', '\\f2', '\\f3', '\\f4', '\\f5', '\\f6', '\\f7', '\\f8', '\\f9',
            ),
        ),
    'STYLES' => array(
        'KEYWORDS' => array(
            ),
        'COMMENTS' => array(
            1 => 'color: #ffff55;',
            2 => 'color: #ffff55;',
            ),
        'ESCAPE_CHAR' => array(
            ),
        'BRACKETS' => array(
            ),
        'STRINGS' => array(
            ),
        'NUMBERS' => array(
            ),
        'METHODS' => array(
            ),
        'SYMBOLS' => array(
            0 => 'color: #00aaaa',
            1 => 'color: #aa00aa',
            ),
        'REGEXPS' => array(
            0 => 'color: #ffff55;',
            1 => 'font-weight: bold;',
            2 => 'font-style: italic;',
            3 => 'font-weight: bold;',
            4 => 'font-style: italic;',
            5 => 'color: #55aaff;',
            ),
        'SCRIPT' => array(
            )
        ),
    'REGEXPS' => array(
        0 => array(
            // Unicode characters
            GESHI_SEARCH => '\\\\\\[u([[:xdigit:]]{4,5})\\]',
            GESHI_REPLACE => '\\\\[\\1]',
            GESHI_MODIFIERS => '',
            GESHI_BEFORE => '',
            GESHI_AFTER => '',
            ),
        1 => array(
            // Bold text - formatted using .B or 'B
            GESHI_SEARCH => "^([\\.']{1}B[[:blank:]]*\\n{0,1})([[:print:]]+)",
            GESHI_REPLACE => '\\2',
            GESHI_MODIFIERS => 'm',
            GESHI_BEFORE => '\\1',
            GESHI_AFTER => '',
            ),
        2 => array(
            // Italic text - formatted using .I or 'I
            GESHI_SEARCH => "^([\\.']{1}I[[:blank:]]*\\n{0,1})([[:print:]]+)",
            GESHI_REPLACE => '\\2',
            GESHI_MODIFIERS => 'm',
            GESHI_BEFORE => '\\1',
            GESHI_AFTER => '',
            ),
        3 => array(
            // Bold text - formatted inline
            GESHI_SEARCH => '(\\\\fB)([[:print:]]+?)(\\\\fR)',
            GESHI_REPLACE => '\\2',
            GESHI_MODIFIERS => '',
            GESHI_BEFORE => '\\1',
            GESHI_AFTER => '\\3',
            ),
        4 => array (
            // Italic text - formatted inline
            GESHI_SEARCH => '(\\\\fI)([[:print:]]+?)(\\\\fR)',
            GESHI_REPLACE => '\\2',
            GESHI_MODIFIERS => '',
            GESHI_BEFORE => '\\1',
            GESHI_AFTER => '\\3',
            ),
        5 => array(
            // Line start macros (.TP, .SH, et cetera)
            GESHI_SEARCH => "^([.']{1}[a-zA-Z]+)",
            GESHI_REPLACE => '\\1',
            GESHI_MODIFIERS => 'm',
            GESHI_BEFORE => '',
            GESHI_AFTER => '',
            ),
        ),
    'URLS' => array(),
    'OOLANG' => false,
    'OBJECT_SPLITTERS' => array(),
    'HIGHLIGHT_STRICT_BLOCK' => array(),
    'STRICT_MODE_APPLIES' => GESHI_NEVER,
    'SCRIPT_DELIMITERS' => array(),
);
