/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.parser;

import io.sf.carte.doc.style.css.impl.CSSUtil;
import io.sf.carte.doc.style.css.nsac.AttributeCondition;
import io.sf.carte.doc.style.css.nsac.CSSException;
import io.sf.carte.doc.style.css.nsac.CombinatorSelector;
import io.sf.carte.doc.style.css.nsac.Condition;
import io.sf.carte.doc.style.css.nsac.ElementSelector;
import io.sf.carte.doc.style.css.nsac.NamespacePrefixMap;
import io.sf.carte.doc.style.css.nsac.Parser;
import io.sf.carte.doc.style.css.nsac.Selector;
import io.sf.carte.doc.style.css.nsac.SelectorList;
import io.sf.carte.doc.style.css.nsac.SimpleSelector;
import io.sf.carte.doc.style.css.parser.AbstractCondition;
import io.sf.carte.doc.style.css.parser.AbstractSelector;
import io.sf.carte.doc.style.css.parser.ConditionalSelectorImpl;
import io.sf.carte.doc.style.css.parser.MutableBoolean;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.carte.doc.style.css.parser.ScopeSelector;
import io.sf.carte.doc.style.css.parser.SelectorArgumentConditionImpl;
import io.sf.carte.doc.style.css.parser.SelectorListImpl;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

class NSACSelectorFactory
implements Parser.NamespaceMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final ElementSelector universalSelector = new AnyNodeSelector();
    private NamespacePrefixMap nsPrefixMap = null;

    NSACSelectorFactory() {
    }

    NSACSelectorFactory(NamespacePrefixMap nsPrefixMap) {
        this.nsPrefixMap = nsPrefixMap;
    }

    NamespacePrefixMap getNamespacePrefixMap() {
        if (this.nsPrefixMap == null) {
            this.nsPrefixMap = this.createNamespacePrefixMap();
        }
        return this.nsPrefixMap;
    }

    private NSACNamespacePrefixMap createNamespacePrefixMap() {
        return new NSACNamespacePrefixMap();
    }

    @Override
    public String getNamespaceURI(String nsPrefix) {
        return this.nsPrefixMap != null ? this.nsPrefixMap.getNamespaceURI(nsPrefix) : null;
    }

    String getNamespacePrefix(String namespaceUri) {
        return this.nsPrefixMap != null ? this.nsPrefixMap.getNamespacePrefix(namespaceUri) : null;
    }

    void registerNamespacePrefix(String prefix, String uri) {
        this.getNamespacePrefixMap().registerNamespacePrefix(prefix, uri);
    }

    ElementSelector getUniversalSelector(String namespacePrefix) {
        if (namespacePrefix == null) {
            return universalSelector;
        }
        return this.createUniversalSelector(this.getNamespaceURI(namespacePrefix));
    }

    static ElementSelector getUniversalSelector() {
        return universalSelector;
    }

    ElementSelector createUniversalSelector(String namespaceUri) {
        return new UniversalSelector(namespaceUri);
    }

    ElementSelectorImpl createElementSelector() {
        return new ElementSelectorImpl();
    }

    CombinatorSelectorImpl createCombinatorSelector(Selector.SelectorType type, Selector firstSelector) {
        if (firstSelector == null) {
            firstSelector = NSACSelectorFactory.getUniversalSelector();
        }
        return new CombinatorSelectorImpl(type, firstSelector);
    }

    ConditionalSelectorImpl createConditionalSelector(SimpleSelector selector, AbstractCondition condition) throws CSSException {
        if (selector == null) {
            selector = NSACSelectorFactory.getUniversalSelector();
        }
        return new ConditionalSelectorImpl(selector, condition){
            private static final long serialVersionUID = 1L;

            @Override
            NSACSelectorFactory getSelectorFactory() throws IllegalStateException {
                return NSACSelectorFactory.this;
            }
        };
    }

    AbstractSelector createScopeSelector() {
        return new ScopeSelector();
    }

    AttributeConditionImpl createAttributeCondition(Condition.ConditionType type) {
        return new AttributeConditionImpl(type);
    }

    static String escapeName(String name) {
        return name != null ? ParseHelper.escape(name, false, false) : "";
    }

    private static class NSACNamespacePrefixMap
    implements NamespacePrefixMap {
        private HashMap<String, String> mapNsPrefix2Uri = new HashMap();

        private NSACNamespacePrefixMap() {
        }

        @Override
        public String getNamespaceURI(String nsPrefix) {
            return this.mapNsPrefix2Uri.get(nsPrefix);
        }

        @Override
        public String getNamespacePrefix(String namespaceUri) {
            for (Map.Entry<String, String> me : this.mapNsPrefix2Uri.entrySet()) {
                if (!namespaceUri.equals(me.getValue())) continue;
                return me.getKey();
            }
            return null;
        }

        @Override
        public boolean hasDefaultNamespace() {
            return this.mapNsPrefix2Uri.containsKey("");
        }

        @Override
        public void registerNamespacePrefix(String prefix, String uri) {
            this.mapNsPrefix2Uri.put(prefix, uri);
        }
    }

    private class UniversalSelector
    extends ElementSelectorImpl {
        private static final long serialVersionUID = 1L;

        private UniversalSelector(String namespaceUri) {
            this.namespaceUri = namespaceUri;
        }

        @Override
        public Selector.SelectorType getSelectorType() {
            return Selector.SelectorType.UNIVERSAL;
        }

        @Override
        public String getLocalName() {
            return "*";
        }

        @Override
        public String toString() {
            if (this.namespaceUri == null) {
                return "*";
            }
            String pre = NSACSelectorFactory.this.nsPrefixMap == null ? "" : NSACSelectorFactory.this.nsPrefixMap.getNamespacePrefix(this.namespaceUri);
            return pre + "|*";
        }
    }

    class ElementSelectorImpl
    extends NamespaceAwareSelector
    implements ElementSelector {
        private static final long serialVersionUID = 1L;
        String namespaceUri;
        String localName;

        private ElementSelectorImpl() {
            this.namespaceUri = null;
            this.localName = null;
        }

        void setNamespaceUri(String namespaceUri) {
            this.namespaceUri = namespaceUri;
        }

        void setLocalName(String localName) {
            this.localName = localName;
        }

        @Override
        public Selector.SelectorType getSelectorType() {
            return Selector.SelectorType.ELEMENT;
        }

        @Override
        public String getNamespaceURI() {
            return this.namespaceUri;
        }

        @Override
        public String getLocalName() {
            return this.localName;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.getLocalName() == null ? 0 : this.getLocalName().hashCode());
            result = 31 * result + (this.namespaceUri == null ? 0 : this.namespaceUri.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (!(obj instanceof ElementSelector)) {
                return false;
            }
            ElementSelector other = (ElementSelector)obj;
            if (this.getLocalName() == null ? other.getLocalName() != null : !this.getLocalName().equals(other.getLocalName())) {
                return false;
            }
            return !(this.getNamespaceURI() == null ? other.getNamespaceURI() != null : !this.getNamespaceURI().equals(other.getNamespaceURI()));
        }

        public String toString() {
            String lName = this.getLocalName();
            if (lName != null) {
                lName = NSACSelectorFactory.escapeName(lName);
            }
            if (this.namespaceUri != null) {
                if (this.namespaceUri.length() != 0) {
                    String nspre = NSACSelectorFactory.this.getNamespacePrefix(this.namespaceUri);
                    if (nspre != null && !nspre.isEmpty()) {
                        return nspre + "|" + lName;
                    }
                } else {
                    return "|" + lName;
                }
            }
            return lName;
        }

        @Override
        public ElementSelectorImpl clone() {
            ElementSelectorImpl clon = (ElementSelectorImpl)super.clone();
            clon.localName = this.localName;
            clon.namespaceUri = this.namespaceUri;
            return clon;
        }
    }

    class CombinatorSelectorImpl
    extends NamespaceAwareSelector
    implements CombinatorSelector {
        private static final long serialVersionUID = 1L;
        private Selector.SelectorType type;
        SimpleSelector simpleSelector;
        Selector selector;

        private CombinatorSelectorImpl(Selector.SelectorType type, Selector selector) {
            this.simpleSelector = null;
            this.type = type;
            this.selector = selector;
        }

        @Override
        public Selector.SelectorType getSelectorType() {
            return this.type;
        }

        void setSelectorType(Selector.SelectorType newType) {
            this.type = newType;
        }

        @Override
        public Selector getSelector() {
            return this.selector;
        }

        @Override
        public SimpleSelector getSecondSelector() {
            return this.simpleSelector;
        }

        @Override
        boolean isSimpleSelector() {
            return false;
        }

        @Override
        ConditionalSelectorImpl withCondition(NSACSelectorFactory factory, AbstractCondition condition) {
            throw new IllegalStateException("Not a simple selector.");
        }

        @Override
        AbstractSelector descendant(SelectorList base) {
            CombinatorSelectorImpl clon = this.clone();
            clon.selector = ((AbstractSelector)this.selector).descendant(base);
            return clon;
        }

        @Override
        Selector replace(SelectorList base, MutableBoolean replaced) {
            CombinatorSelectorImpl clon = this.clone();
            clon.selector = ((AbstractSelector)clon.selector).replace(base, replaced);
            AbstractSelector replSel = (AbstractSelector)((AbstractSelector)((Object)clon.simpleSelector)).replace(base, replaced);
            if (replSel.isSimpleSelector()) {
                clon.simpleSelector = (SimpleSelector)((Object)replSel);
                return clon;
            }
            CombinatorSelectorImpl replComb = (CombinatorSelectorImpl)replSel;
            CombinatorSelectorImpl comb = this.getSelectorFactory().createCombinatorSelector(replSel.getSelectorType(), clon);
            if (((AbstractSelector)replComb.selector).isSimpleSelector()) {
                clon.simpleSelector = (SimpleSelector)replComb.selector;
            } else {
                NSACSelectorFactory factory = this.getSelectorFactory();
                SelectorArgumentConditionImpl is = new SelectorArgumentConditionImpl();
                SelectorListImpl selist = new SelectorListImpl();
                selist.add(replComb.selector);
                is.arguments = selist;
                is.setName("is");
                clon.simpleSelector = factory.createConditionalSelector(NSACSelectorFactory.getUniversalSelector(), is);
            }
            comb.simpleSelector = replComb.simpleSelector;
            return comb;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.selector == null ? 0 : this.selector.hashCode());
            result = 31 * result + (this.simpleSelector == null ? 0 : this.simpleSelector.hashCode());
            result = 31 * result + this.type.hashCode();
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CombinatorSelectorImpl other = (CombinatorSelectorImpl)obj;
            if (this.selector == null ? other.selector != null : !this.selector.equals(other.selector)) {
                return false;
            }
            if (this.simpleSelector == null ? other.simpleSelector != null : !this.simpleSelector.equals(other.simpleSelector)) {
                return false;
            }
            return this.type == other.type;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append(this.selector.toString());
            switch (this.type) {
                case DIRECT_ADJACENT: {
                    buf.append('+');
                    break;
                }
                case SUBSEQUENT_SIBLING: {
                    buf.append('~');
                    break;
                }
                case CHILD: {
                    buf.append('>');
                    break;
                }
                case DESCENDANT: {
                    if (this.selector.getSelectorType() != Selector.SelectorType.SCOPE_MARKER) {
                        buf.append(' ');
                        break;
                    }
                    buf.append(">>");
                    break;
                }
                case COLUMN_COMBINATOR: {
                    buf.append("||");
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown type: " + (Object)((Object)this.type));
                }
            }
            if (this.simpleSelector != null) {
                buf.append(this.simpleSelector.toString());
            } else {
                buf.append('?');
            }
            return buf.toString();
        }

        @Override
        public CombinatorSelectorImpl clone() {
            CombinatorSelectorImpl clon = (CombinatorSelectorImpl)super.clone();
            clon.simpleSelector = this.simpleSelector;
            clon.selector = this.selector;
            clon.type = this.type;
            return clon;
        }
    }

    class AttributeConditionImpl
    extends AbstractCondition
    implements AttributeCondition {
        private static final long serialVersionUID = 1L;
        Condition.ConditionType type;
        private String namespaceURI = null;
        private String localName = null;
        private String value = null;
        private AttributeCondition.Flag flag = null;

        private AttributeConditionImpl(Condition.ConditionType type) {
            this.type = type;
        }

        @Override
        public Condition.ConditionType getConditionType() {
            return this.type;
        }

        @Override
        public String getNamespaceURI() {
            return this.namespaceURI;
        }

        void setNamespaceURI(String namespaceURI) {
            this.namespaceURI = namespaceURI;
        }

        @Override
        public String getLocalName() {
            return this.localName;
        }

        void setLocalName(String localName) {
            this.localName = localName;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        void setValue(String value) {
            this.value = value;
        }

        @Override
        public boolean hasFlag(AttributeCondition.Flag flag) {
            return this.flag == flag;
        }

        @Override
        public boolean hasFlag() {
            return this.flag != null;
        }

        void setFlag(AttributeCondition.Flag flag) {
            this.flag = flag;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.flag == null ? 0 : this.flag.hashCode());
            result = 31 * result + (this.localName == null ? 0 : this.localName.hashCode());
            result = 31 * result + (this.namespaceURI == null ? 0 : this.namespaceURI.hashCode());
            result = 31 * result + this.type.hashCode();
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AttributeConditionImpl other = (AttributeConditionImpl)obj;
            if (this.flag != other.flag) {
                return false;
            }
            if (this.localName == null ? other.localName != null : !this.localName.equals(other.localName)) {
                return false;
            }
            if (this.namespaceURI == null ? other.namespaceURI != null : !this.namespaceURI.equals(other.namespaceURI)) {
                return false;
            }
            if (this.type != other.type) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }

        @Override
        void serialize(StringBuilder buf) {
            Condition.ConditionType condtype = this.getConditionType();
            switch (condtype) {
                case ATTRIBUTE: {
                    buf.append('[');
                    this.appendEscapedQName(buf);
                    if (this.value != null) {
                        buf.append('=');
                        this.appendAttributeValue(buf);
                    }
                    buf.append(']');
                    break;
                }
                case BEGIN_HYPHEN_ATTRIBUTE: {
                    buf.append('[');
                    this.appendEscapedQName(buf);
                    buf.append('|').append('=');
                    this.appendAttributeValue(buf);
                    buf.append(']');
                    break;
                }
                case ONE_OF_ATTRIBUTE: {
                    buf.append('[');
                    this.appendEscapedQName(buf);
                    buf.append('~').append('=');
                    this.appendAttributeValue(buf);
                    buf.append(']');
                    break;
                }
                case BEGINS_ATTRIBUTE: {
                    buf.append('[');
                    this.appendEscapedQName(buf);
                    buf.append('^').append('=');
                    this.appendAttributeValue(buf);
                    buf.append(']');
                    break;
                }
                case ENDS_ATTRIBUTE: {
                    buf.append('[');
                    this.appendEscapedQName(buf);
                    buf.append('$').append('=');
                    this.appendAttributeValue(buf);
                    buf.append(']');
                    break;
                }
                case SUBSTRING_ATTRIBUTE: {
                    buf.append('[');
                    this.appendEscapedQName(buf);
                    buf.append('*').append('=');
                    this.appendAttributeValue(buf);
                    buf.append(']');
                    break;
                }
                case CLASS: {
                    buf.append('.').append(this.getEscapedValue());
                    break;
                }
                case ID: {
                    buf.append('#').append(this.getEscapedValue());
                    break;
                }
                case ONLY_CHILD: {
                    buf.append(":only-child");
                    break;
                }
                case ONLY_TYPE: {
                    buf.append(":only-of-type");
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown type: " + (Object)((Object)condtype));
                }
            }
        }

        private void appendAttributeValue(StringBuilder buf) {
            if (this.flag == null && !this.value.isEmpty() && CSSUtil.isValidIdentifier(this.value)) {
                buf.append(this.value);
            } else {
                buf.append('\"').append(this.getControlEscapedValue()).append('\"');
                if (this.flag == AttributeCondition.Flag.CASE_I) {
                    buf.append(' ').append('i');
                } else if (this.flag == AttributeCondition.Flag.CASE_S) {
                    buf.append(' ').append('s');
                }
            }
        }

        private void appendEscapedQName(StringBuilder buf) {
            if (this.namespaceURI != null) {
                if (this.namespaceURI.length() != 0) {
                    String nspre = NSACSelectorFactory.this.getNamespacePrefix(this.namespaceURI);
                    if (nspre != null && nspre.length() != 0) {
                        buf.append(nspre).append("|");
                    }
                } else {
                    buf.append("|");
                }
            }
            if (this.localName != null) {
                buf.append(NSACSelectorFactory.escapeName(this.localName));
            }
        }

        private String getEscapedValue() {
            return this.value != null ? ParseHelper.escape(this.value, false, false) : "";
        }

        private String getControlEscapedValue() {
            return this.value != null ? ParseHelper.escapeControl(ParseHelper.escapeBackslash(this.value)) : "";
        }

        @Override
        public AttributeConditionImpl clone() {
            AttributeConditionImpl clon = (AttributeConditionImpl)super.clone();
            clon.flag = this.flag;
            clon.type = this.type;
            clon.localName = this.localName;
            clon.namespaceURI = this.namespaceURI;
            clon.value = this.value;
            return clon;
        }
    }

    private static class AnyNodeSelector
    extends AbstractSelector
    implements ElementSelector {
        private static final long serialVersionUID = 1L;

        private AnyNodeSelector() {
        }

        @Override
        public Selector.SelectorType getSelectorType() {
            return Selector.SelectorType.UNIVERSAL;
        }

        @Override
        public String getLocalName() {
            return "*";
        }

        @Override
        public String getNamespaceURI() {
            return null;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + "*".hashCode();
            return result;
        }

        public String toString() {
            return "*";
        }

        @Override
        public AbstractSelector clone() {
            return this;
        }

        @Override
        NSACSelectorFactory getSelectorFactory() {
            throw new IllegalStateException();
        }
    }

    abstract class NamespaceAwareSelector
    extends AbstractSelector {
        private static final long serialVersionUID = 1L;

        NamespaceAwareSelector() {
        }

        @Override
        boolean setNamespacePrefixMap(NamespacePrefixMap map) {
            NSACSelectorFactory.this.nsPrefixMap = map;
            return true;
        }

        @Override
        NSACSelectorFactory getSelectorFactory() {
            return NSACSelectorFactory.this;
        }
    }
}

