/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import com.typesafe.scalalogging.Logger;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientRequestQuotaManager;
import kafka.server.ControllerMutationQuotaManager;
import kafka.server.KafkaConfig;
import kafka.server.QuotaFactory;
import kafka.utils.Logging;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.loader.LoaderManifest;
import org.apache.kafka.image.publisher.MetadataPublisher;
import org.apache.kafka.metadata.MetadataCache;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.quota.ClientQuotaCallback;
import scala.Function0;
import scala.Option;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005a4AAC\u0006\u0001%!AA\u0006\u0001B\u0001B\u0003%Q\u0006\u0003\u00059\u0001\t\u0005\t\u0015!\u0003:\u0011!i\u0004A!A!\u0002\u0013q\u0004\u0002C#\u0001\u0005\u0003\u0005\u000b\u0011B\u0017\t\u0011\u0019\u0003!\u0011!Q\u0001\n\u001dCQA\u0015\u0001\u0005\u0002MCQa\u0017\u0001\u0005BqCQ!\u0018\u0001\u0005ByCQ!\u0018\u0001\u0005\u0002U\u0014\u0011\u0005R=oC6L7\rV8qS\u000e\u001cE.^:uKJ\fVo\u001c;b!V\u0014G.[:iKJT!\u0001D\u0007\u0002\u00115,G/\u00193bi\u0006T!AD\b\u0002\rM,'O^3s\u0015\u0005\u0001\u0012!B6bM.\f7\u0001A\n\u0005\u0001MIr\u0004\u0005\u0002\u0015/5\tQCC\u0001\u0017\u0003\u0015\u00198-\u00197b\u0013\tARC\u0001\u0004B]f\u0014VM\u001a\t\u00035ui\u0011a\u0007\u0006\u00039=\tQ!\u001e;jYNL!AH\u000e\u0003\u000f1{wmZ5oOB\u0011\u0001EK\u0007\u0002C)\u0011!eI\u0001\naV\u0014G.[:iKJT!\u0001J\u0013\u0002\u000b%l\u0017mZ3\u000b\u0005A1#BA\u0014)\u0003\u0019\t\u0007/Y2iK*\t\u0011&A\u0002pe\u001eL!aK\u0011\u0003#5+G/\u00193bi\u0006\u0004VO\u00197jg\",'/A\u0005dYV\u001cH/\u001a:JIB\u0011a&\u000e\b\u0003_M\u0002\"\u0001M\u000b\u000e\u0003ER!AM\t\u0002\rq\u0012xn\u001c;?\u0013\t!T#\u0001\u0004Qe\u0016$WMZ\u0005\u0003m]\u0012aa\u0015;sS:<'B\u0001\u001b\u0016\u0003\u0011\u0019wN\u001c4\u0011\u0005iZT\"A\u0007\n\u0005qj!aC&bM.\f7i\u001c8gS\u001e\fABZ1vYRD\u0015M\u001c3mKJ\u0004\"aP\"\u000e\u0003\u0001S!!\u0011\"\u0002\u000b\u0019\fW\u000f\u001c;\u000b\u00059)\u0013B\u0001#A\u000511\u0015-\u001e7u\u0011\u0006tG\r\\3s\u0003!qw\u000eZ3UsB,\u0017!D9v_R\fW*\u00198bO\u0016\u00148\u000f\u0005\u0002I\u001f:\u0011\u0011*\u0014\b\u0003\u00152s!\u0001M&\n\u0003AI!AD\b\n\u00059k\u0011\u0001D)v_R\fg)Y2u_JL\u0018B\u0001)R\u00055\tVo\u001c;b\u001b\u0006t\u0017mZ3sg*\u0011a*D\u0001\u0007y%t\u0017\u000e\u001e \u0015\rQ3v\u000bW-[!\t)\u0006!D\u0001\f\u0011\u0015ac\u00011\u0001.\u0011\u0015Ad\u00011\u0001:\u0011\u0015id\u00011\u0001?\u0011\u0015)e\u00011\u0001.\u0011\u00151e\u00011\u0001H\u0003\u0011q\u0017-\\3\u0015\u00035\n\u0001c\u001c8NKR\fG-\u0019;b+B$\u0017\r^3\u0015\t}\u0013\u0007.\u001c\t\u0003)\u0001L!!Y\u000b\u0003\tUs\u0017\u000e\u001e\u0005\u0006G\"\u0001\r\u0001Z\u0001\u0006I\u0016dG/\u0019\t\u0003K\u001al\u0011aI\u0005\u0003O\u000e\u0012Q\"T3uC\u0012\fG/\u0019#fYR\f\u0007\"B5\t\u0001\u0004Q\u0017\u0001\u00038fo&k\u0017mZ3\u0011\u0005\u0015\\\u0017B\u00017$\u00055iU\r^1eCR\f\u0017*\\1hK\")a\u000e\u0003a\u0001_\u0006AQ.\u00198jM\u0016\u001cH\u000f\u0005\u0002qg6\t\u0011O\u0003\u0002sG\u00051An\\1eKJL!\u0001^9\u0003\u001d1{\u0017\rZ3s\u001b\u0006t\u0017NZ3tiR\u0019qL^<\t\u000b\rL\u0001\u0019\u00013\t\u000b%L\u0001\u0019\u00016")
public class DynamicTopicClusterQuotaPublisher
implements Logging,
MetadataPublisher {
    private final String clusterId;
    private final KafkaConfig conf;
    private final FaultHandler faultHandler;
    private final String nodeType;
    private final QuotaFactory.QuotaManagers quotaManagers;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public void onControllerChange(LeaderAndEpoch x$1) {
        super.onControllerChange(x$1);
    }

    public void close() throws Exception {
        super.close();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String name() {
        return "DynamicTopicClusterQuotaPublisher " + this.nodeType + " id=" + this.conf.nodeId();
    }

    public void onMetadataUpdate(MetadataDelta delta, MetadataImage newImage, LoaderManifest manifest) {
        this.onMetadataUpdate(delta, newImage);
    }

    public void onMetadataUpdate(MetadataDelta delta, MetadataImage newImage) {
        try {
            this.quotaManagers.clientQuotaCallbackPlugin().ifPresent(plugin -> {
                if (delta.topicsDelta() != null || delta.clusterDelta() != null) {
                    Cluster cluster = MetadataCache.toCluster((String)$this.clusterId, (MetadataImage)newImage);
                    if (((ClientQuotaCallback)plugin.get()).updateClusterMetadata(cluster)) {
                        ClientQuotaManager qual$1 = $this.quotaManagers.fetch();
                        Option<ClientQuotaManager.KafkaQuotaEntity> x$1 = qual$1.updateQuotaMetricConfigs$default$1();
                        qual$1.updateQuotaMetricConfigs(x$1);
                        ClientQuotaManager qual$2 = $this.quotaManagers.produce();
                        Option<ClientQuotaManager.KafkaQuotaEntity> x$2 = qual$2.updateQuotaMetricConfigs$default$1();
                        qual$2.updateQuotaMetricConfigs(x$2);
                        ClientRequestQuotaManager qual$3 = $this.quotaManagers.request();
                        Option<ClientQuotaManager.KafkaQuotaEntity> x$3 = qual$3.updateQuotaMetricConfigs$default$1();
                        qual$3.updateQuotaMetricConfigs(x$3);
                        ControllerMutationQuotaManager qual$4 = $this.quotaManagers.controllerMutation();
                        Option<ClientQuotaManager.KafkaQuotaEntity> x$4 = qual$4.updateQuotaMetricConfigs$default$1();
                        qual$4.updateQuotaMetricConfigs(x$4);
                        return;
                    }
                    return;
                }
            });
            return;
        }
        catch (Throwable t) {
            String deltaName = "MetadataDelta up to " + newImage.highestOffsetAndEpoch().offset();
            this.faultHandler.handleFault("Uncaught exception while publishing dynamic topic or cluster changes from " + deltaName, t);
            return;
        }
    }

    public DynamicTopicClusterQuotaPublisher(String clusterId, KafkaConfig conf, FaultHandler faultHandler, String nodeType, QuotaFactory.QuotaManagers quotaManagers) {
        this.clusterId = clusterId;
        this.conf = conf;
        this.faultHandler = faultHandler;
        this.nodeType = nodeType;
        this.quotaManagers = quotaManagers;
        this.logIdent_$eq("[" + this.name() + "] ");
    }
}

