/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.transform.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonpatch.JsonPatch;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import io.swagger.transform.migrate.SwaggerMigrator;
import io.swagger.transform.util.SwaggerMigrationException;
import io.swagger.transform.util.SwaggerMigrators;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class MutableJsonTree {
    private JsonNode baseNode;
    private JsonNode currentNode;
    private JsonPointer currentPointer = JsonPointer.empty();

    public MutableJsonTree(JsonNode node) {
        Objects.requireNonNull(node, "node must not be null");
        this.currentNode = this.baseNode = node.deepCopy();
    }

    public void setPointer(JsonPointer pointer) {
        Objects.requireNonNull(pointer, "pointer must not be null");
        this.doSetPointer(pointer);
    }

    public void appendPointer(JsonPointer pointer) {
        Objects.requireNonNull(pointer, "pointer must not be null");
        this.doSetPointer(this.currentPointer.append(pointer));
    }

    private void doSetPointer(JsonPointer pointer) {
        this.currentPointer = pointer;
        this.currentNode = this.currentPointer.path(this.baseNode);
        Preconditions.checkArgument(!this.currentNode.isMissingNode(), "base node has no element at pointer " + this.currentPointer);
    }

    public JsonNode getBaseNode() {
        return this.baseNode;
    }

    public JsonNode getCurrentNode() {
        return this.currentNode;
    }

    public void applyPatch(JsonPatch patch) throws SwaggerMigrationException {
        this.applyMigrator(SwaggerMigrators.fromPatch(patch));
    }

    public void applyMigrator(SwaggerMigrator migrator) throws SwaggerMigrationException {
        JsonPointer parent = this.currentPointer.parent();
        if (!parent.get(this.baseNode).isObject()) {
            throw new SwaggerMigrationException();
        }
        ObjectNode parentNode = (ObjectNode)parent.get(this.baseNode);
        JsonNode patched = migrator.migrate(this.currentNode);
        if (this.currentPointer.isEmpty()) {
            this.baseNode = this.currentNode = patched;
            return;
        }
        String memberName = Iterables.getLast(this.currentPointer).getToken().getRaw();
        parentNode.put(memberName, patched);
    }

    public void applyMigratorToElements(SwaggerMigrator migrator) throws SwaggerMigrationException {
        if (!this.currentNode.isArray()) {
            throw new SwaggerMigrationException();
        }
        ArrayNode array = (ArrayNode)this.currentNode;
        ArrayNode transformed = array.arrayNode();
        for (JsonNode element : array) {
            transformed.add(migrator.migrate(element));
        }
        array.removeAll().addAll(transformed);
    }

    public void applyPatchToElements(JsonPatch patch) throws SwaggerMigrationException {
        this.applyMigratorToElements(SwaggerMigrators.fromPatch(patch));
    }

    public String toString() {
        return "current pointer: " + this.currentPointer;
    }
}

