/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event;

import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.eventbus.api.bus.CancellableEventBus;
import net.minecraftforge.eventbus.api.event.MutableEvent;
import net.minecraftforge.eventbus.api.event.characteristic.Cancellable;
import org.jetbrains.annotations.ApiStatus;

public final class ServerChatEvent
extends MutableEvent
implements Cancellable {
    public static final CancellableEventBus<ServerChatEvent> BUS = CancellableEventBus.create(ServerChatEvent.class);
    private final ServerPlayer player;
    private final String username;
    private final String rawText;
    private Component message;

    @ApiStatus.Internal
    public ServerChatEvent(ServerPlayer player, String rawText, Component message) {
        this.player = player;
        this.username = player.getGameProfile().getName();
        this.rawText = rawText;
        this.message = message;
    }

    public ServerPlayer getPlayer() {
        return this.player;
    }

    public String getUsername() {
        return this.username;
    }

    public String getRawText() {
        return this.rawText;
    }

    public void setMessage(Component message) {
        this.message = Objects.requireNonNull(message);
    }

    public Component getMessage() {
        return this.message;
    }
}

