/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.eventbus.api.bus.EventBus;
import net.minecraftforge.eventbus.api.event.InheritableEvent;
import net.minecraftforge.eventbus.api.event.MutableEvent;
import org.jspecify.annotations.NullMarked;

@NullMarked
public abstract class AttachCapabilitiesEvent
extends MutableEvent
implements InheritableEvent {
    private final Object obj;
    private final Map<ResourceLocation, ICapabilityProvider> caps = new LinkedHashMap<ResourceLocation, ICapabilityProvider>();
    private final Map<ResourceLocation, ICapabilityProvider> view = Collections.unmodifiableMap(this.caps);
    private final List<Runnable> listeners = new ArrayList<Runnable>();
    private final List<Runnable> listenersView = Collections.unmodifiableList(this.listeners);

    protected AttachCapabilitiesEvent(Object obj) {
        this.obj = obj;
    }

    public Object getObject() {
        return this.obj;
    }

    public void addCapability(ResourceLocation key, ICapabilityProvider cap) {
        if (this.caps.containsKey(key)) {
            throw new IllegalStateException("Duplicate Capability Key: " + String.valueOf(key) + " " + String.valueOf(cap));
        }
        this.caps.put(key, cap);
    }

    public Map<ResourceLocation, ICapabilityProvider> getCapabilities() {
        return this.view;
    }

    public void addListener(Runnable listener) {
        this.listeners.add(listener);
    }

    public List<Runnable> getListeners() {
        return this.listenersView;
    }

    public static class LevelChunks
    extends AttachCapabilitiesEvent {
        public static final EventBus<LevelChunks> BUS = EventBus.create(LevelChunks.class);

        public LevelChunks(LevelChunk obj) {
            super(obj);
        }

        public LevelChunk getObject() {
            return (LevelChunk)super.getObject();
        }
    }

    public static class Levels
    extends AttachCapabilitiesEvent {
        public static final EventBus<Levels> BUS = EventBus.create(Levels.class);

        public Levels(Level obj) {
            super(obj);
        }

        public Level getObject() {
            return (Level)super.getObject();
        }
    }

    public static class ItemStacks
    extends AttachCapabilitiesEvent {
        public static final EventBus<ItemStacks> BUS = EventBus.create(ItemStacks.class);

        public ItemStacks(ItemStack obj) {
            super(obj);
        }

        public ItemStack getObject() {
            return (ItemStack)super.getObject();
        }
    }

    public static class BlockEntities
    extends AttachCapabilitiesEvent {
        public static final EventBus<BlockEntities> BUS = EventBus.create(BlockEntities.class);

        public BlockEntities(BlockEntity obj) {
            super(obj);
        }

        public BlockEntity getObject() {
            return (BlockEntity)super.getObject();
        }
    }

    public static class Entities
    extends AttachCapabilitiesEvent {
        public static final EventBus<Entities> BUS = EventBus.create(Entities.class);

        public Entities(Entity obj) {
            super(obj);
        }

        public Entity getObject() {
            return (Entity)super.getObject();
        }
    }
}

