// Code generated by mdatagen. DO NOT EDIT.

package metadata

import (
	"go.opentelemetry.io/collector/confmap"
)

// ResourceAttributeConfig provides common config for a particular resource attribute.
type ResourceAttributeConfig struct {
	Enabled bool `mapstructure:"enabled"`

	enabledSetByUser bool
}

func (rac *ResourceAttributeConfig) Unmarshal(parser *confmap.Conf) error {
	if parser == nil {
		return nil
	}
	err := parser.Unmarshal(rac)
	if err != nil {
		return err
	}
	rac.enabledSetByUser = parser.IsSet("enabled")
	return nil
}

// ResourceAttributesConfig provides config for resourcedetectionprocessor/ecs resource attributes.
type ResourceAttributesConfig struct {
	AwsEcsClusterArn      ResourceAttributeConfig `mapstructure:"aws.ecs.cluster.arn"`
	AwsEcsLaunchtype      ResourceAttributeConfig `mapstructure:"aws.ecs.launchtype"`
	AwsEcsTaskArn         ResourceAttributeConfig `mapstructure:"aws.ecs.task.arn"`
	AwsEcsTaskFamily      ResourceAttributeConfig `mapstructure:"aws.ecs.task.family"`
	AwsEcsTaskID          ResourceAttributeConfig `mapstructure:"aws.ecs.task.id"`
	AwsEcsTaskRevision    ResourceAttributeConfig `mapstructure:"aws.ecs.task.revision"`
	AwsLogGroupArns       ResourceAttributeConfig `mapstructure:"aws.log.group.arns"`
	AwsLogGroupNames      ResourceAttributeConfig `mapstructure:"aws.log.group.names"`
	AwsLogStreamArns      ResourceAttributeConfig `mapstructure:"aws.log.stream.arns"`
	AwsLogStreamNames     ResourceAttributeConfig `mapstructure:"aws.log.stream.names"`
	CloudAccountID        ResourceAttributeConfig `mapstructure:"cloud.account.id"`
	CloudAvailabilityZone ResourceAttributeConfig `mapstructure:"cloud.availability_zone"`
	CloudPlatform         ResourceAttributeConfig `mapstructure:"cloud.platform"`
	CloudProvider         ResourceAttributeConfig `mapstructure:"cloud.provider"`
	CloudRegion           ResourceAttributeConfig `mapstructure:"cloud.region"`
}

func DefaultResourceAttributesConfig() ResourceAttributesConfig {
	return ResourceAttributesConfig{
		AwsEcsClusterArn: ResourceAttributeConfig{
			Enabled: true,
		},
		AwsEcsLaunchtype: ResourceAttributeConfig{
			Enabled: true,
		},
		AwsEcsTaskArn: ResourceAttributeConfig{
			Enabled: true,
		},
		AwsEcsTaskFamily: ResourceAttributeConfig{
			Enabled: true,
		},
		AwsEcsTaskID: ResourceAttributeConfig{
			Enabled: true,
		},
		AwsEcsTaskRevision: ResourceAttributeConfig{
			Enabled: true,
		},
		AwsLogGroupArns: ResourceAttributeConfig{
			Enabled: true,
		},
		AwsLogGroupNames: ResourceAttributeConfig{
			Enabled: true,
		},
		AwsLogStreamArns: ResourceAttributeConfig{
			Enabled: true,
		},
		AwsLogStreamNames: ResourceAttributeConfig{
			Enabled: true,
		},
		CloudAccountID: ResourceAttributeConfig{
			Enabled: true,
		},
		CloudAvailabilityZone: ResourceAttributeConfig{
			Enabled: true,
		},
		CloudPlatform: ResourceAttributeConfig{
			Enabled: true,
		},
		CloudProvider: ResourceAttributeConfig{
			Enabled: true,
		},
		CloudRegion: ResourceAttributeConfig{
			Enabled: true,
		},
	}
}
