// Code generated by mdatagen. DO NOT EDIT.

package metadata

import (
	"go.opentelemetry.io/collector/confmap"
)

// ResourceAttributeConfig provides common config for a particular resource attribute.
type ResourceAttributeConfig struct {
	Enabled bool `mapstructure:"enabled"`

	enabledSetByUser bool
}

func (rac *ResourceAttributeConfig) Unmarshal(parser *confmap.Conf) error {
	if parser == nil {
		return nil
	}
	err := parser.Unmarshal(rac)
	if err != nil {
		return err
	}
	rac.enabledSetByUser = parser.IsSet("enabled")
	return nil
}

// ResourceAttributesConfig provides config for resourcedetectionprocessor/eks resource attributes.
type ResourceAttributesConfig struct {
	CloudAccountID        ResourceAttributeConfig `mapstructure:"cloud.account.id"`
	CloudAvailabilityZone ResourceAttributeConfig `mapstructure:"cloud.availability_zone"`
	CloudPlatform         ResourceAttributeConfig `mapstructure:"cloud.platform"`
	CloudProvider         ResourceAttributeConfig `mapstructure:"cloud.provider"`
	CloudRegion           ResourceAttributeConfig `mapstructure:"cloud.region"`
	HostID                ResourceAttributeConfig `mapstructure:"host.id"`
	HostImageID           ResourceAttributeConfig `mapstructure:"host.image.id"`
	HostName              ResourceAttributeConfig `mapstructure:"host.name"`
	HostType              ResourceAttributeConfig `mapstructure:"host.type"`
	K8sClusterName        ResourceAttributeConfig `mapstructure:"k8s.cluster.name"`
}

func DefaultResourceAttributesConfig() ResourceAttributesConfig {
	return ResourceAttributesConfig{
		CloudAccountID: ResourceAttributeConfig{
			Enabled: false,
		},
		CloudAvailabilityZone: ResourceAttributeConfig{
			Enabled: false,
		},
		CloudPlatform: ResourceAttributeConfig{
			Enabled: true,
		},
		CloudProvider: ResourceAttributeConfig{
			Enabled: true,
		},
		CloudRegion: ResourceAttributeConfig{
			Enabled: false,
		},
		HostID: ResourceAttributeConfig{
			Enabled: false,
		},
		HostImageID: ResourceAttributeConfig{
			Enabled: false,
		},
		HostName: ResourceAttributeConfig{
			Enabled: false,
		},
		HostType: ResourceAttributeConfig{
			Enabled: false,
		},
		K8sClusterName: ResourceAttributeConfig{
			Enabled: false,
		},
	}
}
