/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.xmpp;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.jicofo.ConferenceStore;
import org.jitsi.jicofo.MediaType;
import org.jitsi.jicofo.conference.JitsiMeetConference;
import org.jitsi.jicofo.xmpp.IqProcessingResult;
import org.jitsi.jicofo.xmpp.MuteIqHandlerKt;
import org.jitsi.jicofo.xmpp.MuteRequest;
import org.jitsi.jicofo.xmpp.UtilKt;
import org.jitsi.jicofo.xmpp.muc.ChatRoom;
import org.jitsi.utils.logging2.LoggerImpl;
import org.jitsi.xmpp.extensions.jitsimeet.AbstractMuteIq;
import org.jitsi.xmpp.extensions.jitsimeet.MuteDesktopIq;
import org.jitsi.xmpp.extensions.jitsimeet.MuteIq;
import org.jitsi.xmpp.extensions.jitsimeet.MuteVideoIq;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.ErrorIQ;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaError;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.Jid;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"logger", "Lorg/jitsi/utils/logging2/LoggerImpl;", "createMuteIq", "Lorg/jitsi/xmpp/extensions/jitsimeet/AbstractMuteIq;", "mediaType", "Lorg/jitsi/jicofo/MediaType;", "handleRequest", "Lorg/jitsi/jicofo/xmpp/IqProcessingResult;", "request", "Lorg/jitsi/jicofo/xmpp/MuteRequest;", "jicofo"})
public final class MuteIqHandlerKt {
    @NotNull
    private static final LoggerImpl logger = new LoggerImpl("org.jitsi.jicofo.xmpp.MuteIqHandler");

    private static final IqProcessingResult handleRequest(MuteRequest request) {
        Jid jidToMute = request.getJidToMute();
        Boolean doMute = request.getDoMute();
        MediaType mediaType = request.getMediaType();
        if (doMute == null || jidToMute == null) {
            logger.warn((Object)("Mute request missing required fields: " + request.getIq().toXML()));
            return (IqProcessingResult)new IqProcessingResult.RejectedWithError(request.getIq(), StanzaError.Condition.bad_request);
        }
        ConferenceStore conferenceStore = request.getConferenceStore();
        EntityBareJid entityBareJid = request.getIq().getFrom().asEntityBareJidIfPossible();
        Intrinsics.checkNotNullExpressionValue((Object)entityBareJid, (String)"asEntityBareJidIfPossible(...)");
        JitsiMeetConference jitsiMeetConference = conferenceStore.getConference(entityBareJid);
        if (jitsiMeetConference == null) {
            IqProcessingResult.RejectedWithError rejectedWithError;
            IqProcessingResult.RejectedWithError it = rejectedWithError = new IqProcessingResult.RejectedWithError(request.getIq(), StanzaError.Condition.item_not_found);
            boolean bl = false;
            logger.warn((Object)("Mute request for unknown conference: " + request.getIq().toXML()));
            return (IqProcessingResult)rejectedWithError;
        }
        JitsiMeetConference conference = jitsiMeetConference;
        ChatRoom chatRoom = conference.getChatRoom();
        if (chatRoom == null) {
            IqProcessingResult.RejectedWithError rejectedWithError;
            IqProcessingResult.RejectedWithError it = rejectedWithError = new IqProcessingResult.RejectedWithError(request.getIq(), StanzaError.Condition.item_not_found);
            boolean bl = false;
            logger.warn((Object)("Mute request for conference with no chat room: " + request.getIq().toXML()));
            return (IqProcessingResult)rejectedWithError;
        }
        ChatRoom chatRoom2 = chatRoom;
        chatRoom2.queueXmppTask((Function0)new Function0<Unit>(conference, request, jidToMute, doMute, mediaType){
            final /* synthetic */ JitsiMeetConference $conference;
            final /* synthetic */ MuteRequest $request;
            final /* synthetic */ Jid $jidToMute;
            final /* synthetic */ Boolean $doMute;
            final /* synthetic */ MediaType $mediaType;
            {
                this.$conference = $conference;
                this.$request = $request;
                this.$jidToMute = $jidToMute;
                this.$doMute = $doMute;
                this.$mediaType = $mediaType;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                try {
                    switch (handleRequest.WhenMappings.$EnumSwitchMapping$0[this.$conference.handleMuteRequest(this.$request.getIq().getFrom(), this.$jidToMute, this.$doMute, this.$mediaType).ordinal()]) {
                        case 1: {
                            XMPPConnection xMPPConnection = (XMPPConnection)this.$request.getConnection();
                            IQ iQ = IQ.createResultIQ((IQ)this.$request.getIq());
                            Intrinsics.checkNotNullExpressionValue((Object)iQ, (String)"createResultIQ(...)");
                            UtilKt.tryToSendStanza((XMPPConnection)xMPPConnection, (Stanza)((Stanza)iQ));
                            if (!Intrinsics.areEqual((Object)this.$request.getIq().getFrom(), (Object)this.$request.getJidToMute())) {
                                void $this$invoke_u24lambda_u240;
                                AbstractMuteIq abstractMuteIq = MuteIqHandlerKt.createMuteIq(this.$mediaType);
                                MuteRequest muteRequest = this.$request;
                                AbstractMuteIq abstractMuteIq2 = abstractMuteIq;
                                XMPPConnection xMPPConnection2 = (XMPPConnection)this.$request.getConnection();
                                boolean bl = false;
                                $this$invoke_u24lambda_u240.setActor(muteRequest.getIq().getFrom());
                                $this$invoke_u24lambda_u240.setType(IQ.Type.set);
                                $this$invoke_u24lambda_u240.setTo(muteRequest.getJidToMute());
                                $this$invoke_u24lambda_u240.setMute(muteRequest.getDoMute());
                                UtilKt.tryToSendStanza((XMPPConnection)xMPPConnection2, (Stanza)((Stanza)abstractMuteIq));
                            }
                            break;
                        }
                        case 2: {
                            XMPPConnection xMPPConnection = (XMPPConnection)this.$request.getConnection();
                            ErrorIQ errorIQ = IQ.createErrorResponse((IQ)this.$request.getIq(), (StanzaError)StanzaError.getBuilder((StanzaError.Condition)StanzaError.Condition.not_allowed).build());
                            Intrinsics.checkNotNullExpressionValue((Object)errorIQ, (String)"createErrorResponse(...)");
                            UtilKt.tryToSendStanza((XMPPConnection)xMPPConnection, (Stanza)((Stanza)errorIQ));
                            break;
                        }
                        case 3: {
                            XMPPConnection xMPPConnection = (XMPPConnection)this.$request.getConnection();
                            ErrorIQ errorIQ = IQ.createErrorResponse((IQ)this.$request.getIq(), (StanzaError)StanzaError.getBuilder((StanzaError.Condition)StanzaError.Condition.internal_server_error).build());
                            Intrinsics.checkNotNullExpressionValue((Object)errorIQ, (String)"createErrorResponse(...)");
                            UtilKt.tryToSendStanza((XMPPConnection)xMPPConnection, (Stanza)((Stanza)errorIQ));
                        }
                    }
                }
                catch (Exception e) {
                    MuteIqHandlerKt.access$getLogger$p().warn((Object)("Failed to handle mute request: " + this.$request.getIq().toXML()), (Throwable)e);
                    XMPPConnection xMPPConnection = (XMPPConnection)this.$request.getConnection();
                    ErrorIQ errorIQ = IQ.createErrorResponse((IQ)this.$request.getIq(), (StanzaError.Condition)StanzaError.Condition.internal_server_error);
                    Intrinsics.checkNotNullExpressionValue((Object)errorIQ, (String)"createErrorResponse(...)");
                    UtilKt.tryToSendStanza((XMPPConnection)xMPPConnection, (Stanza)((Stanza)errorIQ));
                }
            }
        });
        return (IqProcessingResult)new IqProcessingResult.AcceptedWithNoResponse();
    }

    @NotNull
    public static final AbstractMuteIq createMuteIq(@NotNull MediaType mediaType) {
        AbstractMuteIq abstractMuteIq;
        Intrinsics.checkNotNullParameter((Object)mediaType, (String)"mediaType");
        switch (WhenMappings.$EnumSwitchMapping$0[mediaType.ordinal()]) {
            case 1: {
                abstractMuteIq = (AbstractMuteIq)new MuteIq();
                break;
            }
            case 2: {
                abstractMuteIq = (AbstractMuteIq)new MuteVideoIq();
                break;
            }
            case 3: {
                abstractMuteIq = (AbstractMuteIq)new MuteDesktopIq();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported media type: " + mediaType);
            }
        }
        return abstractMuteIq;
    }

    public static final /* synthetic */ IqProcessingResult access$handleRequest(MuteRequest request) {
        return MuteIqHandlerKt.handleRequest(request);
    }

    public static final /* synthetic */ LoggerImpl access$getLogger$p() {
        return logger;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MediaType.values().length];
            try {
                nArray[MediaType.AUDIO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MediaType.VIDEO.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MediaType.DESKTOP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

