/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.http.content;

import io.ktor.http.ContentType;
import io.ktor.http.content.OutgoingContent;
import io.ktor.http.content.VersionsKt;
import io.ktor.server.http.content.LastModifiedJavaTimeKt;
import io.ktor.util.cio.ByteBufferPoolKt;
import io.ktor.utils.io.ByteReadChannel;
import io.ktor.utils.io.jvm.javaio.ReadingKt;
import io.ktor.utils.io.pool.ObjectPool;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.Collection;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tB!\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\fJ\u000f\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0007\u001a\u00020\u00068\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u0013R\u001d\u0010\u001f\u001a\u0004\u0018\u00010\u001a8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\u001eR\u001b\u0010$\u001a\u00020 8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\u001c\u001a\u0004\b\"\u0010#R\u001b\u0010'\u001a\u00020%8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010\u001c\u001a\u0004\b'\u0010(R\u0016\u0010,\u001a\u0004\u0018\u00010)8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+\u00a8\u0006-"}, d2={"Lio/ktor/server/http/content/JarFileContent;", "Lio/ktor/http/content/OutgoingContent$ReadChannelContent;", "Ljava/io/File;", "jarFile", "", "resourcePath", "Lio/ktor/http/ContentType;", "contentType", "<init>", "(Ljava/io/File;Ljava/lang/String;Lio/ktor/http/ContentType;)V", "Ljava/nio/file/Path;", "zipFilePath", "(Ljava/nio/file/Path;Ljava/lang/String;Lio/ktor/http/ContentType;)V", "Lio/ktor/utils/io/ByteReadChannel;", "readFrom", "()Lio/ktor/utils/io/ByteReadChannel;", "Ljava/io/File;", "getJarFile", "()Ljava/io/File;", "Ljava/lang/String;", "getResourcePath", "()Ljava/lang/String;", "Lio/ktor/http/ContentType;", "getContentType", "()Lio/ktor/http/ContentType;", "normalized", "Ljava/util/jar/JarEntry;", "jarEntry$delegate", "Lkotlin/Lazy;", "getJarEntry", "()Ljava/util/jar/JarEntry;", "jarEntry", "Ljava/util/jar/JarFile;", "jar$delegate", "getJar", "()Ljava/util/jar/JarFile;", "jar", "", "isFile$delegate", "isFile", "()Z", "", "getContentLength", "()Ljava/lang/Long;", "contentLength", "ktor-server-core"})
@SourceDebugExtension(value={"SMAP\nJarFileContent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JarFileContent.kt\nio/ktor/server/http/content/JarFileContent\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,52:1\n1#2:53\n*E\n"})
public final class JarFileContent
extends OutgoingContent.ReadChannelContent {
    @NotNull
    private final File jarFile;
    @NotNull
    private final String resourcePath;
    @NotNull
    private final ContentType contentType;
    @NotNull
    private final String normalized;
    @NotNull
    private final Lazy jarEntry$delegate;
    @NotNull
    private final Lazy jar$delegate;
    @NotNull
    private final Lazy isFile$delegate;

    public JarFileContent(@NotNull File jarFile, @NotNull String resourcePath, @NotNull ContentType contentType) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)jarFile, (String)"jarFile");
            Intrinsics.checkNotNullParameter((Object)resourcePath, (String)"resourcePath");
            Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
            this.jarFile = jarFile;
            this.resourcePath = resourcePath;
            this.contentType = contentType;
            String string = FilesKt.normalize((File)new File(this.resourcePath)).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            this.normalized = StringsKt.replace$default((String)string, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null);
            this.jarEntry$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> JarFileContent.jarEntry_delegate$lambda$0(this));
            this.jar$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> JarFileContent.jar_delegate$lambda$1(this));
            this.isFile$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> JarFileContent.isFile_delegate$lambda$2(this));
            if (!(!StringsKt.startsWith$default((String)this.normalized, (String)"..", (boolean)false, (int)2, null))) {
                boolean bl = false;
                String string2 = "Bad resource relative path " + this.resourcePath;
                throw new IllegalArgumentException(string2.toString());
            }
            JarEntry jarEntry = this.getJarEntry();
            if (jarEntry == null) break block1;
            JarEntry it = jarEntry;
            boolean bl = false;
            OutgoingContent outgoingContent = (OutgoingContent)this;
            Collection collection = VersionsKt.getVersions((OutgoingContent)((OutgoingContent)this));
            FileTime fileTime = it.getLastModifiedTime();
            Intrinsics.checkNotNullExpressionValue((Object)fileTime, (String)"getLastModifiedTime(...)");
            VersionsKt.setVersions((OutgoingContent)outgoingContent, (List)CollectionsKt.plus((Collection)collection, (Object)LastModifiedJavaTimeKt.LastModifiedVersion(fileTime)));
        }
    }

    @NotNull
    public final File getJarFile() {
        return this.jarFile;
    }

    @NotNull
    public final String getResourcePath() {
        return this.resourcePath;
    }

    @NotNull
    public ContentType getContentType() {
        return this.contentType;
    }

    private final JarEntry getJarEntry() {
        Lazy lazy = this.jarEntry$delegate;
        return (JarEntry)lazy.getValue();
    }

    private final JarFile getJar() {
        Lazy lazy = this.jar$delegate;
        return (JarFile)lazy.getValue();
    }

    public final boolean isFile() {
        Lazy lazy = this.isFile$delegate;
        return (Boolean)lazy.getValue();
    }

    public JarFileContent(@NotNull Path zipFilePath, @NotNull String resourcePath, @NotNull ContentType contentType) {
        Intrinsics.checkNotNullParameter((Object)zipFilePath, (String)"zipFilePath");
        Intrinsics.checkNotNullParameter((Object)resourcePath, (String)"resourcePath");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        File file2 = zipFilePath.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"toFile(...)");
        this(file2, resourcePath, contentType);
    }

    @Nullable
    public Long getContentLength() {
        JarEntry jarEntry = this.getJarEntry();
        return jarEntry != null ? Long.valueOf(jarEntry.getSize()) : null;
    }

    @NotNull
    public ByteReadChannel readFrom() {
        JarEntry jarEntry = this.getJarEntry();
        if (jarEntry == null) {
            throw new IOException("Resource " + this.normalized + " not found");
        }
        JarEntry jarEntry2 = jarEntry;
        InputStream inputStream = this.getJar().getInputStream(jarEntry2);
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
        return ReadingKt.toByteReadChannel$default((InputStream)inputStream, null, (ObjectPool)ByteBufferPoolKt.getKtorDefaultPool(), (int)1, null);
    }

    private static final JarEntry jarEntry_delegate$lambda$0(JarFileContent this$0) {
        return this$0.getJar().getJarEntry(this$0.resourcePath);
    }

    private static final JarFile jar_delegate$lambda$1(JarFileContent this$0) {
        return new JarFile(this$0.jarFile);
    }

    private static final boolean isFile_delegate$lambda$2(JarFileContent this$0) {
        JarEntry jarEntry = this$0.getJarEntry();
        return jarEntry != null ? !jarEntry.isDirectory() : false;
    }
}

