/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi_modified.impl.neomedia.rtp.remotebitrateestimator;

import java.util.Arrays;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jitsi.utils.logging.DiagnosticContext;
import org.jitsi.utils.logging.TimeSeriesLogger;
import org.jitsi.utils.logging2.Logger;
import org.jitsi_modified.impl.neomedia.rtp.remotebitrateestimator.BandwidthUsage;
import org.jitsi_modified.impl.neomedia.rtp.remotebitrateestimator.OverUseDetectorOptions;

class OveruseEstimator {
    private final Logger logger;
    private final TimeSeriesLogger timeSeriesLogger;
    private static final int kDeltaCounterMax = 1000;
    private static final int kMinFramePeriodHistoryLength = 60;
    private double avgNoise;
    private final double[][] E;
    private DiagnosticContext diagnosticContext;
    private final double[] Eh = new double[2];
    private final double[] h = new double[2];
    private final double[][] IKh = new double[][]{{0.0, 0.0}, {0.0, 0.0}};
    private final double[] K = new double[2];
    private int numOfDeltas;
    private double offset;
    private double prevOffset;
    private final double[] processNoise;
    private double slope;
    private final double[] tsDeltaHist = new double[60];
    private int tsDeltaHistInsIdx;
    private double varNoise;

    private static double[][] clone(double[][] matrix) {
        int length = matrix.length;
        double[][] clone = new double[length][];
        for (int i = 0; i < length; ++i) {
            clone[i] = (double[])matrix[i].clone();
        }
        return clone;
    }

    public OveruseEstimator(OverUseDetectorOptions options, @NotNull DiagnosticContext diagnosticContext, @NotNull Logger parentLogger) {
        this.logger = parentLogger.createChildLogger(this.getClass().getName());
        this.timeSeriesLogger = TimeSeriesLogger.getTimeSeriesLogger(this.getClass());
        this.diagnosticContext = diagnosticContext;
        this.slope = options.initialSlope;
        this.prevOffset = this.offset = options.initialOffset;
        this.avgNoise = options.initialAvgNoise;
        this.varNoise = options.initialVarNoise;
        this.E = OveruseEstimator.clone(options.initialE);
        this.processNoise = (double[])options.initialProcessNoise.clone();
        Arrays.fill(this.tsDeltaHist, Double.MAX_VALUE);
    }

    public int getNumOfDeltas() {
        return this.numOfDeltas;
    }

    public double getOffset() {
        return this.offset;
    }

    public double getVarNoise() {
        return this.varNoise;
    }

    public void update(long tDelta, double tsDelta, int sizeDelta, BandwidthUsage currentHypothesis, long systemTimeMs) {
        boolean positiveSemiDefinite;
        double minFramePeriod = this.updateMinFramePeriod(tsDelta);
        double tTsDelta = (double)tDelta - tsDelta;
        ++this.numOfDeltas;
        if (this.numOfDeltas > 1000) {
            this.numOfDeltas = 1000;
        }
        double[] dArray = this.E[0];
        dArray[0] = dArray[0] + this.processNoise[0];
        double[] dArray2 = this.E[1];
        dArray2[1] = dArray2[1] + this.processNoise[1];
        if (currentHypothesis == BandwidthUsage.kBwOverusing && this.offset < this.prevOffset || currentHypothesis == BandwidthUsage.kBwUnderusing && this.offset > this.prevOffset) {
            double[] dArray3 = this.E[1];
            dArray3[1] = dArray3[1] + 10.0 * this.processNoise[1];
        }
        double[] h = this.h;
        double[] Eh = this.Eh;
        h[0] = sizeDelta;
        h[1] = 1.0;
        Eh[0] = this.E[0][0] * h[0] + this.E[0][1] * h[1];
        Eh[1] = this.E[1][0] * h[0] + this.E[1][1] * h[1];
        double residual = tTsDelta - this.slope * h[0] - this.offset;
        boolean inStableState = currentHypothesis == BandwidthUsage.kBwNormal;
        double maxResidual = 3.0 * Math.sqrt(this.varNoise);
        double residualForUpdateNoiseEstimate = Math.abs(residual) < maxResidual ? residual : (residual < 0.0 ? -maxResidual : maxResidual);
        this.updateNoiseEstimate(residualForUpdateNoiseEstimate, minFramePeriod, inStableState);
        double denom = this.varNoise + h[0] * Eh[0] + h[1] * Eh[1];
        double[] K = this.K;
        double[][] IKh = this.IKh;
        K[0] = Eh[0] / denom;
        K[1] = Eh[1] / denom;
        IKh[0][0] = 1.0 - K[0] * h[0];
        IKh[0][1] = -K[0] * h[1];
        IKh[1][0] = -K[1] * h[0];
        IKh[1][1] = 1.0 - K[1] * h[1];
        double e00 = this.E[0][0];
        double e01 = this.E[0][1];
        this.E[0][0] = e00 * IKh[0][0] + this.E[1][0] * IKh[0][1];
        this.E[0][1] = e01 * IKh[0][0] + this.E[1][1] * IKh[0][1];
        this.E[1][0] = e00 * IKh[1][0] + this.E[1][0] * IKh[1][1];
        this.E[1][1] = e01 * IKh[1][0] + this.E[1][1] * IKh[1][1];
        boolean bl = positiveSemiDefinite = this.E[0][0] + this.E[1][1] >= 0.0 && this.E[0][0] * this.E[1][1] - this.E[0][1] * this.E[1][0] >= 0.0 && this.E[0][0] >= 0.0;
        if (!positiveSemiDefinite) {
            throw new IllegalStateException("positiveSemiDefinite");
        }
        this.slope += K[0] * residual;
        this.prevOffset = this.offset;
        this.offset += K[1] * residual;
        if (this.timeSeriesLogger.isTraceEnabled()) {
            this.timeSeriesLogger.trace((Map)this.diagnosticContext.makeTimeSeriesPoint("delay_variation_estimation", systemTimeMs).addField("estimator", (Object)this.hashCode()).addField("time_delta", (Object)tDelta).addField("ts_delta", (Object)tsDelta).addField("tts_delta", (Object)tTsDelta).addField("offset", (Object)this.offset).addField("hypothesis", (Object)currentHypothesis.getValue()));
        }
    }

    private double updateMinFramePeriod(double tsDelta) {
        this.tsDeltaHist[this.tsDeltaHistInsIdx] = tsDelta;
        this.tsDeltaHistInsIdx = (this.tsDeltaHistInsIdx + 1) % this.tsDeltaHist.length;
        double min = tsDelta;
        for (double d : this.tsDeltaHist) {
            if (!(d < min)) continue;
            min = d;
        }
        return min;
    }

    private void updateNoiseEstimate(double residual, double tsDelta, boolean stableState) {
        if (!stableState) {
            return;
        }
        double alpha = 0.01;
        if (this.numOfDeltas > 300) {
            alpha = 0.002;
        }
        double beta = Math.pow(1.0 - alpha, tsDelta * 30.0 / 1000.0);
        this.avgNoise = beta * this.avgNoise + (1.0 - beta) * residual;
        this.varNoise = beta * this.varNoise + (1.0 - beta) * (this.avgNoise - residual) * (this.avgNoise - residual);
        if (this.varNoise < 1.0) {
            this.varNoise = 1.0;
        }
    }
}

