/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.jingle;

import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import org.jitsi.xmpp.extensions.jingle.ContentPacketExtension;
import org.jitsi.xmpp.extensions.jingle.JingleAction;
import org.jitsi.xmpp.extensions.jingle.ReasonPacketExtension;
import org.jitsi.xmpp.extensions.jingle.SessionInfoPacketExtension;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IQ;
import org.jxmpp.jid.Jid;

public class JingleIQ
extends IQ {
    public static final String NAMESPACE = "urn:xmpp:jingle:1";
    public static final String ELEMENT = "jingle";
    public static final String ACTION_ATTR_NAME = "action";
    public static final String INITIATOR_ATTR_NAME = "initiator";
    public static final String RESPONDER_ATTR_NAME = "responder";
    public static final String SID_ATTR_NAME = "sid";
    private JingleAction action;
    private Jid initiator;
    private Jid responder;
    private String sid;
    private ReasonPacketExtension reason;
    private SessionInfoPacketExtension sessionInfo;
    private final List<ContentPacketExtension> contentList = new ArrayList<ContentPacketExtension>();

    public JingleIQ(JingleAction action, String sid) {
        super(ELEMENT, NAMESPACE);
        this.action = action;
        this.sid = sid;
    }

    protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder bldr) {
        bldr.attribute(ACTION_ATTR_NAME, this.getAction().toString()).optAttribute(INITIATOR_ATTR_NAME, (CharSequence)this.getInitiator()).optAttribute(RESPONDER_ATTR_NAME, (CharSequence)this.getResponder()).attribute(SID_ATTR_NAME, this.getSID());
        if (this.contentList.isEmpty() && this.reason == null && this.sessionInfo == null) {
            bldr.setEmptyElement();
        } else {
            bldr.rightAngleBracket();
            for (ContentPacketExtension cpe : this.contentList) {
                bldr.append(cpe.toXML());
            }
            if (this.reason != null) {
                bldr.append(this.reason.toXML());
            }
            if (this.sessionInfo != null) {
                bldr.append(this.sessionInfo.toXML());
            }
        }
        return bldr;
    }

    public String getSID() {
        return this.sid;
    }

    public static String generateSID() {
        return new BigInteger(64, new SecureRandom()).toString(32);
    }

    public void setResponder(Jid responder) {
        this.responder = responder;
    }

    public Jid getResponder() {
        return this.responder;
    }

    public void setInitiator(Jid initiator) {
        this.initiator = initiator;
    }

    public Jid getInitiator() {
        return this.initiator;
    }

    public JingleAction getAction() {
        return this.action;
    }

    public void setReason(ReasonPacketExtension reason) {
        this.reason = reason;
    }

    public ReasonPacketExtension getReason() {
        return this.reason;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ContentPacketExtension> getContentList() {
        List<ContentPacketExtension> list = this.contentList;
        synchronized (list) {
            return new ArrayList<ContentPacketExtension>(this.contentList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContent(ContentPacketExtension contentPacket) {
        List<ContentPacketExtension> list = this.contentList;
        synchronized (list) {
            this.contentList.add(contentPacket);
        }
    }

    public boolean containsContentChildOfType(Class<? extends ExtensionElement> contentType) {
        return this.getContentForType(contentType) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContentPacketExtension getContentForType(Class<? extends ExtensionElement> contentType) {
        List<ContentPacketExtension> list = this.contentList;
        synchronized (list) {
            for (ContentPacketExtension content : this.contentList) {
                ExtensionElement child = content.getFirstChildOfType(contentType);
                if (child == null) continue;
                return content;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContentPacketExtension getContentByName(String contentName) {
        List<ContentPacketExtension> list = this.contentList;
        synchronized (list) {
            for (ContentPacketExtension content : this.contentList) {
                if (!contentName.equals(content.getName())) continue;
                return content;
            }
        }
        return null;
    }

    public void setSessionInfo(SessionInfoPacketExtension si) {
        this.sessionInfo = si;
    }

    public SessionInfoPacketExtension getSessionInfo() {
        return this.sessionInfo;
    }
}

