/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.cc.vp8;

import java.time.Instant;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.rtp.codec.vp8.Vp8Packet;
import org.jitsi.rtp.util.RtpUtils;
import org.jitsi.utils.logging.DiagnosticContext;
import org.jitsi.utils.logging.TimeSeriesLogger;
import org.jitsi.videobridge.cc.vp8.VP8Frame;

public class VP8FrameProjection {
    private static final TimeSeriesLogger timeSeriesLogger = TimeSeriesLogger.getTimeSeriesLogger(VP8FrameProjection.class);
    private final DiagnosticContext diagnosticContext;
    @Nullable
    private final Instant created;
    private final VP8Frame vp8Frame;
    private final long ssrc;
    private final long timestamp;
    private final int sequenceNumberDelta;
    private final int extendedPictureId;
    private final int tl0PICIDX;
    private int closedSeq = -1;

    VP8FrameProjection(@NotNull DiagnosticContext diagnosticContext, long ssrc, int sequenceNumberDelta, long timestamp) {
        this(diagnosticContext, null, ssrc, timestamp, sequenceNumberDelta, 0, 0, null);
    }

    VP8FrameProjection(@NotNull DiagnosticContext diagnosticContext, VP8Frame vp8Frame, long ssrc, long timestamp, int sequenceNumberDelta, int extendedPictureId, int tl0PICIDX, @Nullable Instant created) {
        this.diagnosticContext = diagnosticContext;
        this.ssrc = ssrc;
        this.timestamp = timestamp;
        this.sequenceNumberDelta = sequenceNumberDelta;
        this.extendedPictureId = extendedPictureId;
        this.tl0PICIDX = tl0PICIDX;
        this.vp8Frame = vp8Frame;
        this.created = created;
    }

    public int rewriteSeqNo(int seq) {
        return RtpUtils.applySequenceNumberDelta((int)seq, (int)this.sequenceNumberDelta);
    }

    void rewriteRtp(@NotNull Vp8Packet pkt) {
        int sequenceNumber = this.rewriteSeqNo(pkt.getSequenceNumber());
        if (timeSeriesLogger.isTraceEnabled()) {
            timeSeriesLogger.trace((Map)this.diagnosticContext.makeTimeSeriesPoint("rtp_vp8_rewrite").addField("orig.rtp.ssrc", (Object)pkt.getSsrc()).addField("orig.rtp.timestamp", (Object)pkt.getTimestamp()).addField("orig.rtp.seq", (Object)pkt.getSequenceNumber()).addField("orig.vp8.pictureid", (Object)pkt.getPictureId()).addField("orig.vp8.tl0picidx", (Object)pkt.getTL0PICIDX()).addField("proj.rtp.ssrc", (Object)this.ssrc).addField("proj.rtp.timestamp", (Object)this.timestamp).addField("proj.rtp.seq", (Object)sequenceNumber).addField("proj.vp8.pictureid", (Object)this.extendedPictureId).addField("proj.vp8.tl0picidx", (Object)this.tl0PICIDX));
        }
        pkt.setSsrc(this.ssrc);
        pkt.setTimestamp(this.timestamp);
        pkt.setSequenceNumber(sequenceNumber);
        if (pkt.getTL0PICIDX() != -1) {
            pkt.setTL0PICIDX(this.tl0PICIDX);
        }
        pkt.setPictureId(this.extendedPictureId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean accept(@NotNull Vp8Packet rtpPacket) {
        if (this.vp8Frame == null || !this.vp8Frame.matchesFrame(rtpPacket)) {
            return false;
        }
        VP8Frame vP8Frame = this.vp8Frame;
        synchronized (vP8Frame) {
            if (this.closedSeq < 0) {
                return true;
            }
            return RtpUtils.isOlderSequenceNumberThan((int)rtpPacket.getSequenceNumber(), (int)this.closedSeq);
        }
    }

    VP8Frame getVP8Frame() {
        return this.vp8Frame;
    }

    public long getSSRC() {
        return this.ssrc;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int getPictureId() {
        return this.extendedPictureId;
    }

    public int getTl0PICIDX() {
        return this.tl0PICIDX;
    }

    @Nullable
    public Instant getCreated() {
        return this.created;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getEarliestProjectedSequence() {
        if (this.vp8Frame == null) {
            return this.sequenceNumberDelta;
        }
        VP8Frame vP8Frame = this.vp8Frame;
        synchronized (vP8Frame) {
            return this.rewriteSeqNo(this.vp8Frame.getEarliestKnownSequenceNumber());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLatestProjectedSequence() {
        if (this.vp8Frame == null) {
            return this.sequenceNumberDelta;
        }
        VP8Frame vP8Frame = this.vp8Frame;
        synchronized (vP8Frame) {
            return this.rewriteSeqNo(this.vp8Frame.getLatestKnownSequenceNumber());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.vp8Frame != null) {
            VP8Frame vP8Frame = this.vp8Frame;
            synchronized (vP8Frame) {
                this.closedSeq = this.vp8Frame.getLatestKnownSequenceNumber();
            }
        }
    }
}

