/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.jsonrpc.api.call;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.tinymediamanager.jsonrpc.api.AbstractCall;
import org.tinymediamanager.jsonrpc.api.AbstractModel;

public final class JSONRPC {

    public static class Version
    extends AbstractCall<VersionResult> {
        public static final String API_TYPE = "JSONRPC.Version";

        @Override
        protected VersionResult parseOne(JsonNode jsonNode) {
            return new VersionResult(jsonNode);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }

        public static class VersionResult
        extends AbstractModel {
            public static final String MAJOR = "major";
            public static final String MINOR = "minor";
            public static final String PATCH = "patch";
            public static final HashMap<String, String> CODENAME = new HashMap();
            public final Integer major;
            public final Integer minor;
            public final Integer patch;

            public VersionResult(Integer n, Integer n2, Integer n3) {
                this.major = n;
                this.minor = n2;
                this.patch = n3;
            }

            @Override
            public String toString() {
                return this.major + "." + this.minor + "." + this.patch;
            }

            public String getKodiVersion() {
                String string = CODENAME.get(this.toString());
                if (string == null) {
                    if (this.major == 8) {
                        string = "Kodi 17 (Krypton)";
                        if (this.minor > 3) {
                            string = "Kodi 18 (Leia)";
                        }
                    }
                    if (this.major >= 9) {
                        string = "Kodi 18 (Leia)";
                    }
                    if (this.major >= 11) {
                        string = "Kodi 19 (Matrix)";
                    }
                    if (this.major >= 13) {
                        string = "Kodi 20 (Nexus)";
                    }
                    if (string == null) {
                        string = "Unknown";
                    }
                }
                return string;
            }

            public int toInt() {
                return this.patch + this.minor * 10000 + this.major * 10000000;
            }

            public VersionResult(JsonNode jsonNode) {
                this.major = jsonNode.findValue(MAJOR).asInt();
                this.minor = jsonNode.findValue(MINOR).asInt();
                this.patch = jsonNode.findValue(PATCH).asInt();
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode objectNode = OM.createObjectNode();
                objectNode.put(MAJOR, this.major);
                objectNode.put(MINOR, this.minor);
                objectNode.put(PATCH, this.patch);
                return objectNode;
            }

            static List<VersionResult> getJSONRPCVersionResultList(JsonNode jsonNode, String string) {
                if (jsonNode.has(string)) {
                    ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                    ArrayList<VersionResult> arrayList = new ArrayList<VersionResult>(arrayNode.size());
                    for (int i = 0; i < arrayNode.size(); ++i) {
                        arrayList.add(new VersionResult(arrayNode.get(i)));
                    }
                    return arrayList;
                }
                return new ArrayList<VersionResult>(0);
            }

            static {
                CODENAME.put("12.4.0", "Kodi 19.3 (Matrix)");
                CODENAME.put("12.3.0", "Kodi 19.1 (Matrix)");
                CODENAME.put("12.2.1", "Kodi 19 (Matrix)");
                CODENAME.put("10.3.0", "Kodi 18.9 (Leia)");
                CODENAME.put("10.1.2", "Kodi 18.1 (Leia)");
                CODENAME.put("10.1.1", "Kodi 18 (Leia)");
                CODENAME.put("8.3.0", "Kodi 18 (Leia)");
                CODENAME.put("8.0.0", "Kodi 17 (Krypton)");
                CODENAME.put("6.32.5", "Kodi 16.1 (Jarvis)");
                CODENAME.put("6.32.4", "Kodi 16.0 (Jarvis)");
                CODENAME.put("6.25.2", "Kodi 15 (Isengard)");
                CODENAME.put("6.21.2", "Kodi 14 (Helix)");
                CODENAME.put("6.14.3", "XBMC 13 (Gotham)");
            }
        }
    }

    public static class Ping
    extends AbstractCall<String> {
        public static final String API_TYPE = "JSONRPC.Ping";

        @Override
        protected String parseOne(JsonNode jsonNode) {
            return jsonNode.asText();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class Permission
    extends AbstractCall<PermissionResult> {
        public static final String API_TYPE = "JSONRPC.Permission";

        @Override
        protected PermissionResult parseOne(JsonNode jsonNode) {
            return new PermissionResult(jsonNode);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }

        public static class PermissionResult
        extends AbstractModel {
            public static final String CONTROLGUI = "controlgui";
            public static final String CONTROLNOTIFY = "controlnotify";
            public static final String CONTROLPLAYBACK = "controlplayback";
            public static final String CONTROLPOWER = "controlpower";
            public static final String CONTROLPVR = "controlpvr";
            public static final String CONTROLSYSTEM = "controlsystem";
            public static final String EXECUTEADDON = "executeaddon";
            public static final String MANAGEADDON = "manageaddon";
            public static final String NAVIGATE = "navigate";
            public static final String READDATA = "readdata";
            public static final String REMOVEDATA = "removedata";
            public static final String UPDATEDATA = "updatedata";
            public static final String WRITEFILE = "writefile";
            public final Boolean controlgui;
            public final Boolean controlnotify;
            public final Boolean controlplayback;
            public final Boolean controlpower;
            public final Boolean controlpvr;
            public final Boolean controlsystem;
            public final Boolean executeaddon;
            public final Boolean manageaddon;
            public final Boolean navigate;
            public final Boolean readdata;
            public final Boolean removedata;
            public final Boolean updatedata;
            public final Boolean writefile;

            public PermissionResult(Boolean bl, Boolean bl2, Boolean bl3, Boolean bl4, Boolean bl5, Boolean bl6, Boolean bl7, Boolean bl8, Boolean bl9, Boolean bl10, Boolean bl11, Boolean bl12, Boolean bl13) {
                this.controlgui = bl;
                this.controlnotify = bl2;
                this.controlplayback = bl3;
                this.controlpower = bl4;
                this.controlpvr = bl5;
                this.controlsystem = bl6;
                this.executeaddon = bl7;
                this.manageaddon = bl8;
                this.navigate = bl9;
                this.readdata = bl10;
                this.removedata = bl11;
                this.updatedata = bl12;
                this.writefile = bl13;
            }

            public PermissionResult(JsonNode jsonNode) {
                this.controlgui = jsonNode.get(CONTROLGUI).asBoolean();
                this.controlnotify = jsonNode.get(CONTROLNOTIFY).asBoolean();
                this.controlplayback = jsonNode.get(CONTROLPLAYBACK).asBoolean();
                this.controlpower = jsonNode.get(CONTROLPOWER).asBoolean();
                this.controlpvr = jsonNode.get(CONTROLPVR).asBoolean();
                this.controlsystem = jsonNode.get(CONTROLSYSTEM).asBoolean();
                this.executeaddon = jsonNode.get(EXECUTEADDON).asBoolean();
                this.manageaddon = jsonNode.get(MANAGEADDON).asBoolean();
                this.navigate = jsonNode.get(NAVIGATE).asBoolean();
                this.readdata = jsonNode.get(READDATA).asBoolean();
                this.removedata = jsonNode.get(REMOVEDATA).asBoolean();
                this.updatedata = jsonNode.get(UPDATEDATA).asBoolean();
                this.writefile = jsonNode.get(WRITEFILE).asBoolean();
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode objectNode = OM.createObjectNode();
                objectNode.put(CONTROLGUI, this.controlgui);
                objectNode.put(CONTROLNOTIFY, this.controlnotify);
                objectNode.put(CONTROLPLAYBACK, this.controlplayback);
                objectNode.put(CONTROLPOWER, this.controlpower);
                objectNode.put(CONTROLPVR, this.controlpvr);
                objectNode.put(CONTROLSYSTEM, this.controlsystem);
                objectNode.put(EXECUTEADDON, this.executeaddon);
                objectNode.put(MANAGEADDON, this.manageaddon);
                objectNode.put(NAVIGATE, this.navigate);
                objectNode.put(READDATA, this.readdata);
                objectNode.put(REMOVEDATA, this.removedata);
                objectNode.put(UPDATEDATA, this.updatedata);
                objectNode.put(WRITEFILE, this.writefile);
                return objectNode;
            }

            static List<PermissionResult> getJSONRPCPermissionResultList(JsonNode jsonNode, String string) {
                if (jsonNode.has(string)) {
                    ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                    ArrayList<PermissionResult> arrayList = new ArrayList<PermissionResult>(arrayNode.size());
                    for (int i = 0; i < arrayNode.size(); ++i) {
                        arrayList.add(new PermissionResult(arrayNode.get(i)));
                    }
                    return arrayList;
                }
                return new ArrayList<PermissionResult>(0);
            }
        }
    }

    public static class NotifyAll
    extends AbstractCall<String> {
        public static final String API_TYPE = "JSONRPC.NotifyAll";

        public NotifyAll(String string, String string2, String string3) {
            this.addParameter("sender", string);
            this.addParameter("message", string2);
            this.addParameter("data", string3);
        }

        public NotifyAll(String string, String string2) {
            this.addParameter("sender", string);
            this.addParameter("message", string2);
        }

        @Override
        protected String parseOne(JsonNode jsonNode) {
            return jsonNode.asText();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }
}

