/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.library.bluray.clipinf;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import org.tinymediamanager.library.bluray.clipinf.CLPIObject;
import org.tinymediamanager.library.bluray.clipinf.CLPIReader;
import org.tinymediamanager.library.bluray.clipinf.CLPIWriter;

public class Main {
    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 2) {
            System.out.println("Missing input and output arguments");
            Main.usage();
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        if (!string.toLowerCase().endsWith(".xml") && !string.toLowerCase().endsWith(".clpi") || !string2.toLowerCase().endsWith(".xml") && !string2.toLowerCase().endsWith(".clpi")) {
            System.out.println("Input and output can only have xml or clpi extension.");
            Main.usage();
        }
        if (!new File(string).exists()) {
            System.out.println("File " + string + " not found.");
            Main.usage();
        }
        CLPIObject cLPIObject = null;
        FileInputStream fileInputStream = new FileInputStream(string);
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(fileInputStream));
        cLPIObject = string.toLowerCase().endsWith("xml") ? new CLPIReader().readXml(dataInputStream) : new CLPIReader().readBinary(dataInputStream);
        dataInputStream.close();
        FileOutputStream fileOutputStream = new FileOutputStream(string2);
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(fileOutputStream));
        if (string2.toLowerCase().endsWith("xml")) {
            new CLPIWriter().writeXml(cLPIObject, dataOutputStream);
        } else {
            new CLPIWriter().writeBinary(cLPIObject, dataOutputStream);
        }
        dataOutputStream.close();
    }

    public static void usage() {
        System.out.println("\n\nThis is a tool to convert a CLPI file to xml format and back.\n\n");
        System.out.println("Usage:");
        System.out.println("\n" + Main.class.getName() + " Input Output \n");
        System.out.println("where Input can be one of");
        System.out.println("   location of XXXXX.clpi");
        System.out.println("   location of XXXXX.xml");
        System.out.println("and the Output can be one of");
        System.out.println("   XXXXX.clpi");
        System.out.println("   XXXXX.xml");
        System.exit(1);
    }
}

