/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.actions;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.lingala.zip4j.io.outputstream.ZipOutputStream;
import net.lingala.zip4j.model.ZipParameters;
import net.lingala.zip4j.model.enums.AesKeyStrength;
import net.lingala.zip4j.model.enums.CompressionMethod;
import net.lingala.zip4j.model.enums.EncryptionMethod;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.AbstractFileVisitor;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.TmmProperties;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.license.ZipArchiveHelper;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.actions.TmmAction;

public class ExportLogAction
extends TmmAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExportLogAction.class);
    private Movie movie;
    private TvShow show;

    public ExportLogAction() {
        this((Movie)null, (TvShow)null);
    }

    public ExportLogAction(Movie movieId, TvShow showId) {
        this.putValue("Name", TmmResourceBundle.getString("tmm.exportlogs"));
        this.putValue("ShortDescription", TmmResourceBundle.getString("tmm.exportlogs.desc"));
        this.movie = movieId;
        this.show = showId;
    }

    @Override
    protected void processAction(ActionEvent e) {
        Path file = null;
        try {
            String path = TmmProperties.getInstance().getProperty("exportlogs.path", "");
            file = TmmUIHelper.saveFile(TmmResourceBundle.getString("BugReport.savelogs"), path, "tmm_logs.zip", new FileNameExtensionFilter("Zip files", ".zip"));
            if (file != null) {
                MainWindow.getInstance().setCursor(Cursor.getPredefinedCursor(3));
                this.writeLogsFile(file.toFile());
                TmmProperties.getInstance().putProperty("exportlogs.path", file.toAbsolutePath().toString());
                MainWindow.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        catch (Exception ex) {
            LOGGER.error("Could not write logs.zip - '{}'", (Object)ex.getMessage());
            MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, (Object)(file != null ? file.toString() : ""), "message.erroropenfile", new String[]{":", ex.getLocalizedMessage()}));
        }
    }

    private void writeLogsFile(File file) throws Exception {
        ZipParameters zipParameters = this.createZipParameters();
        try (FileOutputStream os = new FileOutputStream(file);
             ZipOutputStream zos = ZipArchiveHelper.getInstance().createEncryptedZipOutputStream(os);){
            String json;
            List<Path> logs = Utils.listFiles(Paths.get(Globals.LOG_FOLDER, new String[0]));
            for (Path path : logs) {
                try {
                    InputStream in2 = Files.newInputStream(path, new OpenOption[0]);
                    try {
                        zipParameters.setFileNameInZip("logs/" + path.getFileName());
                        zos.putNextEntry(zipParameters);
                        IOUtils.copy((InputStream)in2, (OutputStream)zos);
                        zos.closeEntry();
                    }
                    finally {
                        if (in2 == null) continue;
                        in2.close();
                    }
                }
                catch (Exception e) {
                    LOGGER.debug("unable to attach {} - {}", (Object)path, (Object)e.getMessage());
                }
            }
            File[] data = new File(Globals.DATA_FOLDER).listFiles((directory, filename) -> !filename.matches(".*\\.db$") && !filename.matches(".*\\.lic$"));
            if (data != null) {
                for (File dataFile : data) {
                    try (InputStream in3 = Files.newInputStream(dataFile.toPath(), new OpenOption[0]);){
                        zipParameters.setFileNameInZip("data/" + dataFile.getName());
                        zos.putNextEntry(zipParameters);
                        IOUtils.copy((InputStream)in3, (OutputStream)zos);
                        zos.closeEntry();
                    }
                    catch (Exception e) {
                        LOGGER.debug("unable to attach {} - {}", (Object)dataFile.getName(), (Object)e.getMessage());
                    }
                }
            }
            try (InputStream inputStream = this.generateFileListing();){
                zipParameters.setFileNameInZip("install.txt");
                zos.putNextEntry(zipParameters);
                IOUtils.copy((InputStream)inputStream, (OutputStream)zos);
                zos.closeEntry();
            }
            catch (Exception exception) {
                LOGGER.debug("unable to attach install.txt - {}", (Object)exception.getMessage());
            }
            try (InputStream inputStream = this.dumpEnvironmentVariables();){
                zipParameters.setFileNameInZip("env.txt");
                zos.putNextEntry(zipParameters);
                IOUtils.copy((InputStream)inputStream, (OutputStream)zos);
                zos.closeEntry();
            }
            catch (Exception exception) {
                LOGGER.debug("unable to attach env.txt - {}", (Object)exception.getMessage());
            }
            Path path = Paths.get(Globals.CONTENT_FOLDER, "launcher-extra.yml");
            if (Files.exists(path, new LinkOption[0])) {
                try (InputStream in4 = Files.newInputStream(path, new OpenOption[0]);){
                    zipParameters.setFileNameInZip("launcher-extra.yml");
                    zos.putNextEntry(zipParameters);
                    IOUtils.copy((InputStream)in4, (OutputStream)zos);
                    zos.closeEntry();
                }
                catch (Exception e) {
                    LOGGER.debug("unable to attach {} - {}", (Object)"launcher-extra.yml", (Object)e.getMessage());
                }
            }
            if (this.movie != null && this.movie.getDbId() != null) {
                String set;
                String json2 = MovieModuleManager.getInstance().getMovieJsonFromDB(this.movie);
                if (!json2.isEmpty()) {
                    zipParameters.setFileNameInZip("movie.json");
                    zos.putNextEntry(zipParameters);
                    zos.write(json2.getBytes());
                    zos.closeEntry();
                }
                if (this.movie.getMovieSet() != null && !(set = MovieModuleManager.getInstance().getMovieSetJsonFromDB(this.movie.getMovieSet())).isEmpty()) {
                    zipParameters.setFileNameInZip("movieset.json");
                    zos.putNextEntry(zipParameters);
                    zos.write(set.getBytes());
                    zos.closeEntry();
                }
            }
            if (this.show != null && this.show.getDbId() != null && !(json = TvShowModuleManager.getInstance().getTvShowJsonFromDB(this.show, true)).isEmpty()) {
                zipParameters.setFileNameInZip("tvshow.json");
                zos.putNextEntry(zipParameters);
                zos.write(json.getBytes());
                zos.closeEntry();
            }
        }
    }

    private InputStream generateFileListing() {
        final ArrayList filesAndFolders = new ArrayList();
        Path current = Paths.get(".", new String[0]);
        try {
            Files.walkFileTree(current, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, new AbstractFileVisitor(){

                @Override
                public FileVisitResult preVisitDirectory(Path file, BasicFileAttributes attrs) throws IOException {
                    String foldername = file.getFileName().toString();
                    if ("backup".equals(foldername) || "logs".equals(foldername) || "cache".equals(foldername) || "update".equals(foldername) || "templates".equals(foldername) || ".git".equals(foldername) || ".idea".equals(foldername) || ".settings".equals(foldername)) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    filesAndFolders.add(file);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (Exception e) {
            LOGGER.debug("could not get a file listing: {}", (Object)e.getMessage());
        }
        Collections.sort(filesAndFolders);
        StringBuilder sb = new StringBuilder();
        for (Path path : filesAndFolders) {
            sb.append(current.relativize(path));
            sb.append("\t");
            sb.append(path.toFile().length());
            sb.append("\n");
        }
        return new ByteArrayInputStream(sb.toString().getBytes(StandardCharsets.UTF_8));
    }

    private InputStream dumpEnvironmentVariables() {
        StringBuilder sb = new StringBuilder();
        System.getenv().forEach((key, value) -> {
            sb.append((String)key);
            sb.append("=");
            sb.append((String)value);
            sb.append("\n");
        });
        return new ByteArrayInputStream(sb.toString().getBytes(StandardCharsets.UTF_8));
    }

    private ZipParameters createZipParameters() {
        ZipParameters zipParameters = new ZipParameters();
        zipParameters.setCompressionMethod(CompressionMethod.DEFLATE);
        zipParameters.setEncryptionMethod(EncryptionMethod.AES);
        zipParameters.setAesKeyStrength(AesKeyStrength.KEY_STRENGTH_256);
        zipParameters.setEncryptFiles(true);
        return zipParameters;
    }
}

