/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components.combobox;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.tinymediamanager.ui.components.combobox.TmmCheckComboBox;
import org.tinymediamanager.ui.components.combobox.TmmCheckComboBoxItem;

class TmmCheckComboBoxFilterDecorator<E> {
    private final TmmCheckComboBox<E> comboBox;
    private final BiPredicate<E, String> userFilter;
    private final TextHandler textHandler = new TextHandler();
    private List<TmmCheckComboBoxItem<E>> items;
    private DefaultComboBoxModel<TmmCheckComboBoxItem<E>> model;
    private Popup filterPopup;
    private JLabel filterLabel;
    private Object selectedItem;
    private boolean doNotClearFilterOnPopupHide = false;

    public TmmCheckComboBoxFilterDecorator(TmmCheckComboBox<E> comboBox, BiPredicate<E, String> userFilter) {
        this.comboBox = comboBox;
        this.userFilter = userFilter;
    }

    public static <E> TmmCheckComboBoxFilterDecorator<E> decorate(TmmCheckComboBox<E> comboBox, BiPredicate<E, String> userFilter) {
        TmmCheckComboBoxFilterDecorator<E> decorator = new TmmCheckComboBoxFilterDecorator<E>(comboBox, userFilter);
        decorator.init();
        return decorator;
    }

    private void init() {
        this.items = this.comboBox.checkComboBoxItems;
        this.model = (DefaultComboBoxModel)this.comboBox.getModel();
        this.initFilterLabel();
        this.initComboPopupListener();
        this.initComboKeyListener();
    }

    private void initComboKeyListener() {
        this.comboBox.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                char keyChar = e.getKeyChar();
                if (!Character.isDefined(keyChar)) {
                    return;
                }
                int keyCode = e.getKeyCode();
                switch (keyCode) {
                    case 127: {
                        return;
                    }
                    case 10: {
                        TmmCheckComboBoxFilterDecorator.this.resetFilterPopup();
                        e.consume();
                        return;
                    }
                    case 27: {
                        if (TmmCheckComboBoxFilterDecorator.this.selectedItem != null) {
                            TmmCheckComboBoxFilterDecorator.this.comboBox.setSelectedItem(TmmCheckComboBoxFilterDecorator.this.selectedItem);
                        }
                        TmmCheckComboBoxFilterDecorator.this.resetFilterPopup();
                        e.consume();
                        return;
                    }
                    case 8: {
                        TmmCheckComboBoxFilterDecorator.this.textHandler.removeCharAtEnd();
                        break;
                    }
                    default: {
                        TmmCheckComboBoxFilterDecorator.this.textHandler.add(keyChar);
                    }
                }
                TmmCheckComboBoxFilterDecorator.this.doNotClearFilterOnPopupHide = true;
                TmmCheckComboBoxFilterDecorator.this.comboBox.getUI().setPopupVisible(TmmCheckComboBoxFilterDecorator.this.comboBox, false);
                if (!TmmCheckComboBoxFilterDecorator.this.textHandler.text.isEmpty()) {
                    TmmCheckComboBoxFilterDecorator.this.showFilterPopup();
                    TmmCheckComboBoxFilterDecorator.this.performFilter();
                } else {
                    TmmCheckComboBoxFilterDecorator.this.resetFilterPopup();
                }
                TmmCheckComboBoxFilterDecorator.this.doNotClearFilterOnPopupHide = false;
                TmmCheckComboBoxFilterDecorator.this.comboBox.getUI().setPopupVisible(TmmCheckComboBoxFilterDecorator.this.comboBox, true);
                e.consume();
            }
        });
    }

    private void initFilterLabel() {
        this.filterLabel = new JLabel();
        this.filterLabel.setOpaque(true);
        this.filterLabel.setBackground(UIManager.getColor("Table.selectionBackground"));
        this.filterLabel.setForeground(UIManager.getColor("Table.selectionForeground"));
        Insets margin = UIManager.getInsets("TextField.margin");
        this.filterLabel.setBorder(BorderFactory.createCompoundBorder(UIManager.getBorder("PopupMenu.border"), BorderFactory.createEmptyBorder(margin.top, margin.left, margin.bottom, margin.right)));
    }

    public JLabel getFilterLabel() {
        return this.filterLabel;
    }

    private void initComboPopupListener() {
        this.comboBox.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                if (TmmCheckComboBoxFilterDecorator.this.doNotClearFilterOnPopupHide) {
                    return;
                }
                TmmCheckComboBoxFilterDecorator.this.resetFilterPopup();
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                if (TmmCheckComboBoxFilterDecorator.this.doNotClearFilterOnPopupHide) {
                    return;
                }
                TmmCheckComboBoxFilterDecorator.this.resetFilterPopup();
            }
        });
    }

    private void showFilterPopup() {
        if (this.textHandler.getText().isEmpty()) {
            return;
        }
        if (this.filterPopup == null) {
            Point p = new Point(0, 0);
            SwingUtilities.convertPointToScreen(p, this.comboBox);
            this.filterLabel.setPreferredSize(new Dimension(this.comboBox.getSize()));
            this.filterPopup = PopupFactory.getSharedInstance().getPopup(this.comboBox, this.filterLabel, p.x, p.y - this.filterLabel.getPreferredSize().height);
            this.selectedItem = this.comboBox.getSelectedItem();
        }
        this.filterPopup.show();
    }

    private void resetFilterPopup() {
        if (!this.textHandler.isEditing()) {
            return;
        }
        if (this.filterPopup != null) {
            this.filterPopup.hide();
            this.filterPopup = null;
            this.filterLabel.setText("");
            this.textHandler.reset();
            this.model.removeAllElements();
            this.model.addAll(this.items);
        }
    }

    private void performFilter() {
        this.filterLabel.setText(this.textHandler.getText());
        this.model.removeAllElements();
        ArrayList<TmmCheckComboBoxItem<E>> filteredItems = new ArrayList<TmmCheckComboBoxItem<E>>();
        for (TmmCheckComboBoxItem<E> item : this.items) {
            if (item.getUserObject() != null && this.userFilter.test(item.getUserObject(), this.textHandler.getText())) {
                filteredItems.add(item);
                continue;
            }
            if (item.getUserObject() != null) continue;
            filteredItems.add(item);
        }
        this.model.addAll(filteredItems);
        this.comboBox.update();
    }

    private static class TextHandler {
        private String text = "";
        private boolean editing;

        private TextHandler() {
        }

        public void add(char c) {
            this.text = this.text + c;
            this.editing = true;
        }

        public void removeCharAtEnd() {
            if (this.text.length() > 0) {
                this.text = this.text.substring(0, this.text.length() - 1);
                this.editing = true;
            }
        }

        public void reset() {
            this.text = "";
            this.editing = false;
        }

        public String getText() {
            return this.text;
        }

        public boolean isEditing() {
            return this.editing;
        }
    }
}

