/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.filters;

import java.util.List;
import java.util.Locale;
import javax.swing.JLabel;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaStreamInfo;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.tvshows.filters.AbstractCheckComboBoxTvShowUIFilter;

public class TvShowSubtitleTypeFilter
extends AbstractCheckComboBoxTvShowUIFilter<MediaStreamInfo.Flags> {
    public TvShowSubtitleTypeFilter() {
        this.checkComboBox.enableFilter((s, s2) -> s.toString().toLowerCase(Locale.ROOT).contains(s2.toLowerCase(Locale.ROOT)));
        this.checkComboBox.setItems(List.of(MediaStreamInfo.Flags.FLAG_DEFAULT, MediaStreamInfo.Flags.FLAG_FORCED, MediaStreamInfo.Flags.FLAG_HEARING_IMPAIRED));
    }

    @Override
    protected String parseTypeToString(MediaStreamInfo.Flags type) throws Exception {
        return type.name();
    }

    @Override
    protected MediaStreamInfo.Flags parseStringToType(String string) throws Exception {
        try {
            return MediaStreamInfo.Flags.valueOf(string);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    @Override
    protected boolean accept(TvShow tvShow, List<TvShowEpisode> episodes, boolean invert) {
        List selectedItems = this.checkComboBox.getSelectedItems();
        for (TvShowEpisode episode : episodes) {
            List<MediaStreamInfo.Flags> types = episode.getMediaInfoSubtitleTypeList();
            for (MediaStreamInfo.Flags sel : selectedItems) {
                if (!(invert ^ types.contains((Object)sel))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("metatag.subtitletype"));
    }

    @Override
    public String getId() {
        return "tvShowSubtitleType";
    }
}

