/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.muxer.tracks.h264.parsing.model;

import java.io.IOException;
import org.mp4parser.muxer.tracks.h264.parsing.read.CAVLCReader;
import org.mp4parser.muxer.tracks.h264.parsing.write.CAVLCWriter;

public class ScalingList {
    public int[] scalingList;
    public boolean useDefaultScalingMatrixFlag;

    public static ScalingList read(CAVLCReader is, int sizeOfScalingList) throws IOException {
        ScalingList sl = new ScalingList();
        sl.scalingList = new int[sizeOfScalingList];
        int lastScale = 8;
        int nextScale = 8;
        for (int j = 0; j < sizeOfScalingList; ++j) {
            if (nextScale != 0) {
                int deltaScale = is.readSE("deltaScale");
                nextScale = (lastScale + deltaScale + 256) % 256;
                sl.useDefaultScalingMatrixFlag = j == 0 && nextScale == 0;
            }
            sl.scalingList[j] = nextScale == 0 ? lastScale : nextScale;
            lastScale = sl.scalingList[j];
        }
        return sl;
    }

    public void write(CAVLCWriter out) throws IOException {
        if (this.useDefaultScalingMatrixFlag) {
            out.writeSE(0, "SPS: ");
            return;
        }
        int lastScale = 8;
        int nextScale = 8;
        for (int j = 0; j < this.scalingList.length; ++j) {
            if (nextScale != 0) {
                int deltaScale = this.scalingList[j] - lastScale - 256;
                out.writeSE(deltaScale, "SPS: ");
            }
            lastScale = this.scalingList[j];
        }
    }

    public String toString() {
        return "ScalingList{scalingList=" + this.scalingList + ", useDefaultScalingMatrixFlag=" + this.useDefaultScalingMatrixFlag + '}';
    }
}

