/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.scraper.SubtitleSearchResult;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.scraper.exceptions.ScrapeException;

public class TvShowSubtitleChooserModel
extends AbstractModelObject {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowSubtitleChooserModel.class);
    public static final TvShowSubtitleChooserModel EMPTY_RESULT = new TvShowSubtitleChooserModel();
    private MediaLanguages language = null;
    private SubtitleSearchResult result = null;
    private String name = "";
    private String releaseName = "";

    public TvShowSubtitleChooserModel(SubtitleSearchResult result, MediaLanguages language) {
        this.result = result;
        this.language = language;
        this.name = result.getTitle();
        this.releaseName = result.getReleaseName();
    }

    private TvShowSubtitleChooserModel() {
        this.name = TmmResourceBundle.getString("chooser.nothingfound");
    }

    public String getName() {
        return this.name;
    }

    public boolean isHearingImpaired() {
        if (this.result == null) {
            return false;
        }
        return this.result.isHearingImpaired();
    }

    public boolean isMachineTranslated() {
        if (this.result == null) {
            return false;
        }
        return this.result.isMachineTranslated() || this.result.isAiTranslated();
    }

    public String getReleaseName() {
        return this.releaseName;
    }

    public String getDownloadUrl() throws ScrapeException {
        if (this.result == null) {
            return "";
        }
        return this.result.getUrl();
    }

    public MediaLanguages getLanguage() {
        return this.language;
    }
}

