/*
 * Decompiled with CFR 0.152.
 */
package com.floreysoft.jmte.token;

import com.floreysoft.jmte.TemplateContext;
import com.floreysoft.jmte.token.ExpressionToken;
import com.floreysoft.jmte.util.Util;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class IfToken
extends ExpressionToken {
    public static final String IF = "if";
    protected final boolean negated;

    public IfToken(String expression, boolean negated) {
        super(expression);
        this.negated = negated;
    }

    public IfToken(List<String> segments, String expression, boolean negated) {
        super(segments, expression);
        this.negated = negated;
    }

    @Override
    public String getText() {
        if (this.text == null) {
            this.text = "if " + this.getExpression();
        }
        return this.text;
    }

    public boolean isNegated() {
        return this.negated;
    }

    @Override
    public Object evaluate(TemplateContext context) {
        boolean condition;
        Object value = this.evaluatePlain(context);
        if (value == null || value.toString().equals("") || value.toString().equalsIgnoreCase("false")) {
            condition = false;
        } else if (value instanceof Boolean) {
            condition = (Boolean)value;
        } else if (value instanceof Map) {
            condition = !((Map)value).isEmpty();
        } else if (value instanceof Collection) {
            condition = !((Collection)value).isEmpty();
        } else if (value instanceof Iterable) {
            Iterator iterator = ((Iterable)value).iterator();
            condition = iterator.hasNext();
        } else {
            List<Object> list = Util.arrayAsList(value);
            boolean bl = condition = list == null || !list.isEmpty();
        }
        boolean evaluated = this.negated ? !condition : condition;
        return evaluated;
    }

    @Override
    public String emit() {
        return this.getText();
    }
}

